/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal;

import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.InvocationHandler;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import java.util.concurrent.locks.ReentrantLock;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.internal.expectations.mocking.MockedBridge;
import mockit.internal.faking.FakeBridge;
import mockit.internal.faking.FakeMethodBridge;
import mockit.internal.util.ClassLoad;
import mockit.internal.util.StackTrace;

public abstract class ClassLoadingBridge
implements InvocationHandler {
    private static final Object[] EMPTY_ARGS = new Object[0];
    private static final ReentrantLock LOCK = new ReentrantLock();
    private static boolean fieldsSet;
    public static String hostJREClassName;
    public final String id;

    protected ClassLoadingBridge(@Nonnull String id) {
        this.id = id;
    }

    protected static boolean notToBeMocked(@Nullable Object instance, @Nonnull String classDesc) {
        return (instance == null && "java/lang/System".equals(classDesc) || instance != null && ClassLoadingBridge.instanceOfClassThatParticipatesInClassLoading(instance.getClass())) && ClassLoadingBridge.wasCalledDuringClassLoading();
    }

    public static boolean instanceOfClassThatParticipatesInClassLoading(@Nonnull Class<?> aClass) {
        return aClass == System.class || aClass == File.class || aClass == URL.class || aClass == FileInputStream.class || aClass == Manifest.class || JarFile.class.isAssignableFrom(aClass) || JarEntry.class.isAssignableFrom(aClass) || Vector.class.isAssignableFrom(aClass) || Hashtable.class.isAssignableFrom(aClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean wasCalledDuringClassLoading() {
        if (LOCK.isHeldByCurrentThread()) {
            return true;
        }
        LOCK.lock();
        try {
            StackTrace st = new StackTrace(new Throwable());
            int n = st.getDepth();
            for (int i = 3; i < n; ++i) {
                StackTraceElement ste = st.getElement(i);
                if (!"ClassLoader.java".equals(ste.getFileName()) || !"loadClass getResource loadLibrary".contains(ste.getMethodName())) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            LOCK.unlock();
        }
    }

    @Nonnull
    protected static Object[] extractArguments(@Nonnegative int startingIndex, @Nonnull Object[] args) {
        if (args.length > startingIndex) {
            Object[] targetMemberArgs = new Object[args.length - startingIndex];
            System.arraycopy(args, startingIndex, targetMemberArgs, 0, targetMemberArgs.length);
            return targetMemberArgs;
        }
        return EMPTY_ARGS;
    }

    @Nonnull
    static String getHostClassName() {
        if (!fieldsSet) {
            ClassLoadingBridge.setBridgeFields();
            fieldsSet = true;
        }
        return hostJREClassName;
    }

    private static void setBridgeFields() {
        Class hostClass = ClassLoad.loadByInternalName(hostJREClassName);
        ClassLoadingBridge.setBridgeField(hostClass, MockedBridge.MB);
        ClassLoadingBridge.setBridgeField(hostClass, FakeBridge.MB);
        ClassLoadingBridge.setBridgeField(hostClass, FakeMethodBridge.MB);
    }

    private static void setBridgeField(@Nonnull Class<?> hostClass, @Nonnull ClassLoadingBridge bridge) {
        try {
            hostClass.getDeclaredField(bridge.id).set(null, bridge);
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

