/*
 * Decompiled with CFR 0.152.
 */
package mockit.integration.testng;

import java.lang.reflect.Method;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.Deencapsulation;
import mockit.Invocation;
import mockit.Mock;
import mockit.MockUp;
import mockit.coverage.testRedundancy.TestCoverage;
import mockit.integration.internal.TestRunnerDecorator;
import mockit.internal.faking.FakeInvocation;
import mockit.internal.startup.Startup;
import mockit.internal.state.SavePoint;
import mockit.internal.state.TestRun;
import mockit.internal.util.StackTrace;
import mockit.internal.util.Utilities;
import org.testng.IExecutionListener;
import org.testng.IInvokedMethod;
import org.testng.IInvokedMethodListener;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.TestException;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.testng.internal.Invoker;

public final class TestNGRunnerDecorator
extends TestRunnerDecorator
implements IInvokedMethodListener,
IExecutionListener {
    @Nonnull
    private final ThreadLocal<SavePoint> savePoint = new ThreadLocal();

    private static boolean isMethodWithParametersProvidedByTestNG(@Nonnull Method method) {
        if (method.isAnnotationPresent(Parameters.class)) {
            return true;
        }
        Test testMetadata = method.getAnnotation(Test.class);
        return testMetadata != null && !testMetadata.dataProvider().isEmpty();
    }

    private static Object[] injectParameters(Object[] parameterValues, Method method) {
        if (method == null) {
            return parameterValues;
        }
        Class<?>[] parameterTypes = method.getParameterTypes();
        int numParameters = parameterTypes.length;
        if (numParameters == 0) {
            return parameterValues;
        }
        if (TestNGRunnerDecorator.isMethodWithParametersProvidedByTestNG(method)) {
            return parameterValues;
        }
        Object[] mockValues = new Object[numParameters];
        for (int i = 0; i < numParameters; ++i) {
            Class<?> parameterType = parameterTypes[i];
            mockValues[i] = Deencapsulation.newUninitializedInstance(parameterType);
        }
        return mockValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeInvocation(@Nonnull IInvokedMethod invokedMethod, @Nonnull ITestResult testResult) {
        ITestNGMethod testNGMethod = testResult.getMethod();
        Class testClass = testResult.getTestClass().getRealClass();
        TestRun.clearNoMockingZone();
        if (!invokedMethod.isTestMethod()) {
            this.beforeConfigurationMethod(testNGMethod, testClass);
            return;
        }
        Method method = testNGMethod.getConstructorOrMethod().getMethod();
        TestNGRunnerDecorator.exportCurrentTestMethodIfApplicable(method);
        Object testInstance = testResult.getInstance();
        if (testInstance == null || testInstance.getClass() != testClass) {
            return;
        }
        TestRun.enterNoMockingZone();
        try {
            Object[] parameters;
            Object[] mockParameters;
            TestNGRunnerDecorator.updateTestClassState(testInstance, testClass);
            TestRun.setRunningIndividualTest(testInstance);
            SavePoint testMethodSavePoint = new SavePoint();
            this.savePoint.set(testMethodSavePoint);
            if (this.shouldPrepareForNextTest) {
                TestRun.prepareForNextTest();
                this.shouldPrepareForNextTest = false;
                TestNGRunnerDecorator.clearTestedObjectsCreatedDuringSetup();
            }
            TestNGRunnerDecorator.createInstancesForTestedFieldsFromBaseClasses(testInstance);
            if (!TestNGRunnerDecorator.isMethodWithParametersProvidedByTestNG(method) && (mockParameters = TestNGRunnerDecorator.createInstancesForAnnotatedParameters(testInstance, method, parameters = testResult.getParameters())) != null) {
                System.arraycopy(mockParameters, 0, parameters, 0, parameters.length);
            }
            TestNGRunnerDecorator.createInstancesForTestedFields(testInstance, false);
        }
        finally {
            TestRun.exitNoMockingZone();
        }
    }

    private static void exportCurrentTestMethodIfApplicable(@Nullable Method testMethod) {
        TestCoverage testCoverage = TestCoverage.INSTANCE;
        if (testCoverage != null) {
            testCoverage.setCurrentTestMethod(testMethod);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void beforeConfigurationMethod(@Nonnull ITestNGMethod method, @Nonnull Class<?> testClass) {
        TestRun.enterNoMockingZone();
        try {
            TestNGRunnerDecorator.updateTestClassState(null, testClass);
            if (method.isBeforeMethodConfiguration()) {
                if (this.shouldPrepareForNextTest) {
                    TestNGRunnerDecorator.discardTestLevelMockedTypes();
                    TestNGRunnerDecorator.clearTestedObjectsCreatedDuringSetup();
                }
                Object testInstance = method.getInstance();
                TestNGRunnerDecorator.updateTestClassState(testInstance, testClass);
                if (this.shouldPrepareForNextTest) {
                    TestNGRunnerDecorator.prepareForNextTest();
                    this.shouldPrepareForNextTest = false;
                    TestNGRunnerDecorator.createInstancesForTestedFields(testInstance, true);
                }
                TestRun.setRunningIndividualTest(testInstance);
            } else if (method.isAfterClassConfiguration()) {
                TestRun.getExecutingTest().setRecordAndReplay(null);
                TestNGRunnerDecorator.cleanUpMocksFromPreviousTest();
                TestRun.clearCurrentTestInstance();
            } else if (!method.isAfterMethodConfiguration() && !method.isBeforeClassConfiguration()) {
                TestRun.getExecutingTest().setRecordAndReplay(null);
                TestNGRunnerDecorator.cleanUpMocksFromPreviousTestClass();
                TestRun.clearCurrentTestInstance();
                TestRun.setCurrentTestClass(null);
            }
        }
        finally {
            TestRun.exitNoMockingZone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterInvocation(@Nonnull IInvokedMethod invokedMethod, @Nonnull ITestResult testResult) {
        if (!invokedMethod.isTestMethod()) {
            TestNGRunnerDecorator.afterConfigurationMethod(testResult);
            return;
        }
        TestNGRunnerDecorator.exportCurrentTestMethodIfApplicable(null);
        SavePoint testMethodSavePoint = this.savePoint.get();
        if (testMethodSavePoint == null) {
            return;
        }
        TestRun.enterNoMockingZone();
        this.shouldPrepareForNextTest = true;
        this.savePoint.set(null);
        Throwable thrownByTest = testResult.getThrowable();
        try {
            if (thrownByTest == null) {
                TestNGRunnerDecorator.concludeTestExecutionWithNothingThrown(testMethodSavePoint, testResult);
            } else if (thrownByTest instanceof TestException) {
                TestNGRunnerDecorator.concludeTestExecutionWithExpectedExceptionNotThrown(invokedMethod, testMethodSavePoint, testResult);
            } else if (testResult.isSuccess()) {
                TestNGRunnerDecorator.concludeTestExecutionWithExpectedExceptionThrown(testMethodSavePoint, testResult, thrownByTest);
            } else {
                TestNGRunnerDecorator.concludeTestExecutionWithUnexpectedExceptionThrown(testMethodSavePoint, testResult, thrownByTest);
            }
        }
        finally {
            TestRun.finishCurrentTestExecution();
            TestRun.clearCurrentTestInstance();
        }
    }

    private static void afterConfigurationMethod(@Nonnull ITestResult testResult) {
        TestRun.enterNoMockingZone();
        try {
            Throwable thrownAfterTest;
            ITestNGMethod method = testResult.getMethod();
            if (method.isAfterMethodConfiguration() && (thrownAfterTest = testResult.getThrowable()) != null) {
                StackTrace.filterStackTrace(thrownAfterTest);
            }
        }
        finally {
            TestRun.exitNoMockingZone();
        }
    }

    private static void concludeTestExecutionWithNothingThrown(@Nonnull SavePoint testMethodSavePoint, @Nonnull ITestResult testResult) {
        TestNGRunnerDecorator.clearTestMethodArguments(testResult);
        try {
            TestNGRunnerDecorator.concludeTestMethodExecution(testMethodSavePoint, null, false);
        }
        catch (Throwable t) {
            StackTrace.filterStackTrace(t);
            testResult.setThrowable(t);
            testResult.setStatus(2);
        }
    }

    private static void clearTestMethodArguments(@Nonnull ITestResult testResult) {
        Method method = testResult.getMethod().getConstructorOrMethod().getMethod();
        if (!TestNGRunnerDecorator.isMethodWithParametersProvidedByTestNG(method)) {
            testResult.setParameters(Utilities.NO_ARGS);
        }
    }

    private static void concludeTestExecutionWithExpectedExceptionNotThrown(@Nonnull IInvokedMethod invokedMethod, @Nonnull SavePoint testMethodSavePoint, @Nonnull ITestResult testResult) {
        TestNGRunnerDecorator.clearTestMethodArguments(testResult);
        try {
            TestNGRunnerDecorator.concludeTestMethodExecution(testMethodSavePoint, null, false);
        }
        catch (Throwable t) {
            StackTrace.filterStackTrace(t);
            if (TestNGRunnerDecorator.isExpectedException(invokedMethod, t)) {
                testResult.setThrowable(null);
                testResult.setStatus(1);
            }
            StackTrace.filterStackTrace(testResult.getThrowable());
        }
    }

    private static void concludeTestExecutionWithExpectedExceptionThrown(@Nonnull SavePoint testMethodSavePoint, @Nonnull ITestResult testResult, @Nonnull Throwable thrownByTest) {
        block2: {
            TestNGRunnerDecorator.clearTestMethodArguments(testResult);
            StackTrace.filterStackTrace(thrownByTest);
            try {
                TestNGRunnerDecorator.concludeTestMethodExecution(testMethodSavePoint, thrownByTest, true);
            }
            catch (Throwable t) {
                if (t == thrownByTest) break block2;
                StackTrace.filterStackTrace(t);
                testResult.setThrowable(t);
                testResult.setStatus(2);
            }
        }
    }

    private static void concludeTestExecutionWithUnexpectedExceptionThrown(@Nonnull SavePoint testMethodSavePoint, @Nonnull ITestResult testResult, @Nonnull Throwable thrownByTest) {
        TestNGRunnerDecorator.clearTestMethodArguments(testResult);
        StackTrace.filterStackTrace(thrownByTest);
        try {
            TestNGRunnerDecorator.concludeTestMethodExecution(testMethodSavePoint, thrownByTest, false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static boolean isExpectedException(@Nonnull IInvokedMethod invokedMethod, @Nonnull Throwable thrownByTest) {
        Method testMethod = invokedMethod.getTestMethod().getConstructorOrMethod().getMethod();
        Class[] expectedExceptions = testMethod.getAnnotation(Test.class).expectedExceptions();
        Class<?> thrownExceptionType = thrownByTest.getClass();
        for (Class expectedException : expectedExceptions) {
            if (!expectedException.isAssignableFrom(thrownExceptionType)) continue;
            return true;
        }
        return false;
    }

    public void onExecutionStart() {
        if (Startup.initializeIfPossible()) {
            new FakeParameters();
            new FakeInvoker();
        }
    }

    public void onExecutionFinish() {
        TestRun.enterNoMockingZone();
        try {
            TestRunnerDecorator.cleanUpAllMocks();
        }
        finally {
            TestRun.clearNoMockingZone();
        }
    }

    public static final class FakeInvoker
    extends MockUp<Invoker> {
        @Mock
        public static Object[] injectParameters(Object[] parameterValues, Method method, ITestContext context, ITestResult testResult) {
            return TestNGRunnerDecorator.injectParameters(parameterValues, method);
        }
    }

    public static final class FakeParameters
    extends MockUp<org.testng.internal.Parameters> {
        @Mock
        public static void checkParameterTypes(String methodName, Class<?>[] parameterTypes, String methodAnnotation, String[] parameterNames) {
        }

        @Mock
        @Nullable
        public static Object getInjectedParameter(@Nonnull Invocation invocation, @Nonnull Class<?> c, @Nullable Method method, ITestContext context, ITestResult testResult) {
            ((FakeInvocation)invocation).prepareToProceedFromNonRecursiveMock();
            Object value = org.testng.internal.Parameters.getInjectedParameter(c, (Method)method, (ITestContext)context, (ITestResult)testResult);
            if (value != null) {
                return value;
            }
            if (method == null) {
                return null;
            }
            if (method.getParameterTypes().length == 0) {
                return null;
            }
            if (TestNGRunnerDecorator.isMethodWithParametersProvidedByTestNG(method)) {
                return null;
            }
            return Deencapsulation.newUninitializedInstance(c);
        }

        @Mock
        public static Object[] injectParameters(Object[] parameterValues, Method method, ITestContext context) {
            return TestNGRunnerDecorator.injectParameters(parameterValues, method);
        }
    }
}

