/*
 * Decompiled with CFR 0.152.
 */
package mockit.integration.springframework;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.internal.injection.BeanExporter;
import org.springframework.beans.factory.BeanNotOfRequiredTypeException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;

final class BeanLookup {
    BeanLookup() {
    }

    @Nonnull
    static Object getBean(@Nonnull BeanExporter beanExporter, @Nonnull String name) {
        Object bean = beanExporter.getBean(name);
        if (bean == null) {
            throw new NoSuchBeanDefinitionException(name);
        }
        return bean;
    }

    @Nonnull
    static <T> T getBean(@Nonnull BeanExporter beanExporter, @Nonnull String name, @Nullable Class<T> requiredType) {
        if (requiredType == null) {
            return (T)BeanLookup.getBean(beanExporter, name);
        }
        Object bean = beanExporter.getBean(name);
        if (bean != null) {
            Class<?> actualType = bean.getClass();
            if (!requiredType.isAssignableFrom(actualType)) {
                throw new BeanNotOfRequiredTypeException(name, requiredType, actualType);
            }
        } else {
            bean = beanExporter.getBean(requiredType);
            if (bean == null) {
                throw new NoSuchBeanDefinitionException(requiredType, "with bean name \"" + name + '\"');
            }
        }
        return (T)bean;
    }

    @Nonnull
    static <T> T getBean(@Nonnull BeanExporter beanExporter, @Nonnull Class<T> requiredType) {
        T bean = beanExporter.getBean(requiredType);
        if (bean == null) {
            throw new NoSuchBeanDefinitionException(requiredType);
        }
        return bean;
    }
}

