/*
 * Decompiled with CFR 0.152.
 */
package mockit.integration.junit5;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.Capturing;
import mockit.Injectable;
import mockit.Mocked;
import mockit.Tested;
import mockit.integration.internal.TestRunnerDecorator;
import mockit.internal.expectations.RecordAndReplayExecution;
import mockit.internal.state.SavePoint;
import mockit.internal.state.TestRun;
import mockit.internal.util.StackTrace;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.BeforeTestExecutionCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.api.extension.TestExecutionExceptionHandler;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;

final class JMockitExtension
extends TestRunnerDecorator
implements BeforeAllCallback,
AfterAllCallback,
TestInstancePostProcessor,
BeforeEachCallback,
AfterEachCallback,
BeforeTestExecutionCallback,
AfterTestExecutionCallback,
ParameterResolver,
TestExecutionExceptionHandler {
    @Nullable
    private SavePoint savePointForTestClass;
    @Nullable
    private SavePoint savePointForTest;
    @Nullable
    private SavePoint savePointForTestMethod;
    @Nullable
    private Throwable thrownByTest;
    private Object[] mockParameters;

    JMockitExtension() {
    }

    public void beforeAll(@Nonnull ExtensionContext context) {
        if (JMockitExtension.isRegularTestClass(context)) {
            Class testClass = context.getTestClass().orElse(null);
            this.savePointForTestClass = new SavePoint();
            TestRun.setCurrentTestClass(testClass);
        }
    }

    private static boolean isRegularTestClass(@Nonnull ExtensionContext context) {
        Class testClass = context.getTestClass().orElse(null);
        return testClass != null && !testClass.isAnnotationPresent(Nested.class);
    }

    public void postProcessTestInstance(@Nonnull Object testInstance, @Nonnull ExtensionContext context) {
        if (JMockitExtension.isRegularTestClass(context)) {
            TestRun.enterNoMockingZone();
            try {
                JMockitExtension.handleMockFieldsForWholeTestClass(testInstance);
            }
            finally {
                TestRun.exitNoMockingZone();
            }
            TestRun.setRunningIndividualTest(testInstance);
        }
    }

    public void beforeEach(@Nonnull ExtensionContext context) {
        Object testInstance = context.getTestInstance().orElse(null);
        if (testInstance == null) {
            return;
        }
        TestRun.prepareForNextTest();
        TestRun.enterNoMockingZone();
        try {
            this.savePointForTest = new SavePoint();
            JMockitExtension.createInstancesForTestedFields(testInstance, true);
        }
        finally {
            TestRun.exitNoMockingZone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeTestExecution(@Nonnull ExtensionContext context) {
        Method testMethod = context.getTestMethod().orElse(null);
        Object testInstance = context.getTestInstance().orElse(null);
        if (testMethod == null || testInstance == null) {
            return;
        }
        TestRun.enterNoMockingZone();
        try {
            this.savePointForTestMethod = new SavePoint();
            JMockitExtension.createInstancesForTestedFieldsFromBaseClasses(testInstance);
            this.mockParameters = JMockitExtension.createInstancesForAnnotatedParameters(testInstance, testMethod, null);
            JMockitExtension.createInstancesForTestedFields(testInstance, false);
        }
        finally {
            TestRun.exitNoMockingZone();
        }
        TestRun.setRunningIndividualTest(testInstance);
    }

    public boolean supportsParameter(@Nonnull ParameterContext parameterContext, @Nonnull ExtensionContext extensionContext) {
        Parameter parameter = parameterContext.getParameter();
        return parameter.isAnnotationPresent(Tested.class) || parameter.isAnnotationPresent(Mocked.class) || parameter.isAnnotationPresent(Injectable.class) || parameter.isAnnotationPresent(Capturing.class);
    }

    public Object resolveParameter(@Nonnull ParameterContext parameterContext, @Nonnull ExtensionContext extensionContext) {
        Parameter parameter = parameterContext.getParameter();
        int parameterIndex = parameterContext.getIndex();
        Object mockParameter = this.mockParameters[parameterIndex];
        return mockParameter;
    }

    public void handleTestExecutionException(@Nonnull ExtensionContext context, @Nonnull Throwable throwable) throws Throwable {
        this.thrownByTest = throwable;
        throw throwable;
    }

    public void afterTestExecution(@Nonnull ExtensionContext context) {
        if (this.savePointForTestMethod != null) {
            TestRun.enterNoMockingZone();
            try {
                this.savePointForTestMethod.rollback();
                this.savePointForTestMethod = null;
                if (this.thrownByTest != null) {
                    StackTrace.filterStackTrace(this.thrownByTest);
                }
                Error expectationsFailure = RecordAndReplayExecution.endCurrentReplayIfAny();
                JMockitExtension.clearTestedObjectsIfAny();
                if (expectationsFailure != null) {
                    StackTrace.filterStackTrace(expectationsFailure);
                    throw expectationsFailure;
                }
            }
            finally {
                TestRun.finishCurrentTestExecution();
                TestRun.exitNoMockingZone();
            }
        }
    }

    public void afterEach(@Nonnull ExtensionContext context) {
        if (this.savePointForTest != null) {
            this.savePointForTest.rollback();
            this.savePointForTest = null;
        }
    }

    public void afterAll(@Nonnull ExtensionContext context) {
        if (this.savePointForTestClass != null && JMockitExtension.isRegularTestClass(context)) {
            this.savePointForTestClass.rollback();
            this.savePointForTestClass = null;
            JMockitExtension.clearFieldTypeRedefinitions();
            TestRun.setCurrentTestClass(null);
        }
    }
}

