/*
 * Decompiled with CFR 0.152.
 */
package mockit.integration.junit4.internal;

import java.lang.reflect.Method;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.integration.internal.TestRunnerDecorator;
import mockit.internal.expectations.RecordAndReplayExecution;
import mockit.internal.faking.FakeInvocation;
import mockit.internal.state.SavePoint;
import mockit.internal.state.TestRun;
import mockit.internal.util.StackTrace;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runners.model.FrameworkMethod;

final class JUnit4TestRunnerDecorator
extends TestRunnerDecorator {
    JUnit4TestRunnerDecorator() {
    }

    @Nullable
    Object invokeExplosively(@Nonnull FakeInvocation invocation, @Nullable Object target, Object ... params) throws Throwable {
        FrameworkMethod it = (FrameworkMethod)invocation.getInvokedInstance();
        if (target == null) {
            try {
                return JUnit4TestRunnerDecorator.executeClassMethod(invocation, params);
            }
            catch (Throwable t) {
                StackTrace.filterStackTrace(t);
                throw t;
            }
        }
        JUnit4TestRunnerDecorator.handleMockingOutsideTestMethods(target);
        if (it.getAnnotation(Test.class) == null) {
            if (this.shouldPrepareForNextTest && it.getAnnotation(Before.class) != null) {
                this.prepareToExecuteSetupMethod(target);
            }
            TestRun.setRunningIndividualTest(target);
            try {
                invocation.prepareToProceedFromNonRecursiveMock();
                Object t = it.invokeExplosively(target, params);
                return t;
            }
            catch (Throwable t) {
                RecordAndReplayExecution.endCurrentReplayIfAny();
                StackTrace.filterStackTrace(t);
                throw t;
            }
            finally {
                if (it.getAnnotation(After.class) != null) {
                    this.shouldPrepareForNextTest = true;
                }
            }
        }
        if (this.shouldPrepareForNextTest) {
            JUnit4TestRunnerDecorator.prepareForNextTest();
        }
        this.shouldPrepareForNextTest = true;
        try {
            JUnit4TestRunnerDecorator.executeTestMethod(invocation, target, params);
            Object t = null;
            return t;
        }
        catch (Throwable t) {
            StackTrace.filterStackTrace(t);
            throw t;
        }
        finally {
            TestRun.finishCurrentTestExecution();
        }
    }

    @Nullable
    private static Object executeClassMethod(@Nonnull FakeInvocation inv, @Nonnull Object[] params) throws Throwable {
        FrameworkMethod method = (FrameworkMethod)inv.getInvokedInstance();
        JUnit4TestRunnerDecorator.handleMockingOutsideTests(method);
        TestRun.clearCurrentTestInstance();
        inv.prepareToProceedFromNonRecursiveMock();
        return method.invokeExplosively(null, params);
    }

    private void prepareToExecuteSetupMethod(@Nonnull Object target) {
        JUnit4TestRunnerDecorator.discardTestLevelMockedTypes();
        JUnit4TestRunnerDecorator.prepareForNextTest();
        this.shouldPrepareForNextTest = false;
        JUnit4TestRunnerDecorator.createInstancesForTestedFields(target, true);
    }

    private static void handleMockingOutsideTests(@Nonnull FrameworkMethod it) {
        Class<?> testClass = it.getMethod().getDeclaringClass();
        TestRun.enterNoMockingZone();
        try {
            Class<?> currentTestClass = TestRun.getCurrentTestClass();
            if (currentTestClass != null && testClass.isAssignableFrom(currentTestClass) && it.getAnnotation(AfterClass.class) != null) {
                JUnit4TestRunnerDecorator.cleanUpMocksFromPreviousTest();
            }
            if (it.getAnnotation(BeforeClass.class) != null) {
                JUnit4TestRunnerDecorator.updateTestClassState(null, testClass);
            }
        }
        finally {
            TestRun.exitNoMockingZone();
        }
    }

    private static void handleMockingOutsideTestMethods(@Nonnull Object target) {
        Class<?> testClass = target.getClass();
        TestRun.enterNoMockingZone();
        try {
            JUnit4TestRunnerDecorator.updateTestClassState(target, testClass);
        }
        finally {
            TestRun.exitNoMockingZone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void executeTestMethod(@Nonnull FakeInvocation invocation, @Nonnull Object testInstance, Object ... parameters) throws Throwable {
        SavePoint savePoint = new SavePoint();
        TestRun.setRunningIndividualTest(testInstance);
        FrameworkMethod it = (FrameworkMethod)invocation.getInvokedInstance();
        Method testMethod = it.getMethod();
        Throwable testFailure = null;
        boolean testFailureExpected = false;
        try {
            JUnit4TestRunnerDecorator.createInstancesForTestedFieldsFromBaseClasses(testInstance);
            Object[] annotatedParameters = JUnit4TestRunnerDecorator.createInstancesForAnnotatedParameters(testInstance, testMethod, parameters);
            JUnit4TestRunnerDecorator.createInstancesForTestedFields(testInstance, false);
            invocation.prepareToProceedFromNonRecursiveMock();
            Object[] params = annotatedParameters == null ? parameters : annotatedParameters;
            it.invokeExplosively(testInstance, params);
        }
        catch (Throwable thrownByTest) {
            testFailure = thrownByTest;
            Class expectedType = testMethod.getAnnotation(Test.class).expected();
            testFailureExpected = expectedType.isAssignableFrom(thrownByTest.getClass());
        }
        finally {
            JUnit4TestRunnerDecorator.concludeTestMethodExecution(savePoint, testFailure, testFailureExpected);
        }
    }
}

