/*
 * Decompiled with CFR 0.152.
 */
package mockit.integration.internal;

import java.lang.reflect.Method;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.internal.expectations.RecordAndReplayExecution;
import mockit.internal.expectations.invocation.MissingInvocation;
import mockit.internal.expectations.invocation.UnexpectedInvocation;
import mockit.internal.expectations.mocking.FieldTypeRedefinitions;
import mockit.internal.expectations.mocking.ParameterTypeRedefinitions;
import mockit.internal.expectations.mocking.TypeRedefinitions;
import mockit.internal.injection.TestedClassInstantiations;
import mockit.internal.injection.TestedParameters;
import mockit.internal.state.SavePoint;
import mockit.internal.state.TestRun;
import mockit.internal.util.ParameterNameExtractor;
import mockit.internal.util.StackTrace;
import mockit.internal.util.TestMethod;

public class TestRunnerDecorator {
    @Nullable
    private static SavePoint savePointForTestClass;
    @Nullable
    private static SavePoint savePointForTest;
    protected volatile boolean shouldPrepareForNextTest = true;

    protected TestRunnerDecorator() {
    }

    protected static void updateTestClassState(@Nullable Object target, @Nonnull Class<?> testClass) {
        testClass = TestRunnerDecorator.getActualTestClass(testClass);
        try {
            TestRunnerDecorator.handleSwitchToNewTestClassIfApplicable(testClass);
            if (target != null) {
                TestRunnerDecorator.handleMockFieldsForWholeTestClass(target);
            }
        }
        catch (Error e) {
            try {
                TestRunnerDecorator.rollbackForTestClass();
            }
            catch (Error err) {
                StackTrace.filterStackTrace(err);
                throw err;
            }
            throw e;
        }
        catch (RuntimeException e) {
            TestRunnerDecorator.rollbackForTestClass();
            StackTrace.filterStackTrace(e);
            throw e;
        }
    }

    @Nonnull
    private static Class<?> getActualTestClass(@Nonnull Class<?> testClass) {
        return testClass.isSynthetic() ? testClass.getSuperclass() : testClass;
    }

    private static void handleSwitchToNewTestClassIfApplicable(@Nonnull Class<?> testClass) {
        Class<?> currentTestClass = TestRun.getCurrentTestClass();
        if (testClass != currentTestClass) {
            if (currentTestClass == null) {
                savePointForTestClass = new SavePoint();
            } else if (!currentTestClass.isAssignableFrom(testClass)) {
                TestRunnerDecorator.cleanUpMocksFromPreviousTestClass();
                savePointForTestClass = new SavePoint();
            }
            TestRun.setCurrentTestClass(testClass);
        }
    }

    public static void cleanUpMocksFromPreviousTestClass() {
        TestRunnerDecorator.cleanUpMocks(true);
    }

    protected static void cleanUpMocksFromPreviousTest() {
        TestRunnerDecorator.cleanUpMocks(false);
    }

    public static void cleanUpAllMocks() {
        TestRunnerDecorator.cleanUpMocks(true);
        TestRun.getFakeClasses().discardStartupFakes();
    }

    private static void cleanUpMocks(boolean forTestClassAsWell) {
        TestRunnerDecorator.discardTestLevelMockedTypes();
        if (forTestClassAsWell) {
            TestRunnerDecorator.rollbackForTestClass();
        }
        TestRunnerDecorator.clearFieldTypeRedefinitions();
    }

    private static void rollbackForTestClass() {
        SavePoint savePoint = savePointForTestClass;
        if (savePoint != null) {
            savePoint.rollback();
            savePointForTestClass = null;
        }
    }

    protected static void clearFieldTypeRedefinitions() {
        FieldTypeRedefinitions fieldTypeRedefinitions = TestRun.getFieldTypeRedefinitions();
        if (fieldTypeRedefinitions != null) {
            ((TypeRedefinitions)fieldTypeRedefinitions).cleanUp();
            TestRun.setFieldTypeRedefinitions(null);
        }
    }

    protected static void prepareForNextTest() {
        if (savePointForTest == null) {
            savePointForTest = new SavePoint();
        }
        TestRun.prepareForNextTest();
    }

    protected static void discardTestLevelMockedTypes() {
        SavePoint savePoint = savePointForTest;
        if (savePoint != null) {
            savePoint.rollback();
            savePointForTest = null;
        }
    }

    protected static void handleMockFieldsForWholeTestClass(@Nonnull Object target) {
        Class<?> testClass = TestRunnerDecorator.getActualTestClass(target.getClass());
        FieldTypeRedefinitions fieldTypeRedefinitions = TestRun.getFieldTypeRedefinitions();
        if (fieldTypeRedefinitions == null) {
            ParameterNameExtractor.extractNames(testClass);
            fieldTypeRedefinitions = new FieldTypeRedefinitions(testClass);
            TestRun.setFieldTypeRedefinitions(fieldTypeRedefinitions);
            TestedClassInstantiations testedClassInstantiations = new TestedClassInstantiations();
            if (!testedClassInstantiations.findTestedAndInjectableMembers(testClass)) {
                testedClassInstantiations = null;
            }
            TestRun.setTestedClassInstantiations(testedClassInstantiations);
        }
        if (target != TestRun.getCurrentTestInstance()) {
            fieldTypeRedefinitions.assignNewInstancesToMockFields(target);
        }
    }

    protected static void createInstancesForTestedFieldsFromBaseClasses(@Nonnull Object testClassInstance) {
        TestedClassInstantiations testedClasses = TestRun.getTestedClassInstantiations();
        if (testedClasses != null) {
            TestRun.enterNoMockingZone();
            try {
                testedClasses.assignNewInstancesToTestedFieldsFromBaseClasses(testClassInstance);
            }
            finally {
                TestRun.exitNoMockingZone();
            }
        }
    }

    protected static void createInstancesForTestedFields(@Nonnull Object testClassInstance, boolean beforeSetup) {
        TestedClassInstantiations testedClasses = TestRun.getTestedClassInstantiations();
        if (testedClasses != null) {
            TestRun.enterNoMockingZone();
            try {
                testedClasses.assignNewInstancesToTestedFields(testClassInstance, beforeSetup);
            }
            finally {
                TestRun.exitNoMockingZone();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected static Object[] createInstancesForAnnotatedParameters(@Nonnull Object testClassInstance, @Nonnull Method testMethod, @Nullable Object[] parameterValues) {
        int numParameters = testMethod.getParameterTypes().length;
        if (numParameters == 0) {
            return null;
        }
        if (parameterValues == null || parameterValues.length != numParameters) {
            parameterValues = new Object[numParameters];
        }
        TestMethod methodInfo = new TestMethod(testMethod, parameterValues);
        TestRun.enterNoMockingZone();
        try {
            ParameterTypeRedefinitions redefinitions = new ParameterTypeRedefinitions(methodInfo, parameterValues);
            TestRun.getExecutingTest().setParameterRedefinitions(redefinitions);
            TestedParameters testedParameters = new TestedParameters(methodInfo);
            testedParameters.createTestedParameters(testClassInstance, redefinitions);
        }
        finally {
            TestRun.exitNoMockingZone();
        }
        return parameterValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void concludeTestMethodExecution(@Nonnull SavePoint savePoint, @Nullable Throwable thrownByTest, boolean thrownAsExpected) throws Throwable {
        TestRun.enterNoMockingZone();
        Error expectationsFailure = RecordAndReplayExecution.endCurrentReplayIfAny();
        try {
            TestRunnerDecorator.clearTestedObjectsIfAny();
        }
        finally {
            savePoint.rollback();
            TestRun.exitNoMockingZone();
        }
        if (thrownByTest != null) {
            if (expectationsFailure == null || !thrownAsExpected || TestRunnerDecorator.isUnexpectedOrMissingInvocation(thrownByTest)) {
                throw thrownByTest;
            }
            Throwable expectationsFailureCause = expectationsFailure.getCause();
            if (expectationsFailureCause != null) {
                expectationsFailureCause.initCause(thrownByTest);
            }
        }
        if (expectationsFailure != null) {
            throw expectationsFailure;
        }
    }

    protected static void clearTestedObjectsIfAny() {
        TestedClassInstantiations testedClasses = TestRun.getTestedClassInstantiations();
        if (testedClasses != null) {
            testedClasses.clearTestedObjects();
        }
    }

    protected static void clearTestedObjectsCreatedDuringSetup() {
        TestedClassInstantiations testedClasses = TestRun.getTestedClassInstantiations();
        if (testedClasses != null) {
            testedClasses.clearTestedObjectsCreatedDuringSetup();
        }
    }

    private static boolean isUnexpectedOrMissingInvocation(@Nonnull Throwable error) {
        Class<?> errorType = error.getClass();
        return errorType == UnexpectedInvocation.class || errorType == MissingInvocation.class;
    }
}

