/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.modification;

import java.lang.instrument.ClassDefinition;
import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.asm.ClassReader;
import mockit.coverage.modification.ClassSelection;
import mockit.coverage.modification.CoverageModifier;
import mockit.coverage.modification.VisitInterruptedException;
import mockit.internal.startup.Startup;

public final class ClassModification {
    private static final Class<?>[] NO_CLASSES = new Class[0];
    @Nonnull
    private final Set<String> modifiedClasses = new HashSet<String>();
    @Nonnull
    final List<ProtectionDomain> protectionDomainsWithUniqueLocations = new ArrayList<ProtectionDomain>();
    @Nonnull
    private final ClassSelection classSelection = new ClassSelection();

    public ClassModification() {
        this.redefineClassesAlreadyLoadedForCoverage();
    }

    private void redefineClassesAlreadyLoadedForCoverage() {
        Class[] loadedClasses;
        Instrumentation inst = Startup.instrumentation();
        Class<?>[] previousLoadedClasses = NO_CLASSES;
        while ((loadedClasses = inst.getAllLoadedClasses()).length > previousLoadedClasses.length) {
            this.redefineClassesForCoverage(previousLoadedClasses, loadedClasses);
            previousLoadedClasses = loadedClasses;
        }
    }

    private void redefineClassesForCoverage(@Nonnull Class<?>[] previousClasses, @Nonnull Class<?>[] newClasses) {
        int m = previousClasses.length;
        int n = newClasses.length;
        for (int i = 0; i < n; ++i) {
            Class<?> loadedClass = newClasses[i];
            if (i < m && loadedClass == previousClasses[i] || loadedClass.getClassLoader() == null || loadedClass.isAnnotation() || loadedClass.isSynthetic() || !this.isToBeConsideredForCoverage(loadedClass.getName(), loadedClass.getProtectionDomain())) continue;
            this.redefineClassForCoverage(loadedClass);
        }
    }

    private void redefineClassForCoverage(@Nonnull Class<?> loadedClass) {
        byte[] modifiedClassfile = ClassModification.readAndModifyClassForCoverage(loadedClass);
        if (modifiedClassfile != null) {
            ClassModification.redefineClassForCoverage(loadedClass, modifiedClassfile);
            this.registerModifiedClass(loadedClass.getName(), loadedClass.getProtectionDomain());
        }
    }

    private void registerModifiedClass(@Nonnull String className, @Nonnull ProtectionDomain pd) {
        this.modifiedClasses.add(className);
        if (pd.getClassLoader() != null && pd.getCodeSource() != null && pd.getCodeSource().getLocation() != null) {
            this.addProtectionDomainIfHasUniqueNewPath(pd);
        }
    }

    private void addProtectionDomainIfHasUniqueNewPath(@Nonnull ProtectionDomain newPD) {
        String newPath = newPD.getCodeSource().getLocation().getPath();
        for (int i = this.protectionDomainsWithUniqueLocations.size() - 1; i >= 0; --i) {
            ProtectionDomain previousPD = this.protectionDomainsWithUniqueLocations.get(i);
            String previousPath = previousPD.getCodeSource().getLocation().getPath();
            if (previousPath.startsWith(newPath)) {
                return;
            }
            if (!newPath.startsWith(previousPath)) continue;
            this.protectionDomainsWithUniqueLocations.set(i, newPD);
            return;
        }
        this.protectionDomainsWithUniqueLocations.add(newPD);
    }

    @Nullable
    private static byte[] readAndModifyClassForCoverage(@Nonnull Class<?> aClass) {
        try {
            return ClassModification.modifyClassForCoverage(aClass);
        }
        catch (VisitInterruptedException visitInterruptedException) {
        }
        catch (AssertionError | RuntimeException e) {
            ((Throwable)e).printStackTrace();
        }
        return null;
    }

    @Nullable
    private static byte[] modifyClassForCoverage(@Nonnull Class<?> aClass) {
        String className = aClass.getName();
        byte[] modifiedBytecode = CoverageModifier.recoverModifiedByteCodeIfAvailable(className);
        if (modifiedBytecode != null) {
            return modifiedBytecode;
        }
        ClassReader cr = CoverageModifier.createClassReader(aClass);
        return cr == null ? null : ClassModification.modifyClassForCoverage(cr);
    }

    @Nonnull
    private static byte[] modifyClassForCoverage(@Nonnull ClassReader cr) {
        CoverageModifier modifier = new CoverageModifier(cr);
        cr.accept(modifier, 0);
        return modifier.toByteArray();
    }

    private static void redefineClassForCoverage(@Nonnull Class<?> loadedClass, @Nonnull byte[] modifiedClassfile) {
        ClassDefinition[] classDefs = new ClassDefinition[]{new ClassDefinition(loadedClass, modifiedClassfile)};
        try {
            Startup.instrumentation().redefineClasses(classDefs);
        }
        catch (ClassNotFoundException | UnmodifiableClassException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean shouldConsiderClassesNotLoaded() {
        return !this.classSelection.loadedOnly;
    }

    boolean isToBeConsideredForCoverage(@Nonnull String className, @Nonnull ProtectionDomain protectionDomain) {
        return !this.modifiedClasses.contains(className) && this.classSelection.isSelected(className, protectionDomain);
    }

    @Nullable
    public byte[] modifyClass(@Nonnull String className, @Nonnull ProtectionDomain protectionDomain, @Nonnull byte[] originalClassfile) {
        boolean modifyClassForCoverage = this.isToBeConsideredForCoverage(className, protectionDomain);
        if (modifyClassForCoverage) {
            try {
                byte[] modifiedClassfile = ClassModification.modifyClassForCoverage(className, originalClassfile);
                this.registerModifiedClass(className, protectionDomain);
                return modifiedClassfile;
            }
            catch (VisitInterruptedException modifiedClassfile) {
            }
            catch (AssertionError | ClassCircularityError | RuntimeException e) {
                ((Throwable)e).printStackTrace();
            }
        }
        return null;
    }

    @Nonnull
    private static byte[] modifyClassForCoverage(@Nonnull String className, @Nonnull byte[] classBytecode) {
        byte[] modifiedBytecode = CoverageModifier.recoverModifiedByteCodeIfAvailable(className);
        if (modifiedBytecode != null) {
            return modifiedBytecode;
        }
        ClassReader cr = new ClassReader(classBytecode);
        return ClassModification.modifyClassForCoverage(cr);
    }
}

