/*
 * Decompiled with CFR 0.152.
 */
package mockit.asm;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import mockit.asm.Item;
import mockit.asm.JavaType;

class TypeOrMemberItem
extends Item {
    @Nonnull
    String name;
    @Nonnull
    String desc;
    @Nonnegative
    private int argSize;

    TypeOrMemberItem(@Nonnegative int index) {
        super(index);
        this.desc = "";
        this.name = "";
    }

    TypeOrMemberItem(@Nonnegative int index, @Nonnull TypeOrMemberItem item) {
        super(index, item);
        this.name = item.name;
        this.desc = item.desc;
    }

    final void setValuesAndHashcode(@Nonnull String name, @Nonnull String desc, @Nonnegative int hashCodeMultiplier) {
        this.name = name;
        this.desc = desc;
        this.setHashCode(hashCodeMultiplier * name.hashCode() * desc.hashCode());
    }

    @Override
    boolean isEqualTo(@Nonnull Item item) {
        return this.isEqualTo((TypeOrMemberItem)item);
    }

    final boolean isEqualTo(@Nonnull TypeOrMemberItem item) {
        return item.name.equals(this.name) && item.desc.equals(this.desc);
    }

    @Nonnegative
    final int getArgSizeComputingIfNeeded(@Nonnull String desc) {
        int argSize = this.argSize;
        if (argSize == 0) {
            this.argSize = argSize = JavaType.getArgumentsAndReturnSizes(desc);
        }
        return argSize;
    }
}

