/*
 * Decompiled with CFR 0.152.
 */
package mockit.asm;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import mockit.asm.ByteVector;
import mockit.asm.ConstantPoolGeneration;

final class ThrowsClause {
    @Nonnull
    private final int[] exceptions;
    @Nonnegative
    private final int attributeIndex;

    ThrowsClause(@Nonnull ConstantPoolGeneration cp, @Nonnull String[] exceptionTypeDescs) {
        int n = exceptionTypeDescs.length;
        this.exceptions = new int[n];
        for (int i = 0; i < n; ++i) {
            String exceptionTypeDesc = exceptionTypeDescs[i];
            this.exceptions[i] = cp.newClass(exceptionTypeDesc);
        }
        this.attributeIndex = cp.newUTF8("Exceptions");
    }

    @Nonnegative
    int getCount() {
        return this.exceptions.length;
    }

    @Nonnegative
    int getExceptionIndex(@Nonnegative int exceptionIndex) {
        return this.exceptions[exceptionIndex];
    }

    @Nonnegative
    int getSize() {
        return 8 + 2 * this.exceptions.length;
    }

    void put(@Nonnull ByteVector out) {
        int[] exceptions = this.exceptions;
        int n = exceptions.length;
        out.putShort(this.attributeIndex).putInt(2 * n + 2);
        out.putShort(n);
        for (int exception : exceptions) {
            out.putShort(exception);
        }
    }
}

