/*
 * Decompiled with CFR 0.152.
 */
package mockit.asm;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.asm.AttributeWriter;
import mockit.asm.ByteVector;
import mockit.asm.ConstantPoolGeneration;

final class SourceInfoWriter
extends AttributeWriter {
    @Nonnegative
    private int sourceFileIndex;

    SourceInfoWriter(@Nonnull ConstantPoolGeneration cp) {
        super(cp);
    }

    void setSourceFileName(@Nullable String fileName) {
        if (fileName != null) {
            this.setAttribute("SourceFile");
            this.sourceFileIndex = this.cp.newUTF8(fileName);
        }
    }

    @Override
    @Nonnegative
    int getSize() {
        return this.sourceFileIndex == 0 ? 0 : 8;
    }

    @Override
    void put(@Nonnull ByteVector out) {
        if (this.sourceFileIndex > 0) {
            super.put(out);
            out.putShort(this.sourceFileIndex);
        }
    }
}

