/*
 * Decompiled with CFR 0.152.
 */
package mockit.asm;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import mockit.asm.AttributeWriter;
import mockit.asm.ByteVector;
import mockit.asm.ConstantPoolGeneration;

final class SignatureWriter
extends AttributeWriter {
    @Nonnegative
    private final int signatureIndex;

    SignatureWriter(@Nonnull ConstantPoolGeneration cp, @Nonnull String signature) {
        super(cp, "Signature");
        this.signatureIndex = cp.newUTF8(signature);
    }

    @Override
    @Nonnegative
    int getSize() {
        return 8;
    }

    @Override
    void put(@Nonnull ByteVector out) {
        super.put(out);
        out.putShort(this.signatureIndex);
    }
}

