/*
 * Decompiled with CFR 0.152.
 */
package mockit.asm;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.asm.JavaType;

public final class PrimitiveType
extends JavaType {
    private static final Class<?>[] TYPES = new Class[]{Void.TYPE, Boolean.TYPE, Character.TYPE, Byte.TYPE, Short.TYPE, Integer.TYPE, Float.TYPE, Long.TYPE, Double.TYPE};
    private static final String[] WRAPPER_TYPE_DESCS = new String[]{"java/lang/Void", "java/lang/Boolean", "java/lang/Character", "java/lang/Byte", "java/lang/Short", "java/lang/Integer", "java/lang/Float", "java/lang/Long", "java/lang/Double"};
    private static final char[] TYPE_CODES = new char[]{'V', 'Z', 'C', 'B', 'S', 'I', 'F', 'J', 'D'};
    private static final String TYPE_CODES_STR = "VZCBSIFJD";
    private static final int[] ARRAY_ELEMENT_TYPES = new int[]{0, 4, 5, 8, 9, 10, 6, 11, 7};
    private static final PrimitiveType VOID = new PrimitiveType(0, 0);
    private static final PrimitiveType BOOLEAN = new PrimitiveType(1, 5);
    private static final PrimitiveType CHAR = new PrimitiveType(2, 6);
    private static final PrimitiveType BYTE = new PrimitiveType(3, 5);
    private static final PrimitiveType SHORT = new PrimitiveType(4, 7);
    private static final PrimitiveType INT = new PrimitiveType(5, 0);
    private static final PrimitiveType FLOAT = new PrimitiveType(6, 2);
    private static final PrimitiveType LONG = new PrimitiveType(7, 1);
    private static final PrimitiveType DOUBLE = new PrimitiveType(8, 3);
    private static final PrimitiveType[] JAVA_TYPES = new PrimitiveType[]{VOID, BOOLEAN, CHAR, BYTE, SHORT, INT, FLOAT, LONG, DOUBLE};
    @Nonnegative
    private final int index;
    @Nonnegative
    private final int loadOrStoreOffset;
    @Nonnegative
    private final int otherOffset;
    @Nonnegative
    private final int size;
    @Nonnegative
    private final int loadOpcode;
    @Nonnegative
    private final int constOpcode;
    @Nonnull
    private final String wrapperTypeDesc;

    private PrimitiveType(@Nonnegative int index, @Nonnegative int otherOffset) {
        super(1);
        this.index = index;
        this.otherOffset = otherOffset;
        this.wrapperTypeDesc = WRAPPER_TYPE_DESCS[index];
        Class<?> type = TYPES[index];
        if (type == Void.TYPE) {
            this.loadOrStoreOffset = 5;
            this.size = 0;
            this.loadOpcode = 0;
            this.constOpcode = 0;
        } else if (type == Float.TYPE) {
            this.loadOrStoreOffset = 2;
            this.size = 1;
            this.loadOpcode = 23;
            this.constOpcode = 11;
        } else if (type == Long.TYPE) {
            this.loadOrStoreOffset = 1;
            this.size = 2;
            this.loadOpcode = 22;
            this.constOpcode = 9;
        } else if (type == Double.TYPE) {
            this.loadOrStoreOffset = 3;
            this.size = 2;
            this.loadOpcode = 24;
            this.constOpcode = 14;
        } else {
            this.loadOrStoreOffset = 0;
            this.size = 1;
            this.loadOpcode = 21;
            this.constOpcode = 3;
        }
    }

    @Nonnull
    static PrimitiveType getPrimitiveType(@Nonnull Class<?> aClass) {
        for (int i = 0; i < 9; ++i) {
            if (aClass != TYPES[i]) continue;
            return JAVA_TYPES[i];
        }
        throw new IllegalArgumentException("Not a primitive type: " + aClass);
    }

    @Nullable
    static PrimitiveType getPrimitiveType(int typeCode) {
        int i = TYPE_CODES_STR.indexOf(typeCode);
        return i < 0 ? null : JAVA_TYPES[i];
    }

    @Nullable
    public static PrimitiveType getCorrespondingPrimitiveTypeIfWrapperType(@Nonnull String typeDesc) {
        for (int i = 0; i < 9; ++i) {
            if (!typeDesc.equals(WRAPPER_TYPE_DESCS[i])) continue;
            return JAVA_TYPES[i];
        }
        return null;
    }

    @Nonnull
    public static Class<?> getType(int typeCode) {
        int i = TYPE_CODES_STR.indexOf((char)typeCode);
        return TYPES[i];
    }

    public static int getArrayElementType(@Nonnull PrimitiveType elementType) {
        return ARRAY_ELEMENT_TYPES[elementType.index];
    }

    public char getTypeCode() {
        return TYPE_CODES[this.index];
    }

    @Nonnull
    public Class<?> getType() {
        return TYPES[this.index];
    }

    @Nonnull
    public String getWrapperTypeDesc() {
        return this.wrapperTypeDesc;
    }

    @Override
    void getDescriptor(@Nonnull StringBuilder buf) {
        buf.append(this.getTypeCode());
    }

    @Override
    @Nonnull
    public String getClassName() {
        return this.getType().getName();
    }

    @Override
    @Nonnegative
    public int getSize() {
        return this.size;
    }

    @Override
    public int getOpcode(int opcode) {
        int offset = opcode == 46 || opcode == 79 ? this.otherOffset : this.loadOrStoreOffset;
        return opcode + offset;
    }

    @Override
    public int getLoadOpcode() {
        return this.loadOpcode;
    }

    @Override
    public int getConstOpcode() {
        return this.constOpcode;
    }

    public boolean equals(Object o) {
        return this == o || o instanceof PrimitiveType && this.index == ((PrimitiveType)o).index;
    }

    public int hashCode() {
        return 13 * this.index;
    }
}

