/*
 * Decompiled with CFR 0.152.
 */
package mockit.asm;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.asm.AttributeWriter;
import mockit.asm.ByteVector;
import mockit.asm.ConstantPoolGeneration;

final class OuterClassWriter
extends AttributeWriter {
    @Nonnegative
    private final int enclosingMethodOwner;
    @Nonnegative
    private final int enclosingMethod;

    OuterClassWriter(@Nonnull ConstantPoolGeneration cp, @Nonnull String owner, @Nullable String name, @Nullable String desc) {
        super(cp, "EnclosingMethod");
        this.enclosingMethodOwner = cp.newClass(owner);
        this.enclosingMethod = name != null && desc != null ? cp.newNameType(name, desc) : 0;
    }

    @Override
    @Nonnegative
    int getSize() {
        return 10;
    }

    @Override
    void put(@Nonnull ByteVector out) {
        this.put(out, 4);
        out.putShort(this.enclosingMethodOwner).putShort(this.enclosingMethod);
    }
}

