/*
 * Decompiled with CFR 0.152.
 */
package mockit.asm;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.asm.AnnotationVisitor;
import mockit.asm.AnnotationWriter;
import mockit.asm.ByteVector;
import mockit.asm.CFGAnalysis;
import mockit.asm.ClassMemberItem;
import mockit.asm.ClassWriter;
import mockit.asm.ExceptionHandling;
import mockit.asm.Frame;
import mockit.asm.FrameAndStackComputation;
import mockit.asm.InvokeDynamicItem;
import mockit.asm.Item;
import mockit.asm.JavaType;
import mockit.asm.Label;
import mockit.asm.LineNumberWriter;
import mockit.asm.LocalVariables;
import mockit.asm.LongValueItem;
import mockit.asm.MethodHandle;
import mockit.asm.MethodVisitor;
import mockit.asm.SignatureWriter;
import mockit.asm.StringItem;
import mockit.asm.ThrowsClause;

public final class MethodWriter
extends MethodVisitor {
    @Nonnull
    final ClassWriter cw;
    private final int name;
    private final int desc;
    @Nonnull
    final String descriptor;
    @Nullable
    private final SignatureWriter signatureWriter;
    @Nonnegative
    int classReaderOffset;
    @Nonnegative
    int classReaderLength;
    @Nullable
    private final ThrowsClause throwsClause;
    @Nullable
    private AnnotationWriter[] parameterAnnotations;
    @Nonnull
    private final ByteVector code;
    @Nonnull
    private final FrameAndStackComputation frameAndStack;
    @Nonnull
    private final ExceptionHandling exceptionHandling;
    @Nonnull
    private final LocalVariables localVariables;
    @Nonnull
    private final LineNumberWriter lineNumbers;
    @Nonnull
    private final CFGAnalysis cfgAnalysis;
    private final boolean computeFrames;

    MethodWriter(@Nonnull ClassWriter cw, int access, @Nonnull String name, @Nonnull String desc, @Nullable String signature, @Nullable String[] exceptions, boolean computeFrames) {
        this.cw = cw;
        this.cp = cw.cp;
        this.access = "<init>".equals(name) ? access | 0x80000 : access;
        this.name = this.cp.newUTF8(name);
        this.desc = this.cp.newUTF8(desc);
        this.descriptor = desc;
        this.signatureWriter = signature == null ? null : new SignatureWriter(this.cp, signature);
        this.throwsClause = exceptions == null ? null : new ThrowsClause(this.cp, exceptions);
        this.code = new ByteVector();
        this.computeFrames = computeFrames;
        this.frameAndStack = new FrameAndStackComputation(this, access, desc);
        this.exceptionHandling = new ExceptionHandling(this.cp);
        this.localVariables = new LocalVariables(this.cp);
        this.lineNumbers = new LineNumberWriter(this.cp);
        this.cfgAnalysis = new CFGAnalysis(cw, this.code, computeFrames);
        this.createMarkerAttributes(cw.version);
    }

    @Override
    @Nonnull
    public AnnotationVisitor visitAnnotation(@Nonnull String desc) {
        return this.addAnnotation(desc);
    }

    @Override
    @Nonnull
    public AnnotationVisitor visitParameterAnnotation(@Nonnegative int parameter, @Nonnull String desc) {
        AnnotationWriter aw = new AnnotationWriter(this.cp, desc);
        if (this.parameterAnnotations == null) {
            int numParameters = JavaType.getArgumentTypes(this.descriptor).length;
            this.parameterAnnotations = new AnnotationWriter[numParameters];
        }
        aw.next = this.parameterAnnotations[parameter];
        this.parameterAnnotations[parameter] = aw;
        return aw;
    }

    @Override
    public void visitInsn(int opcode) {
        this.code.putByte(opcode);
        this.cfgAnalysis.updateCurrentBlockForZeroOperandInstruction(opcode);
    }

    @Override
    public void visitIntInsn(int opcode, int operand) {
        this.cfgAnalysis.updateCurrentBlockForSingleIntOperandInstruction(opcode, operand);
        if (opcode == 17) {
            this.code.put12(opcode, operand);
        } else {
            this.code.put11(opcode, operand);
        }
    }

    @Override
    public void visitVarInsn(int opcode, @Nonnegative int varIndex) {
        this.cfgAnalysis.updateCurrentBlockForLocalVariableInstruction(opcode, varIndex);
        this.updateMaxLocals(opcode, varIndex);
        if (varIndex < 4) {
            int opt = opcode < 54 ? 26 + (opcode - 21 << 2) + varIndex : 59 + (opcode - 54 << 2) + varIndex;
            this.code.putByte(opt);
        } else if (varIndex >= 256) {
            this.code.putByte(196).put12(opcode, varIndex);
        } else {
            this.code.put11(opcode, varIndex);
        }
        if (opcode >= 54 && this.computeFrames && this.exceptionHandling.hasHandlers()) {
            this.visitLabel(new Label());
        }
    }

    private void updateMaxLocals(int opcode, @Nonnegative int var) {
        int n = opcode == 22 || opcode == 24 || opcode == 55 || opcode == 57 ? var + 2 : var + 1;
        this.frameAndStack.updateMaxLocals(n);
    }

    @Override
    public void visitTypeInsn(int opcode, @Nonnull String typeDesc) {
        StringItem typeItem = this.cp.newClassItem(typeDesc);
        this.cfgAnalysis.updateCurrentBlockForTypeInstruction(opcode, typeItem);
        this.code.put12(opcode, typeItem.index);
    }

    @Override
    public void visitFieldInsn(int opcode, @Nonnull String owner, @Nonnull String name, @Nonnull String desc) {
        ClassMemberItem fieldItem = this.cp.newFieldItem(owner, name, desc);
        this.cfgAnalysis.updateCurrentBlockForFieldInstruction(opcode, fieldItem, desc);
        this.code.put12(opcode, fieldItem.index);
    }

    @Override
    public void visitMethodInsn(int opcode, @Nonnull String owner, @Nonnull String name, @Nonnull String desc, boolean itf) {
        ClassMemberItem invokeItem = this.cp.newMethodItem(owner, name, desc, itf);
        this.cfgAnalysis.updateCurrentBlockForInvokeInstruction(invokeItem, opcode, desc);
        this.code.put12(opcode, invokeItem.index);
        if (opcode == 185) {
            int argSize = invokeItem.getArgSizeComputingIfNeeded(desc);
            this.code.put11(argSize >> 2, 0);
        }
    }

    @Override
    public void visitInvokeDynamicInsn(@Nonnull String name, @Nonnull String desc, @Nonnull MethodHandle bsm, Object ... bsmArgs) {
        InvokeDynamicItem invokeItem = this.cw.bootstrapMethods.addInvokeDynamicReference(name, desc, bsm, bsmArgs);
        this.cfgAnalysis.updateCurrentBlockForInvokeInstruction(invokeItem, 186, desc);
        this.code.put12(186, invokeItem.index);
        this.code.putShort(0);
    }

    @Override
    public void visitJumpInsn(int opcode, @Nonnull Label label) {
        Label nextInsn = this.cfgAnalysis.updateCurrentBlockForJumpInstruction(opcode, label);
        if (label.isResolved() && label.position - this.code.length < Short.MIN_VALUE) {
            if (opcode == 167) {
                this.code.putByte(200);
            } else {
                if (nextInsn != null) {
                    nextInsn.markAsTarget();
                }
                this.code.putByte(opcode <= 166 ? (opcode + 1 ^ 1) - 1 : opcode ^ 1);
                this.code.putShort(8);
                this.code.putByte(200);
            }
            label.put(this.code, this.code.length - 1, true);
        } else {
            this.code.putByte(opcode);
            label.put(this.code, this.code.length - 1, false);
        }
        this.cfgAnalysis.updateCurrentBlockForJumpTarget(opcode, nextInsn);
    }

    @Override
    public void visitLabel(@Nonnull Label label) {
        this.cfgAnalysis.updateCurrentBlockForLabelBeforeNextInstruction(label);
    }

    @Override
    public void visitLdcInsn(@Nonnull Object cst) {
        Item constItem = this.cp.newConstItem(cst);
        this.cfgAnalysis.updateCurrentBlockForLDCInstruction(constItem);
        int index = constItem.index;
        if (constItem instanceof LongValueItem) {
            this.code.put12(20, index);
        } else if (index >= 256) {
            this.code.put12(19, index);
        } else {
            this.code.put11(18, index);
        }
    }

    @Override
    public void visitIincInsn(@Nonnegative int varIndex, int increment) {
        this.cfgAnalysis.updateCurrentBlockForIINCInstruction(varIndex);
        int n = varIndex + 1;
        this.frameAndStack.updateMaxLocals(n);
        if (varIndex > 255 || increment > 127 || increment < -128) {
            this.code.putByte(196).put12(132, varIndex).putShort(increment);
        } else {
            this.code.putByte(132).put11(varIndex, increment);
        }
    }

    @Override
    public void visitTableSwitchInsn(int min, int max, @Nonnull Label dflt, Label ... labels) {
        int source = this.code.length;
        this.code.putByte(170);
        this.code.increaseLengthBy((4 - this.code.length % 4) % 4);
        dflt.put(this.code, source, true);
        this.code.putInt(min).putInt(max);
        for (Label label : labels) {
            label.put(this.code, source, true);
        }
        this.cfgAnalysis.updateCurrentBlockForSwitchInstruction(dflt, labels);
    }

    @Override
    public void visitLookupSwitchInsn(@Nonnull Label dflt, @Nonnull int[] keys, @Nonnull Label[] labels) {
        int source = this.code.length;
        this.code.putByte(171);
        this.code.increaseLengthBy((4 - this.code.length % 4) % 4);
        dflt.put(this.code, source, true);
        this.code.putInt(labels.length);
        for (int i = 0; i < labels.length; ++i) {
            this.code.putInt(keys[i]);
            labels[i].put(this.code, source, true);
        }
        this.cfgAnalysis.updateCurrentBlockForSwitchInstruction(dflt, labels);
    }

    @Override
    public void visitMultiANewArrayInsn(@Nonnull String desc, @Nonnegative int dims) {
        StringItem arrayTypeItem = this.cp.newClassItem(desc);
        this.cfgAnalysis.updateCurrentBlockForMULTIANEWARRAYInstruction(arrayTypeItem, dims);
        this.code.put12(197, arrayTypeItem.index).putByte(dims);
    }

    @Override
    public void visitTryCatchBlock(@Nonnull Label start, @Nonnull Label end, @Nonnull Label handler, @Nullable String type) {
        this.exceptionHandling.addHandler(start, end, handler, type);
    }

    @Override
    public void visitLocalVariable(@Nonnull String name, @Nonnull String desc, @Nullable String signature, @Nonnull Label start, @Nonnull Label end, @Nonnegative int index) {
        int localsCount = this.localVariables.addLocalVariable(name, desc, signature, start, end, index);
        this.frameAndStack.updateMaxLocals(localsCount);
    }

    @Override
    public void visitLineNumber(@Nonnegative int line, @Nonnull Label start) {
        this.lineNumbers.addLineNumber(line, start);
    }

    @Override
    public void visitMaxStack(@Nonnegative int maxStack) {
        int computedMaxStack;
        if (this.computeFrames) {
            this.exceptionHandling.completeControlFlowGraphWithExceptionHandlerBlocksFromComputedFrames();
            Frame firstFrame = this.cfgAnalysis.getFirstFrame();
            this.frameAndStack.createAndVisitFirstFrame(firstFrame);
            computedMaxStack = this.cfgAnalysis.computeMaxStackSizeFromComputedFrames();
            computedMaxStack = this.visitAllFramesToBeStoredInStackMap(computedMaxStack);
            this.exceptionHandling.countNumberOfHandlers();
        } else {
            this.exceptionHandling.completeControlFlowGraphWithExceptionHandlerBlocks();
            computedMaxStack = this.cfgAnalysis.computeMaxStackSize();
            computedMaxStack = Math.max(maxStack, computedMaxStack);
        }
        this.frameAndStack.setMaxStack(computedMaxStack);
    }

    @Nonnegative
    private int visitAllFramesToBeStoredInStackMap(@Nonnegative int max) {
        Label label = this.cfgAnalysis.getLabelForFirstBasicBlock();
        while (label != null) {
            int start;
            Label k;
            int end;
            Frame frame = label.frame;
            if (label.isStoringFrame()) {
                this.frameAndStack.visitFrame(frame);
            }
            if (!label.isReachable() && (end = ((k = label.successor) == null ? this.code.length : k.position) - 1) >= (start = label.position)) {
                max = Math.max(max, 1);
                this.replaceInstructionsWithNOPAndATHROW(start, end);
                this.frameAndStack.emitFrameForUnreachableBlock(start);
                this.exceptionHandling.removeStartEndRange(label, k);
            }
            label = label.successor;
        }
        return max;
    }

    private void replaceInstructionsWithNOPAndATHROW(@Nonnegative int start, @Nonnegative int end) {
        byte[] data = this.code.data;
        for (int i = start; i < end; ++i) {
            data[i] = 0;
        }
        data[end] = -65;
    }

    @Nonnegative
    int getSize() {
        if (this.classReaderOffset > 0) {
            return 6 + this.classReaderLength;
        }
        int size = 8 + this.getMarkerAttributesSize() + this.getAnnotationsSize() + this.getParameterAnnotationsSize();
        int codeLength = this.code.length;
        if (codeLength > 0) {
            if (codeLength > 65536) {
                throw new RuntimeException("Method code too large!");
            }
            this.cp.newUTF8("Code");
            size += 18 + codeLength + this.exceptionHandling.getSize();
            size += this.localVariables.getSizeWhileAddingConstantPoolItems();
            size += this.lineNumbers.getSize();
            size += this.frameAndStack.getSizeWhileAddingConstantPoolItem();
        }
        if (this.throwsClause != null) {
            size += this.throwsClause.getSize();
        }
        if (this.signatureWriter != null) {
            size += this.signatureWriter.getSize();
        }
        return size;
    }

    @Nonnegative
    private int getParameterAnnotationsSize() {
        int size = 0;
        if (this.parameterAnnotations != null) {
            this.cp.newUTF8("RuntimeVisibleParameterAnnotations");
            int n = this.parameterAnnotations.length;
            size += 7 + 2 * n;
            for (int i = n - 1; i >= 0; --i) {
                AnnotationWriter parameterAnnotation = this.parameterAnnotations[i];
                size += parameterAnnotation == null ? 0 : parameterAnnotation.getSize();
            }
        }
        return size;
    }

    @Override
    void put(@Nonnull ByteVector out) {
        this.putAccess(out, 524288);
        out.putShort(this.name);
        out.putShort(this.desc);
        if (this.classReaderOffset > 0) {
            out.putByteArray(this.cw.code, this.classReaderOffset, this.classReaderLength);
            return;
        }
        this.putMethodAttributeCount(out);
        this.putMethodCode(out);
        if (this.throwsClause != null) {
            this.throwsClause.put(out);
        }
        this.putMarkerAttributes(out);
        if (this.signatureWriter != null) {
            this.signatureWriter.put(out);
        }
        this.putAnnotationAttributes(out);
    }

    private void putMethodAttributeCount(@Nonnull ByteVector out) {
        int attributeCount = this.getMarkerAttributeCount();
        if (this.code.length > 0) {
            ++attributeCount;
        }
        if (this.throwsClause != null) {
            ++attributeCount;
        }
        if (this.signatureWriter != null) {
            ++attributeCount;
        }
        if (this.annotations != null) {
            ++attributeCount;
        }
        if (this.parameterAnnotations != null) {
            ++attributeCount;
        }
        out.putShort(attributeCount);
    }

    private void putMethodCode(@Nonnull ByteVector out) {
        if (this.code.length > 0) {
            this.putCodeSize(out);
            this.frameAndStack.putMaxStackAndLocals(out);
            out.putInt(this.code.length).putByteVector(this.code);
            this.exceptionHandling.put(out);
            int codeAttributeCount = this.localVariables.getAttributeCount();
            if (this.lineNumbers.hasLineNumbers()) {
                ++codeAttributeCount;
            }
            if (this.frameAndStack.hasStackMap()) {
                ++codeAttributeCount;
            }
            out.putShort(codeAttributeCount);
            this.localVariables.put(out);
            this.lineNumbers.put(out);
            this.frameAndStack.put(out);
        }
    }

    private void putCodeSize(@Nonnull ByteVector out) {
        int size = 12 + this.code.length + this.exceptionHandling.getSize() + this.localVariables.getSize() + this.lineNumbers.getSize() + this.frameAndStack.getSize();
        out.putShort(this.cp.newUTF8("Code")).putInt(size);
    }

    private void putAnnotationAttributes(@Nonnull ByteVector out) {
        this.putAnnotations(out);
        if (this.parameterAnnotations != null) {
            out.putShort(this.cp.newUTF8("RuntimeVisibleParameterAnnotations"));
            AnnotationWriter.put(out, this.parameterAnnotations);
        }
    }

    @Nullable
    public Label getCurrentBlock() {
        return this.cfgAnalysis.getLabelForCurrentBasicBlock();
    }
}

