/*
 * Decompiled with CFR 0.152.
 */
package mockit.asm;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.asm.ByteVector;
import mockit.asm.ConstantPoolGeneration;
import mockit.asm.Label;

final class LocalVariables {
    @Nonnull
    private final ConstantPoolGeneration cp;
    @Nonnegative
    private int localVarCount;
    @Nullable
    private ByteVector localVarTable;
    @Nonnegative
    private int localVarTypeCount;
    @Nullable
    private ByteVector localVarTypeTable;

    LocalVariables(@Nonnull ConstantPoolGeneration cp) {
        this.cp = cp;
    }

    @Nonnegative
    int addLocalVariable(@Nonnull String name, @Nonnull String desc, @Nullable String signature, @Nonnull Label start, @Nonnull Label end, @Nonnegative int index) {
        if (signature != null) {
            this.localVarTypeTable = this.addAttribute(this.localVarTypeTable, name, signature, start, end, index);
            ++this.localVarTypeCount;
        }
        this.localVarTable = this.addAttribute(this.localVarTable, name, desc, start, end, index);
        ++this.localVarCount;
        char c = desc.charAt(0);
        int n = index + (c == 'J' || c == 'D' ? 2 : 1);
        return n;
    }

    @Nonnull
    private ByteVector addAttribute(@Nullable ByteVector attribute, @Nonnull String name, @Nonnull String desc, @Nonnull Label start, @Nonnull Label end, @Nonnegative int index) {
        if (attribute == null) {
            attribute = new ByteVector();
        }
        attribute.putShort(start.position).putShort(end.position - start.position).putShort(this.cp.newUTF8(name)).putShort(this.cp.newUTF8(desc)).putShort(index);
        return attribute;
    }

    @Nonnegative
    int getSizeWhileAddingConstantPoolItems() {
        this.addItemToConstantPool("LocalVariableTable", this.localVarTable);
        this.addItemToConstantPool("LocalVariableTypeTable", this.localVarTypeTable);
        return this.getSize();
    }

    private void addItemToConstantPool(@Nonnull String attributeName, @Nullable ByteVector attribute) {
        if (attribute != null) {
            this.cp.newUTF8(attributeName);
        }
    }

    @Nonnegative
    int getSize() {
        return LocalVariables.getSize(this.localVarTable) + LocalVariables.getSize(this.localVarTypeTable);
    }

    @Nonnegative
    private static int getSize(@Nullable ByteVector attribute) {
        return attribute == null ? 0 : 8 + attribute.length;
    }

    @Nonnegative
    int getAttributeCount() {
        return (this.localVarTable == null ? 0 : 1) + (this.localVarTypeTable == null ? 0 : 1);
    }

    void put(@Nonnull ByteVector out) {
        this.put(out, "LocalVariableTable", this.localVarTable, this.localVarCount);
        this.put(out, "LocalVariableTypeTable", this.localVarTypeTable, this.localVarTypeCount);
    }

    private void put(@Nonnull ByteVector out, @Nonnull String attributeName, @Nullable ByteVector attribute, @Nonnegative int numEntries) {
        if (attribute != null) {
            out.putShort(this.cp.newUTF8(attributeName));
            out.putInt(attribute.length + 2).putShort(numEntries);
            out.putByteVector(attribute);
        }
    }
}

