/*
 * Decompiled with CFR 0.152.
 */
package mockit.asm;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.asm.AttributeWriter;
import mockit.asm.ByteVector;
import mockit.asm.ConstantPoolGeneration;
import mockit.asm.Label;

final class LineNumberWriter
extends AttributeWriter {
    @Nonnegative
    private int lineNumberCount;
    @Nullable
    private ByteVector lineNumbers;

    LineNumberWriter(@Nonnull ConstantPoolGeneration cp) {
        super(cp);
    }

    void addLineNumber(@Nonnegative int line, @Nonnull Label start) {
        if (this.lineNumbers == null) {
            this.setAttribute("LineNumberTable");
            this.lineNumbers = new ByteVector();
        }
        ++this.lineNumberCount;
        this.lineNumbers.putShort(start.position);
        this.lineNumbers.putShort(line);
    }

    boolean hasLineNumbers() {
        return this.lineNumbers != null;
    }

    @Override
    @Nonnegative
    int getSize() {
        return this.lineNumbers == null ? 0 : 8 + this.lineNumbers.length;
    }

    @Override
    void put(@Nonnull ByteVector out) {
        if (this.lineNumbers != null) {
            this.put(out, this.lineNumbers.length + 2);
            out.putShort(this.lineNumberCount);
            out.putByteVector(this.lineNumbers);
        }
    }
}

