/*
 * Decompiled with CFR 0.152.
 */
package mockit.asm;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.asm.ByteVector;
import mockit.asm.Edge;
import mockit.asm.Frame;

public final class Label {
    @Nullable
    public Object info;
    private int status;
    @Nonnegative
    public int line;
    @Nonnegative
    public int position;
    @Nonnegative
    private int referenceCount;
    private int[] srcAndRefPositions;
    @Nonnegative
    int inputStackTop;
    @Nonnegative
    int outputStackMax;
    Frame frame;
    @Nullable
    Label successor;
    Edge successors;
    @Nullable
    Label next;

    public boolean isDebug() {
        return (this.status & 1) != 0;
    }

    boolean isResolved() {
        return (this.status & 2) != 0;
    }

    boolean isPushed() {
        return (this.status & 8) != 0;
    }

    boolean isTarget() {
        return (this.status & 0x10) != 0;
    }

    boolean isStoringFrame() {
        return (this.status & 0x20) != 0;
    }

    boolean isReachable() {
        return (this.status & 0x40) != 0;
    }

    void markAsDebug() {
        this.status |= 1;
    }

    private void markAsResolved() {
        this.status |= 2;
    }

    void markAsPushed() {
        this.status |= 8;
    }

    void markAsTarget() {
        this.status |= 0x10;
    }

    void markAsStoringFrame() {
        this.status |= 0x20;
    }

    void markAsReachable() {
        this.status |= 0x40;
    }

    void markAsTarget(@Nonnull Label target) {
        this.status |= target.status & 0x10;
    }

    void put(@Nonnull ByteVector out, @Nonnegative int source, boolean wideOffset) {
        if (this.isResolved()) {
            int reference = this.position - source;
            if (wideOffset) {
                out.putInt(reference);
            } else {
                out.putShort(reference);
            }
        } else if (wideOffset) {
            this.addReference(-1 - source, out.length);
            out.putInt(-1);
        } else {
            this.addReference(source, out.length);
            out.putShort(-1);
        }
    }

    private void addReference(@Nonnegative int sourcePosition, @Nonnegative int referencePosition) {
        if (this.srcAndRefPositions == null) {
            this.srcAndRefPositions = new int[6];
        }
        if (this.referenceCount >= this.srcAndRefPositions.length) {
            int[] a = new int[this.srcAndRefPositions.length + 6];
            System.arraycopy(this.srcAndRefPositions, 0, a, 0, this.srcAndRefPositions.length);
            this.srcAndRefPositions = a;
        }
        this.srcAndRefPositions[this.referenceCount++] = sourcePosition;
        this.srcAndRefPositions[this.referenceCount++] = referencePosition;
    }

    void resolve(@Nonnull ByteVector methodBytecode) {
        int position;
        this.markAsResolved();
        byte[] data = methodBytecode.data;
        this.position = position = methodBytecode.length;
        int[] srcAndRefPos = this.srcAndRefPositions;
        int i = 0;
        int refCount = this.referenceCount;
        while (i < refCount) {
            int offset;
            int source = srcAndRefPos[i++];
            int reference = srcAndRefPos[i++];
            if (source >= 0) {
                offset = position - source;
            } else {
                offset = position + source + 1;
                data[reference++] = (byte)(offset >>> 24);
                data[reference++] = (byte)(offset >>> 16);
            }
            data[reference++] = (byte)(offset >>> 8);
            data[reference] = (byte)offset;
        }
    }

    @Nonnull
    Label getFirst() {
        return this.frame == null ? this : this.frame.owner;
    }

    public String toString() {
        return "L" + System.identityHashCode(this);
    }

    static interface Status {
        public static final int DEBUG = 1;
        public static final int RESOLVED = 2;
        public static final int PUSHED = 8;
        public static final int TARGET = 16;
        public static final int STORE = 32;
        public static final int REACHABLE = 64;
    }
}

