/*
 * Decompiled with CFR 0.152.
 */
package mockit.asm;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

abstract class Item {
    @Nonnegative
    final int index;
    int type;
    int hashCode;
    @Nullable
    Item next;

    Item(@Nonnegative int index) {
        this.index = index;
    }

    Item(@Nonnegative int index, @Nonnull Item item) {
        this.index = index;
        this.type = item.type;
        this.hashCode = item.hashCode;
    }

    final void setHashCode(int valuesHashCode) {
        this.hashCode = Integer.MAX_VALUE & this.type + valuesHashCode;
    }

    final void setNext(@Nonnull Item[] items) {
        int index = this.hashCode % items.length;
        this.next = items[index];
        items[index] = this;
    }

    abstract boolean isEqualTo(@Nonnull Item var1);

    static interface Type {
        public static final int CLASS = 7;
        public static final int FIELD = 9;
        public static final int METH = 10;
        public static final int IMETH = 11;
        public static final int STR = 8;
        public static final int INT = 3;
        public static final int FLOAT = 4;
        public static final int LONG = 5;
        public static final int DOUBLE = 6;
        public static final int NAME_TYPE = 12;
        public static final int UTF8 = 1;
        public static final int MTYPE = 16;
        public static final int HANDLE = 15;
        public static final int INDY = 18;
        public static final int HANDLE_BASE = 20;
        public static final int BSM = 33;
    }
}

