/*
 * Decompiled with CFR 0.152.
 */
package mockit.asm;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import mockit.asm.ByteVector;
import mockit.asm.ConstantPoolGeneration;

final class Interfaces {
    @Nonnegative
    private final int interfaceCount;
    private final int[] interfaces;

    Interfaces(@Nonnull ConstantPoolGeneration cp, @Nonnull String[] interfaces) {
        int n = this.interfaceCount = interfaces.length;
        this.interfaces = new int[n];
        for (int i = 0; i < n; ++i) {
            this.interfaces[i] = cp.newClass(interfaces[i]);
        }
    }

    @Nonnegative
    int getCount() {
        return this.interfaceCount;
    }

    void put(@Nonnull ByteVector out) {
        for (int i = 0; i < this.interfaceCount; ++i) {
            out.putShort(this.interfaces[i]);
        }
    }
}

