/*
 * Decompiled with CFR 0.152.
 */
package mockit.asm;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.asm.AttributeWriter;
import mockit.asm.ByteVector;
import mockit.asm.ConstantPoolGeneration;
import mockit.asm.StringItem;

final class InnerClassesWriter
extends AttributeWriter {
    @Nonnull
    private final ByteVector innerClasses = new ByteVector();
    @Nonnegative
    private int innerClassesCount;

    InnerClassesWriter(@Nonnull ConstantPoolGeneration cp) {
        super(cp, "InnerClasses");
    }

    void add(@Nonnull String name, @Nullable String outerName, @Nullable String innerName, int access) {
        StringItem nameItem = this.cp.newClassItem(name);
        if (nameItem.innerClassIndex == 0) {
            this.add(nameItem, outerName, innerName, access);
            nameItem.innerClassIndex = ++this.innerClassesCount;
        }
    }

    private void add(@Nonnull StringItem nameItem, @Nullable String outerName, @Nullable String innerName, int access) {
        this.innerClasses.putShort(nameItem.index);
        this.innerClasses.putShort(outerName == null ? 0 : this.cp.newClass(outerName));
        this.innerClasses.putShort(innerName == null ? 0 : this.cp.newUTF8(innerName));
        this.innerClasses.putShort(access);
    }

    @Override
    @Nonnegative
    int getSize() {
        return 8 + this.innerClasses.length;
    }

    @Override
    void put(@Nonnull ByteVector out) {
        this.put(out, this.innerClasses.length + 2);
        out.putShort(this.innerClassesCount);
        out.putByteVector(this.innerClasses);
    }
}

