/*
 * Decompiled with CFR 0.152.
 */
package mockit.asm;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import mockit.asm.ByteVector;
import mockit.asm.ClassWriter;
import mockit.asm.ConstantPoolGeneration;
import mockit.asm.Frame;
import mockit.asm.JavaType;
import mockit.asm.MethodWriter;
import mockit.asm.UninitializedTypeTableItem;

final class FrameAndStackComputation {
    @Nonnull
    private final MethodWriter mw;
    @Nonnull
    private final ClassWriter cw;
    @Nonnull
    private final ConstantPoolGeneration cp;
    @Nonnegative
    private int maxStack;
    @Nonnegative
    private int maxLocals;
    @Nonnegative
    private int frameCount;
    private ByteVector stackMap;
    private int[] previousFrame;
    private int[] frameDefinition;
    @Nonnegative
    private int frameIndex;

    FrameAndStackComputation(@Nonnull MethodWriter mw, int methodAccess, @Nonnull String methodDesc) {
        this.mw = mw;
        this.cw = mw.cw;
        this.cp = this.cw.cp;
        int size = JavaType.getArgumentsAndReturnSizes(methodDesc) >> 2;
        if ((methodAccess & 8) != 0) {
            --size;
        }
        this.maxLocals = size;
    }

    void setMaxStack(@Nonnegative int maxStack) {
        this.maxStack = maxStack;
    }

    void updateMaxLocals(@Nonnegative int n) {
        if (n > this.maxLocals) {
            this.maxLocals = n;
        }
    }

    void putMaxStackAndLocals(@Nonnull ByteVector out) {
        out.putShort(this.maxStack).putShort(this.maxLocals);
    }

    private int getInstructionOffset() {
        return this.frameDefinition[0];
    }

    private void setInstructionOffset(@Nonnegative int offset) {
        this.frameDefinition[0] = offset;
    }

    private int getNumLocals() {
        return this.frameDefinition[1];
    }

    private void setNumLocals(@Nonnegative int numLocals) {
        this.frameDefinition[1] = numLocals;
    }

    private int getStackSize() {
        return this.frameDefinition[2];
    }

    private void setStackSize(@Nonnegative int stackSize) {
        this.frameDefinition[2] = stackSize;
    }

    private void writeFrameDefinition(int value) {
        this.frameDefinition[this.frameIndex++] = value;
    }

    boolean hasStackMap() {
        return this.stackMap != null;
    }

    private void startFrame(@Nonnegative int offset, @Nonnegative int nLocals, @Nonnegative int nStack) {
        int n = 3 + nLocals + nStack;
        if (this.frameDefinition == null || this.frameDefinition.length < n) {
            this.frameDefinition = new int[n];
        }
        this.setInstructionOffset(offset);
        this.setNumLocals(nLocals);
        this.setStackSize(nStack);
        this.frameIndex = 3;
    }

    private void endFrame() {
        if (this.previousFrame != null) {
            if (this.stackMap == null) {
                this.stackMap = new ByteVector();
            }
            this.writeFrame();
            ++this.frameCount;
        }
        this.previousFrame = this.frameDefinition;
        this.frameDefinition = null;
    }

    private void writeFrame() {
        int currentFrameLocalsSize = this.getNumLocals();
        int currentFrameStackSize = this.getStackSize();
        if (!this.cw.isJava6OrNewer()) {
            this.writeFrameForOldVersionOfJava(currentFrameLocalsSize, currentFrameStackSize);
            return;
        }
        int type = 255;
        int localsSize = this.previousFrame[1];
        int k = currentFrameStackSize == 0 ? currentFrameLocalsSize - localsSize : 0;
        int delta = this.getDelta();
        if (currentFrameStackSize == 0) {
            switch (k) {
                case -3: 
                case -2: 
                case -1: {
                    type = 248;
                    localsSize = currentFrameLocalsSize;
                    break;
                }
                case 0: {
                    type = delta < 64 ? 0 : 251;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    type = 252;
                }
            }
        } else if (currentFrameLocalsSize == localsSize && currentFrameStackSize == 1) {
            type = delta < 63 ? 64 : 247;
        }
        type = this.chooseTypeAsFullFrameIfApplicable(localsSize, type);
        switch (type) {
            case 0: {
                this.stackMap.putByte(delta);
                break;
            }
            case 64: {
                this.stackMap.putByte(64 + delta);
                this.writeFrameTypes(3 + currentFrameLocalsSize, 4 + currentFrameLocalsSize);
                break;
            }
            case 247: {
                this.stackMap.putByte(247).putShort(delta);
                this.writeFrameTypes(3 + currentFrameLocalsSize, 4 + currentFrameLocalsSize);
                break;
            }
            case 251: {
                this.stackMap.putByte(251).putShort(delta);
                break;
            }
            case 248: {
                this.stackMap.putByte(251 + k).putShort(delta);
                break;
            }
            case 252: {
                this.stackMap.putByte(251 + k).putShort(delta);
                this.writeFrameTypes(3 + localsSize, 3 + currentFrameLocalsSize);
                break;
            }
            default: {
                this.stackMap.putByte(255).putShort(delta).putShort(currentFrameLocalsSize);
                this.writeFrameTypes(3, 3 + currentFrameLocalsSize);
                this.stackMap.putShort(currentFrameStackSize);
                this.writeFrameTypes(3 + currentFrameLocalsSize, 3 + currentFrameLocalsSize + currentFrameStackSize);
            }
        }
    }

    private void writeFrameForOldVersionOfJava(@Nonnegative int currentFrameLocalsSize, @Nonnegative int currentFrameStackSize) {
        this.stackMap.putShort(this.getInstructionOffset()).putShort(currentFrameLocalsSize);
        this.writeFrameTypes(3, 3 + currentFrameLocalsSize);
        this.stackMap.putShort(currentFrameStackSize);
        this.writeFrameTypes(3 + currentFrameLocalsSize, 3 + currentFrameLocalsSize + currentFrameStackSize);
    }

    private int getDelta() {
        int offset = this.getInstructionOffset();
        return this.frameCount == 0 ? offset : offset - this.previousFrame[0] - 1;
    }

    private int chooseTypeAsFullFrameIfApplicable(@Nonnegative int localsSize, int type) {
        if (type != 255) {
            int l = 3;
            for (int j = 0; j < localsSize; ++j) {
                if (this.frameDefinition[l] != this.previousFrame[l]) {
                    return 255;
                }
                ++l;
            }
        }
        return type;
    }

    private void writeFrameTypes(@Nonnegative int start, @Nonnegative int end) {
        for (int i = start; i < end; ++i) {
            int type = this.frameDefinition[i];
            int dimensions = type & 0xF0000000;
            if (dimensions == 0) {
                this.writeFrameOfRegularType(type);
                continue;
            }
            this.writeFrameOfArrayType(dimensions, type);
        }
    }

    private void writeFrameOfRegularType(int type) {
        int typeTableIndex = type & 0xFFFFF;
        switch (type & 0xFF00000) {
            case 0x1700000: {
                String classDesc = this.cp.getInternalName(typeTableIndex);
                int classDescIndex = this.cp.newClass(classDesc);
                this.stackMap.putByte(7).putShort(classDescIndex);
                break;
            }
            case 0x1800000: {
                UninitializedTypeTableItem uninitializedItemValue = this.cp.getUninitializedItemValue(typeTableIndex);
                int typeDesc = uninitializedItemValue.offset;
                this.stackMap.putByte(8).putShort(typeDesc);
                break;
            }
            default: {
                this.stackMap.putByte(typeTableIndex);
            }
        }
    }

    private void writeFrameOfArrayType(@Nonnegative int arrayDimensions, int arrayElementType) {
        String arrayElementTypeDesc;
        StringBuilder sb = new StringBuilder();
        FrameAndStackComputation.writeDimensionsIntoArrayDescriptor(sb, arrayDimensions);
        if ((arrayElementType & 0xFF00000) == 0x1700000) {
            arrayElementTypeDesc = this.cp.getInternalName(arrayElementType & 0xFFFFF);
            sb.append('L').append(arrayElementTypeDesc).append(';');
        } else {
            char typeCode = FrameAndStackComputation.getTypeCodeForArrayElements(arrayElementType);
            sb.append(typeCode);
        }
        arrayElementTypeDesc = sb.toString();
        int typeDescIndex = this.cp.newClass(arrayElementTypeDesc);
        this.stackMap.putByte(7).putShort(typeDescIndex);
    }

    private static void writeDimensionsIntoArrayDescriptor(@Nonnull StringBuilder sb, @Nonnegative int arrayDimensions) {
        arrayDimensions >>= 28;
        while (arrayDimensions-- > 0) {
            sb.append('[');
        }
    }

    private static char getTypeCodeForArrayElements(int arrayElementType) {
        switch (arrayElementType & 0xF) {
            case 1: {
                return 'I';
            }
            case 2: {
                return 'F';
            }
            case 3: {
                return 'D';
            }
            case 9: {
                return 'Z';
            }
            case 10: {
                return 'B';
            }
            case 11: {
                return 'C';
            }
            case 12: {
                return 'S';
            }
        }
        return 'J';
    }

    void createAndVisitFirstFrame(@Nonnull Frame frame) {
        JavaType[] args = JavaType.getArgumentTypes(this.mw.descriptor);
        frame.initInputFrame(this.cw.thisName, this.mw.access, args, this.maxLocals);
        this.visitFrame(frame);
    }

    void visitFrame(@Nonnull Frame frame) {
        int[] locals = frame.inputLocals;
        int nLocal = FrameAndStackComputation.computeNumberOfLocals(locals);
        int[] stacks = frame.inputStack;
        int nStack = FrameAndStackComputation.computeStackSize(stacks);
        this.startFrame(frame.owner.position, nLocal, nStack);
        this.putLocalsOrStackElements(locals, nLocal);
        this.putLocalsOrStackElements(stacks, nStack);
        this.endFrame();
    }

    @Nonnegative
    private static int computeNumberOfLocals(@Nonnull int[] locals) {
        int nLocal = 0;
        int nTop = 0;
        for (int i = 0; i < locals.length; ++i) {
            int t = locals[i];
            if (t == 0x1000000) {
                ++nTop;
            } else {
                nLocal += nTop + 1;
                nTop = 0;
            }
            if (t != 0x1000004 && t != 0x1000003) continue;
            ++i;
        }
        return nLocal;
    }

    private static int computeStackSize(@Nonnull int[] stacks) {
        int nStack = 0;
        for (int i = 0; i < stacks.length; ++i) {
            int t = stacks[i];
            ++nStack;
            if (t != 0x1000004 && t != 0x1000003) continue;
            ++i;
        }
        return nStack;
    }

    private void putLocalsOrStackElements(@Nonnull int[] itemIndices, @Nonnegative int nItems) {
        int i = 0;
        while (nItems > 0) {
            int itemType = itemIndices[i];
            this.writeFrameDefinition(itemType);
            if (itemType == 0x1000004 || itemType == 0x1000003) {
                ++i;
            }
            ++i;
            --nItems;
        }
    }

    void emitFrameForUnreachableBlock(@Nonnegative int startOffset) {
        this.startFrame(startOffset, 0, 1);
        int frameValue = 0x1700000 | this.cp.addNormalType("java/lang/Throwable");
        this.writeFrameDefinition(frameValue);
        this.endFrame();
    }

    @Nonnegative
    int getSize() {
        return this.stackMap == null ? 0 : 8 + this.stackMap.length;
    }

    @Nonnegative
    int getSizeWhileAddingConstantPoolItem() {
        int size = this.getSize();
        if (size > 0) {
            boolean zip = this.cw.isJava6OrNewer();
            this.cp.newUTF8(zip ? "StackMapTable" : "StackMap");
        }
        return size;
    }

    void put(@Nonnull ByteVector out) {
        if (this.stackMap != null) {
            boolean zip = this.cw.isJava6OrNewer();
            out.putShort(this.cp.newUTF8(zip ? "StackMapTable" : "StackMap"));
            out.putInt(this.stackMap.length + 2).putShort(this.frameCount);
            out.putByteVector(this.stackMap);
        }
    }

    static interface LocalsAndStackItemsDiff {
        public static final int SAME_FRAME = 0;
        public static final int SAME_LOCALS_1_STACK_ITEM_FRAME = 64;
        public static final int SAME_LOCALS_1_STACK_ITEM_FRAME_EXTENDED = 247;
        public static final int CHOP_FRAME = 248;
        public static final int SAME_FRAME_EXTENDED = 251;
        public static final int APPEND_FRAME = 252;
        public static final int FULL_FRAME = 255;
    }
}

