/*
 * Decompiled with CFR 0.152.
 */
package mockit.asm;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.asm.Access;
import mockit.asm.ConstantPoolGeneration;
import mockit.asm.Item;
import mockit.asm.JavaType;
import mockit.asm.Label;
import mockit.asm.StringItem;
import mockit.asm.TypeOrMemberItem;

public final class Frame {
    public static final int[] SIZE;
    @Nonnull
    private final ConstantPoolGeneration cp;
    @Nonnull
    final Label owner;
    int[] inputLocals;
    int[] inputStack;
    @Nullable
    private int[] outputLocals;
    private int[] outputStack;
    private int outputStackTop;
    private int initializationCount;
    private int[] initializations;

    Frame(@Nonnull ConstantPoolGeneration cp, @Nonnull Label owner) {
        this.cp = cp;
        this.owner = owner;
    }

    void initInputFrame(@Nonnull String classDesc, int access, @Nonnull JavaType[] args, @Nonnegative int maxLocals) {
        this.inputLocals = new int[maxLocals];
        this.inputStack = new int[0];
        int localIndex = this.initializeThisParameterIfApplicable(classDesc, access);
        localIndex = this.initializeFormalParameterTypes(localIndex, args);
        while (localIndex < maxLocals) {
            this.inputLocals[localIndex++] = 0x1000000;
        }
    }

    @Nonnegative
    private int initializeThisParameterIfApplicable(@Nonnull String classDesc, int access) {
        if ((access & 8) == 0) {
            this.inputLocals[0] = Access.isConstructor(access) ? 0x1000006 : 0x1700000 | this.cp.addNormalType(classDesc);
            return 1;
        }
        return 0;
    }

    @Nonnegative
    private int initializeFormalParameterTypes(@Nonnegative int localIndex, @Nonnull JavaType[] args) {
        for (JavaType arg : args) {
            int typeEncoding = this.getTypeEncoding(arg.getDescriptor());
            this.inputLocals[localIndex++] = typeEncoding;
            if (typeEncoding != 0x1000004 && typeEncoding != 0x1000003) continue;
            this.inputLocals[localIndex++] = 0x1000000;
        }
        return localIndex;
    }

    private int getTypeEncoding(@Nonnull String typeDesc) {
        int index = typeDesc.charAt(0) == '(' ? typeDesc.indexOf(41) + 1 : 0;
        switch (typeDesc.charAt(index)) {
            case 'V': {
                return 0;
            }
            case 'B': 
            case 'C': 
            case 'I': 
            case 'S': 
            case 'Z': {
                return 0x1000001;
            }
            case 'F': {
                return 0x1000002;
            }
            case 'J': {
                return 0x1000004;
            }
            case 'D': {
                return 0x1000003;
            }
            case 'L': {
                return this.getObjectTypeEncoding(typeDesc, index);
            }
            case '[': {
                return this.getArrayTypeEncoding(typeDesc, index);
            }
        }
        throw new IllegalArgumentException("Invalid type descriptor: " + typeDesc);
    }

    private int getObjectTypeEncoding(@Nonnull String typeDesc, @Nonnegative int index) {
        String t = typeDesc.substring(index + 1, typeDesc.length() - 1);
        return 0x1700000 | this.cp.addNormalType(t);
    }

    private int getArrayTypeEncoding(@Nonnull String typeDesc, @Nonnegative int index) {
        int dims = Frame.getNumberOfDimensions(typeDesc, index);
        int data = this.getArrayElementTypeEncoding(typeDesc, index + dims);
        return dims << 28 | data;
    }

    @Nonnegative
    private static int getNumberOfDimensions(@Nonnull String typeDesc, @Nonnegative int index) {
        int dims = 1;
        while (typeDesc.charAt(index + dims) == '[') {
            ++dims;
        }
        return dims;
    }

    private int getArrayElementTypeEncoding(@Nonnull String typeDesc, @Nonnegative int index) {
        switch (typeDesc.charAt(index)) {
            case 'Z': {
                return 0x1000009;
            }
            case 'C': {
                return 0x100000B;
            }
            case 'B': {
                return 0x100000A;
            }
            case 'S': {
                return 0x100000C;
            }
            case 'I': {
                return 0x1000001;
            }
            case 'F': {
                return 0x1000002;
            }
            case 'J': {
                return 0x1000004;
            }
            case 'D': {
                return 0x1000003;
            }
            case 'L': {
                return this.getObjectTypeEncoding(typeDesc, index);
            }
        }
        throw new IllegalArgumentException("Invalid type descriptor: " + typeDesc);
    }

    void executeIINC(@Nonnegative int varIndex) {
        this.set(varIndex, 0x1000001);
    }

    private void set(@Nonnegative int local, int type) {
        int n;
        if (this.outputLocals == null) {
            this.outputLocals = new int[10];
        }
        if (local >= (n = this.outputLocals.length)) {
            int[] t = new int[Math.max(local + 1, 2 * n)];
            System.arraycopy(this.outputLocals, 0, t, 0, n);
            this.outputLocals = t;
        }
        this.outputLocals[local] = type;
    }

    void executeINT(int opcode, int operand) {
        if (opcode == 188) {
            this.executeNewArray(operand);
        } else {
            this.push(0x1000001);
        }
    }

    private void executeNewArray(int arg) {
        this.pop();
        switch (arg) {
            case 4: {
                this.push(0x11000009);
                break;
            }
            case 5: {
                this.push(0x1100000B);
                break;
            }
            case 8: {
                this.push(0x1100000A);
                break;
            }
            case 9: {
                this.push(0x1100000C);
                break;
            }
            case 10: {
                this.push(0x11000001);
                break;
            }
            case 6: {
                this.push(0x11000002);
                break;
            }
            case 7: {
                this.push(0x11000003);
                break;
            }
            case 11: {
                this.push(0x11000004);
            }
        }
    }

    private void push(int type) {
        int n;
        if (this.outputStack == null) {
            this.outputStack = new int[10];
        }
        if (this.outputStackTop >= (n = this.outputStack.length)) {
            int[] t = new int[Math.max(this.outputStackTop + 1, 2 * n)];
            System.arraycopy(this.outputStack, 0, t, 0, n);
            this.outputStack = t;
        }
        this.outputStack[this.outputStackTop++] = type;
        int top = this.owner.inputStackTop + this.outputStackTop;
        if (top > this.owner.outputStackMax) {
            this.owner.outputStackMax = top;
        }
    }

    private int pop() {
        if (this.outputStackTop > 0) {
            return this.outputStack[--this.outputStackTop];
        }
        return 0x3000000 | -(--this.owner.inputStackTop);
    }

    void executeSWITCH() {
        this.pop(1);
    }

    private void pop(@Nonnegative int elements) {
        if (this.outputStackTop >= elements) {
            this.outputStackTop -= elements;
        } else {
            this.owner.inputStackTop -= elements - this.outputStackTop;
            this.outputStackTop = 0;
        }
    }

    private void pop(@Nonnull String desc) {
        char c = desc.charAt(0);
        if (c == '(') {
            int elements = (JavaType.getArgumentsAndReturnSizes(desc) >> 2) - 1;
            this.pop(elements);
        } else if (c == 'J' || c == 'D') {
            this.pop(2);
        } else {
            this.pop(1);
        }
    }

    private void init(int var) {
        int n;
        if (this.initializations == null) {
            this.initializations = new int[2];
        }
        if (this.initializationCount >= (n = this.initializations.length)) {
            int[] t = new int[Math.max(this.initializationCount + 1, 2 * n)];
            System.arraycopy(this.initializations, 0, t, 0, n);
            this.initializations = t;
        }
        this.initializations[this.initializationCount++] = var;
    }

    private int init(@Nonnull String classDesc, int t) {
        int s;
        if (t == 0x1000006) {
            s = 0x1700000 | this.cp.addNormalType(classDesc);
        } else if ((t & 0xFFF00000) == 0x1800000) {
            String type = this.cp.getInternalName(t & 0xFFFFF);
            s = 0x1700000 | this.cp.addNormalType(type);
        } else {
            return t;
        }
        for (int j = 0; j < this.initializationCount; ++j) {
            int u = this.initializations[j];
            int dim = u & 0xF0000000;
            int kind = u & 0xF000000;
            if (kind == 0x2000000) {
                u = dim + this.inputLocals[u & 0x7FFFFF];
            } else if (kind == 0x3000000) {
                u = dim + this.inputStack[this.inputStack.length - (u & 0x7FFFFF)];
            }
            if (t != u) continue;
            return s;
        }
        return t;
    }

    void executeVAR(int opcode, @Nonnegative int var) {
        switch (opcode) {
            case 21: {
                this.push(0x1000001);
                break;
            }
            case 22: {
                this.push(0x1000004);
                this.push(0x1000000);
                break;
            }
            case 23: {
                this.push(0x1000002);
                break;
            }
            case 24: {
                this.push(0x1000003);
                this.push(0x1000000);
                break;
            }
            case 25: {
                this.push(this.get(var));
                break;
            }
            case 54: 
            case 56: 
            case 58: {
                this.executeSingleWordStore(var);
                break;
            }
            case 55: 
            case 57: {
                this.executeDoubleWordStore(var);
            }
        }
    }

    @Nonnegative
    private int get(@Nonnegative int local) {
        if (this.outputLocals == null || local >= this.outputLocals.length) {
            return 0x2000000 | local;
        }
        int type = this.outputLocals[local];
        if (type == 0) {
            type = this.outputLocals[local] = 0x2000000 | local;
        }
        return type;
    }

    private void executeSingleWordStore(@Nonnegative int arg) {
        int type1 = this.pop();
        this.set(arg, type1);
        this.executeStore(arg);
    }

    private void executeDoubleWordStore(@Nonnegative int arg) {
        this.pop(1);
        int type1 = this.pop();
        this.set(arg, type1);
        this.set(arg + 1, 0x1000000);
        this.executeStore(arg);
    }

    private void executeStore(@Nonnegative int arg) {
        if (arg > 0) {
            int type2 = this.get(arg - 1);
            if (type2 == 0x1000004 || type2 == 0x1000003) {
                this.set(arg - 1, 0x1000000);
            } else if ((type2 & 0xF000000) != 0x1000000) {
                this.set(arg - 1, type2 | 0x800000);
            }
        }
    }

    void executeJUMP(int opcode) {
        switch (opcode) {
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 198: 
            case 199: {
                this.pop(1);
                break;
            }
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: {
                this.pop(2);
            }
        }
    }

    void execute(int opcode) {
        switch (opcode) {
            case 0: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 145: 
            case 146: 
            case 147: 
            case 167: 
            case 177: {
                break;
            }
            case 1: {
                this.push(0x1000005);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                this.push(0x1000001);
                break;
            }
            case 9: 
            case 10: {
                this.push(0x1000004);
                this.push(0x1000000);
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                this.push(0x1000002);
                break;
            }
            case 14: 
            case 15: {
                this.push(0x1000003);
                this.push(0x1000000);
                break;
            }
            case 46: 
            case 51: 
            case 52: 
            case 53: {
                this.pop(2);
                this.push(0x1000001);
                break;
            }
            case 47: 
            case 143: {
                this.pop(2);
                this.push(0x1000004);
                this.push(0x1000000);
                break;
            }
            case 48: {
                this.pop(2);
                this.push(0x1000002);
                break;
            }
            case 49: 
            case 138: {
                this.pop(2);
                this.push(0x1000003);
                this.push(0x1000000);
                break;
            }
            case 50: {
                this.executeAALOAD();
                break;
            }
            case 79: 
            case 81: 
            case 83: 
            case 84: 
            case 85: 
            case 86: {
                this.pop(3);
                break;
            }
            case 80: 
            case 82: {
                this.pop(4);
                break;
            }
            case 87: 
            case 172: 
            case 174: 
            case 176: 
            case 191: 
            case 194: 
            case 195: {
                this.pop(1);
                break;
            }
            case 88: 
            case 173: 
            case 175: {
                this.pop(2);
                break;
            }
            case 89: {
                this.executeDUP();
                break;
            }
            case 90: {
                this.executeDUP_X1();
                break;
            }
            case 91: {
                this.executeDUP_X2();
                break;
            }
            case 92: {
                this.executeDUP2();
                break;
            }
            case 93: {
                this.executeDUP2_X1();
                break;
            }
            case 94: {
                this.executeDUP2_X2();
                break;
            }
            case 95: {
                this.executeSWAP();
                break;
            }
            case 96: 
            case 100: 
            case 104: 
            case 108: 
            case 112: 
            case 120: 
            case 122: 
            case 124: 
            case 126: 
            case 128: 
            case 130: 
            case 136: 
            case 142: 
            case 149: 
            case 150: {
                this.pop(2);
                this.push(0x1000001);
                break;
            }
            case 97: 
            case 101: 
            case 105: 
            case 109: 
            case 113: 
            case 127: 
            case 129: 
            case 131: {
                this.pop(4);
                this.push(0x1000004);
                this.push(0x1000000);
                break;
            }
            case 98: 
            case 102: 
            case 106: 
            case 110: 
            case 114: 
            case 137: 
            case 144: {
                this.pop(2);
                this.push(0x1000002);
                break;
            }
            case 99: 
            case 103: 
            case 107: 
            case 111: 
            case 115: {
                this.pop(4);
                this.push(0x1000003);
                this.push(0x1000000);
                break;
            }
            case 121: 
            case 123: 
            case 125: {
                this.pop(3);
                this.push(0x1000004);
                this.push(0x1000000);
                break;
            }
            case 133: 
            case 140: {
                this.pop(1);
                this.push(0x1000004);
                this.push(0x1000000);
                break;
            }
            case 134: {
                this.pop(1);
                this.push(0x1000002);
                break;
            }
            case 135: 
            case 141: {
                this.pop(1);
                this.push(0x1000003);
                this.push(0x1000000);
                break;
            }
            case 139: 
            case 190: {
                this.pop(1);
                this.push(0x1000001);
                break;
            }
            case 148: 
            case 151: 
            case 152: {
                this.pop(4);
                this.push(0x1000001);
            }
        }
    }

    private void executeAALOAD() {
        this.pop(1);
        int type = this.pop();
        this.push(-268435456 + type);
    }

    private void executeDUP() {
        int type = this.pop();
        this.push(type);
        this.push(type);
    }

    private void executeDUP_X1() {
        int type1 = this.pop();
        int type2 = this.pop();
        this.push(type1);
        this.push(type2);
        this.push(type1);
    }

    private void executeDUP_X2() {
        int t1 = this.pop();
        int t2 = this.pop();
        int t3 = this.pop();
        this.push(t1);
        this.push(t3);
        this.push(t2);
        this.push(t1);
    }

    private void executeDUP2() {
        int t1 = this.pop();
        int t2 = this.pop();
        this.push(t2);
        this.push(t1);
        this.push(t2);
        this.push(t1);
    }

    private void executeDUP2_X1() {
        int t1 = this.pop();
        int t2 = this.pop();
        int t3 = this.pop();
        this.push(t2);
        this.push(t1);
        this.push(t3);
        this.push(t2);
        this.push(t1);
    }

    private void executeDUP2_X2() {
        int t1 = this.pop();
        int t2 = this.pop();
        int t3 = this.pop();
        int t4 = this.pop();
        this.push(t2);
        this.push(t1);
        this.push(t4);
        this.push(t3);
        this.push(t2);
        this.push(t1);
    }

    private void executeSWAP() {
        int t1 = this.pop();
        int t2 = this.pop();
        this.push(t1);
        this.push(t2);
    }

    void executeLDC(@Nonnull Item item) {
        switch (item.type) {
            case 3: {
                this.push(0x1000001);
                break;
            }
            case 5: {
                this.push(0x1000004);
                this.push(0x1000000);
                break;
            }
            case 4: {
                this.push(0x1000002);
                break;
            }
            case 6: {
                this.push(0x1000003);
                this.push(0x1000000);
                break;
            }
            case 7: {
                this.push(0x1700000 | this.cp.addNormalType("java/lang/Class"));
                break;
            }
            case 8: {
                this.push(0x1700000 | this.cp.addNormalType("java/lang/String"));
                break;
            }
            case 16: {
                this.push(0x1700000 | this.cp.addNormalType("java/lang/invoke/MethodType"));
                break;
            }
            default: {
                this.push(0x1700000 | this.cp.addNormalType("java/lang/invoke/MethodHandle"));
            }
        }
    }

    void executeTYPE(int opcode, @Nonnegative int codeLength, @Nonnull StringItem item) {
        switch (opcode) {
            case 187: {
                this.push(0x1800000 | this.cp.addUninitializedType(item.strVal, codeLength));
                break;
            }
            case 189: {
                this.executeANewArray(item);
                break;
            }
            case 192: {
                this.executeCheckCast(item);
                break;
            }
            case 193: {
                this.pop(1);
                this.push(0x1000001);
            }
        }
    }

    private void executeANewArray(@Nonnull StringItem item) {
        String s = item.strVal;
        this.pop();
        if (s.charAt(0) == '[') {
            this.push('[' + s);
        } else {
            this.push(0x11700000 | this.cp.addNormalType(s));
        }
    }

    private void push(@Nonnull String desc) {
        int type = this.getTypeEncoding(desc);
        if (type != 0) {
            this.push(type);
            if (type == 0x1000004 || type == 0x1000003) {
                this.push(0x1000000);
            }
        }
    }

    private void executeCheckCast(@Nonnull StringItem item) {
        String s = item.strVal;
        this.pop();
        if (s.charAt(0) == '[') {
            this.push(s);
        } else {
            this.push(0x1700000 | this.cp.addNormalType(s));
        }
    }

    void executeMULTIANEWARRAY(int dims, @Nonnull StringItem arrayType) {
        this.pop(dims);
        this.push(arrayType.strVal);
    }

    void execute(int opcode, @Nonnull TypeOrMemberItem item) {
        if (opcode == 186) {
            this.executeInvokeDynamic(item);
        } else {
            switch (opcode) {
                case 178: {
                    this.push(item.desc);
                    break;
                }
                case 179: {
                    this.pop(item.desc);
                    break;
                }
                case 180: {
                    this.pop(1);
                    this.push(item.desc);
                    break;
                }
                case 181: {
                    this.pop(item.desc);
                    this.pop();
                    break;
                }
                case 182: 
                case 183: 
                case 184: 
                case 185: {
                    this.executeInvoke(opcode, item);
                }
            }
        }
    }

    private void executeInvoke(int opcode, @Nonnull TypeOrMemberItem item) {
        String methodDesc = item.desc;
        this.pop(methodDesc);
        if (opcode != 184) {
            int var = this.pop();
            if (opcode == 183 && item.name.charAt(0) == '<') {
                this.init(var);
            }
        }
        this.push(methodDesc);
    }

    private void executeInvokeDynamic(@Nonnull TypeOrMemberItem item) {
        String desc = item.desc;
        this.pop(desc);
        this.push(desc);
    }

    boolean merge(@Nonnull String classDesc, @Nonnull Frame frame, int edge) {
        int kind;
        int dim;
        int t;
        int s;
        int i;
        boolean changed = false;
        int nLocal = this.inputLocals.length;
        int nStack = this.inputStack.length;
        if (frame.inputLocals == null) {
            frame.inputLocals = new int[nLocal];
            changed = true;
        }
        for (i = 0; i < nLocal; ++i) {
            if (this.outputLocals != null && i < this.outputLocals.length) {
                s = this.outputLocals[i];
                if (s == 0) {
                    t = this.inputLocals[i];
                } else {
                    dim = s & 0xF0000000;
                    kind = s & 0xF000000;
                    if (kind == 0x1000000) {
                        t = s;
                    } else {
                        t = kind == 0x2000000 ? dim + this.inputLocals[s & 0x7FFFFF] : dim + this.inputStack[nStack - (s & 0x7FFFFF)];
                        if ((s & 0x800000) != 0 && (t == 0x1000004 || t == 0x1000003)) {
                            t = 0x1000000;
                        }
                    }
                }
            } else {
                t = this.inputLocals[i];
            }
            if (this.initializations != null) {
                t = this.init(classDesc, t);
            }
            changed |= this.merge(t, frame.inputLocals, i);
        }
        if (edge > 0) {
            for (i = 0; i < nLocal; ++i) {
                t = this.inputLocals[i];
                changed |= this.merge(t, frame.inputLocals, i);
            }
            if (frame.inputStack == null) {
                frame.inputStack = new int[1];
                changed = true;
            }
            return changed |= this.merge(edge, frame.inputStack, 0);
        }
        int nInputStack = this.inputStack.length + this.owner.inputStackTop;
        if (frame.inputStack == null) {
            frame.inputStack = new int[nInputStack + this.outputStackTop];
            changed = true;
        }
        for (i = 0; i < nInputStack; ++i) {
            t = this.inputStack[i];
            if (this.initializations != null) {
                t = this.init(classDesc, t);
            }
            changed |= this.merge(t, frame.inputStack, i);
        }
        for (i = 0; i < this.outputStackTop; ++i) {
            s = this.outputStack[i];
            dim = s & 0xF0000000;
            kind = s & 0xF000000;
            if (kind == 0x1000000) {
                t = s;
            } else {
                t = kind == 0x2000000 ? dim + this.inputLocals[s & 0x7FFFFF] : dim + this.inputStack[nStack - (s & 0x7FFFFF)];
                if ((s & 0x800000) != 0 && (t == 0x1000004 || t == 0x1000003)) {
                    t = 0x1000000;
                }
            }
            if (this.initializations != null) {
                t = this.init(classDesc, t);
            }
            changed |= this.merge(t, frame.inputStack, nInputStack + i);
        }
        return changed;
    }

    private boolean merge(int type1, @Nonnull int[] types, @Nonnegative int index) {
        int v;
        int type2 = types[index];
        if (type2 == type1) {
            return false;
        }
        if ((type1 & 0xFFFFFFF) == 0x1000005) {
            if (type2 == 0x1000005) {
                return false;
            }
            type1 = 0x1000005;
        }
        if (type2 == 0) {
            types[index] = type1;
            return true;
        }
        if ((type2 & 0xFF00000) == 0x1700000 || (type2 & 0xF0000000) != 0) {
            if (type1 == 0x1000005) {
                return false;
            }
            if ((type1 & 0xFFF00000) == (type2 & 0xFFF00000)) {
                if ((type2 & 0xFF00000) == 0x1700000) {
                    v = type1 & 0xF0000000 | 0x1700000 | this.cp.getMergedType(type1 & 0xFFFFF, type2 & 0xFFFFF);
                } else {
                    int dim = -268435456 + (type2 & 0xF0000000);
                    v = dim | 0x1700000 | this.cp.addNormalType("java/lang/Object");
                }
            } else if ((type1 & 0xFF00000) == 0x1700000 || (type1 & 0xF0000000) != 0) {
                int tDim = ((type1 & 0xF0000000) == 0 || (type1 & 0xFF00000) == 0x1700000 ? 0 : -268435456) + (type1 & 0xF0000000);
                int uDim = ((type2 & 0xF0000000) == 0 || (type2 & 0xFF00000) == 0x1700000 ? 0 : -268435456) + (type2 & 0xF0000000);
                v = Math.min(tDim, uDim) | 0x1700000 | this.cp.addNormalType("java/lang/Object");
            } else {
                v = 0x1000000;
            }
        } else {
            v = type2 == 0x1000005 ? ((type1 & 0xFF00000) == 0x1700000 || (type1 & 0xF0000000) != 0 ? type1 : 0x1000000) : 0x1000000;
        }
        if (type2 != v) {
            types[index] = v;
            return true;
        }
        return false;
    }

    static {
        String s = "EFFFFFFFFGGFFFGGFFFEEFGFGFEEEEEEEEEEEEEEEEEEEEDEDEDDDDDCDCDEEEEEEEEEEEEEEEEEEEEBABABBBBDCFFFGGGEDCDCDCDCDCDCDCDCDCDCEEEEDDDDDDDCDCDCEFEFDDEEFFDEDEEEBDDBBDDDDDDCCCCCCCCEFEDDDCDCDEEEEEEEEEEFEEEEEEDDEEDDEE";
        int n = s.length();
        int[] b = new int[n];
        for (int i = 0; i < n; ++i) {
            b[i] = s.charAt(i) - 69;
        }
        SIZE = b;
    }

    static interface TypeMask {
        public static final int DIM = -268435456;
        public static final int ARRAY_OF = 0x10000000;
        public static final int ELEMENT_OF = -268435456;
        public static final int KIND = 0xF000000;
        public static final int TOP_IF_LONG_OR_DOUBLE = 0x800000;
        public static final int VALUE = 0x7FFFFF;
        public static final int BASE_KIND = 0xFF00000;
        public static final int BASE_VALUE = 1048575;
        public static final int BASE = 0x1000000;
        public static final int OBJECT = 0x1700000;
        public static final int UNINITIALIZED = 0x1800000;
        public static final int LOCAL = 0x2000000;
        public static final int STACK = 0x3000000;
        public static final int TOP = 0x1000000;
        public static final int BOOLEAN = 0x1000009;
        public static final int BYTE = 0x100000A;
        public static final int CHAR = 0x100000B;
        public static final int SHORT = 0x100000C;
        public static final int INTEGER = 0x1000001;
        public static final int FLOAT = 0x1000002;
        public static final int DOUBLE = 0x1000003;
        public static final int LONG = 0x1000004;
        public static final int NULL = 0x1000005;
        public static final int UNINITIALIZED_THIS = 0x1000006;
    }
}

