/*
 * Decompiled with CFR 0.152.
 */
package mockit.asm;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.asm.AnnotationVisitor;
import mockit.asm.ByteVector;
import mockit.asm.ClassWriter;
import mockit.asm.FieldVisitor;
import mockit.asm.SignatureWriter;

final class FieldWriter
extends FieldVisitor {
    @Nonnegative
    private final int name;
    @Nonnegative
    private final int desc;
    @Nullable
    private final SignatureWriter signatureWriter;
    @Nonnegative
    private final int value;

    FieldWriter(@Nonnull ClassWriter cw, int access, @Nonnull String name, @Nonnull String desc, @Nullable String signature, @Nullable Object value) {
        this.cp = cw.cp;
        this.access = access;
        this.name = this.cp.newUTF8(name);
        this.desc = this.cp.newUTF8(desc);
        this.signatureWriter = signature == null ? null : new SignatureWriter(this.cp, signature);
        this.value = value == null ? 0 : this.cp.newConstItem((Object)value).index;
        this.createMarkerAttributes(cw.version);
    }

    @Override
    @Nonnull
    public AnnotationVisitor visitAnnotation(@Nonnull String desc) {
        return this.addAnnotation(desc);
    }

    @Nonnegative
    int getSize() {
        int size = 8 + this.getMarkerAttributesSize() + this.getAnnotationsSize();
        if (this.value != 0) {
            this.cp.newUTF8("ConstantValue");
            size += 8;
        }
        if (this.signatureWriter != null) {
            size += this.signatureWriter.getSize();
        }
        return size;
    }

    @Override
    void put(@Nonnull ByteVector out) {
        this.putAccess(out, 0);
        out.putShort(this.name);
        out.putShort(this.desc);
        int attributeCount = this.getAttributeCount();
        out.putShort(attributeCount);
        if (this.value != 0) {
            out.putShort(this.cp.newUTF8("ConstantValue"));
            out.putInt(2).putShort(this.value);
        }
        this.putMarkerAttributes(out);
        if (this.signatureWriter != null) {
            this.signatureWriter.put(out);
        }
        this.putAnnotations(out);
    }

    @Nonnegative
    private int getAttributeCount() {
        int attributeCount = this.getMarkerAttributeCount();
        if (this.value != 0) {
            ++attributeCount;
        }
        if (this.signatureWriter != null) {
            ++attributeCount;
        }
        if (this.annotations != null) {
            ++attributeCount;
        }
        return attributeCount;
    }
}

