/*
 * Decompiled with CFR 0.152.
 */
package mockit.asm;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.asm.BootstrapMethods;
import mockit.asm.ClassMemberItem;
import mockit.asm.ClassReader;
import mockit.asm.ClassWriter;
import mockit.asm.DoubleItem;
import mockit.asm.FloatItem;
import mockit.asm.IntItem;
import mockit.asm.InvokeDynamicItem;
import mockit.asm.Item;
import mockit.asm.LongItem;
import mockit.asm.MethodHandle;
import mockit.asm.MethodHandleItem;
import mockit.asm.NameAndTypeItem;
import mockit.asm.StringItem;

final class ConstantPoolCopying {
    @Nonnull
    private final ClassReader source;
    @Nonnull
    private final ClassWriter destination;
    @Nonnull
    private final Item[] newItems;
    @Nonnegative
    private int itemIndex;

    ConstantPoolCopying(@Nonnull ClassReader source, @Nonnull ClassWriter destination) {
        this.source = source;
        this.destination = destination;
        this.newItems = new Item[source.items.length];
    }

    void copyPool(@Nullable BootstrapMethods bootstrapMethods) {
        if (bootstrapMethods != null) {
            bootstrapMethods.copyBootstrapMethods(this.source, this.newItems);
        }
        int[] items = this.source.items;
        int itemCount = items.length;
        this.itemIndex = 1;
        while (this.itemIndex < itemCount) {
            this.source.codeIndex = items[this.itemIndex] - 1;
            int itemType = this.source.readSignedByte();
            Item newItem = this.copyItem(itemType);
            newItem.setNext(this.newItems);
            ++this.itemIndex;
        }
        int off = items[1] - 1;
        this.destination.cp.copy(this.source.code, off, this.source.header, this.newItems);
    }

    @Nonnull
    private Item copyItem(int itemType) {
        switch (itemType) {
            case 9: 
            case 10: 
            case 11: {
                return this.copyFieldOrMethodReferenceItem(itemType);
            }
            case 3: {
                return this.copyIntItem();
            }
            case 4: {
                return this.copyFloatItem();
            }
            case 12: {
                return this.copyNameAndTypeItem();
            }
            case 5: {
                return this.copyLongItem();
            }
            case 6: {
                return this.copyDoubleItem();
            }
            case 1: {
                return this.copyUTF8Item();
            }
            case 15: {
                return this.copyHandleItem();
            }
            case 18: {
                return this.copyInvokeDynamicItem();
            }
        }
        return this.copyNameReferenceItem(itemType);
    }

    @Nonnull
    private Item copyIntItem() {
        int itemValue = this.source.readInt();
        IntItem item = new IntItem(this.itemIndex);
        item.setValue(itemValue);
        return item;
    }

    @Nonnull
    private Item copyLongItem() {
        long itemValue = this.source.readLong();
        LongItem item = new LongItem(this.itemIndex);
        item.setValue(itemValue);
        ++this.itemIndex;
        return item;
    }

    @Nonnull
    private Item copyFloatItem() {
        float itemValue = this.source.readFloat();
        FloatItem item = new FloatItem(this.itemIndex);
        item.set(itemValue);
        return item;
    }

    @Nonnull
    private Item copyDoubleItem() {
        double itemValue = this.source.readDouble();
        DoubleItem item = new DoubleItem(this.itemIndex);
        item.set(itemValue);
        ++this.itemIndex;
        return item;
    }

    @Nonnull
    private Item copyUTF8Item() {
        String string = this.source.readString(this.itemIndex);
        return new StringItem(this.itemIndex, 1, string);
    }

    @Nonnull
    private Item copyNameReferenceItem(int type) {
        String string = this.source.readNonnullUTF8();
        return new StringItem(this.itemIndex, type, string);
    }

    @Nonnull
    private Item copyNameAndTypeItem() {
        String name = this.source.readNonnullUTF8();
        String type = this.source.readNonnullUTF8();
        NameAndTypeItem item = new NameAndTypeItem(this.itemIndex);
        item.set(name, type);
        return item;
    }

    @Nonnull
    private Item copyFieldOrMethodReferenceItem(int type) {
        String classDesc = this.source.readNonnullClass();
        int nameCodeIndex = this.source.readItem();
        String methodName = this.source.readNonnullUTF8(nameCodeIndex);
        String methodDesc = this.source.readNonnullUTF8(nameCodeIndex + 2);
        ClassMemberItem item = new ClassMemberItem(this.itemIndex);
        item.set(type, classDesc, methodName, methodDesc);
        return item;
    }

    @Nonnull
    private Item copyHandleItem() {
        int tag = this.source.readUnsignedByte();
        int fieldOrMethodRef = this.source.readItem();
        int nameCodeIndex = this.source.readItem(fieldOrMethodRef + 2);
        String classDesc = this.source.readNonnullClass(fieldOrMethodRef);
        String name = this.source.readNonnullUTF8(nameCodeIndex);
        String desc = this.source.readNonnullUTF8(nameCodeIndex + 2);
        MethodHandle handle = new MethodHandle(tag, classDesc, name, desc);
        MethodHandleItem item = new MethodHandleItem(this.itemIndex);
        item.set(handle);
        return item;
    }

    @Nonnull
    private Item copyInvokeDynamicItem() {
        int bsmIndex = this.source.readUnsignedShort();
        int nameCodeIndex = this.source.readItem();
        String name = this.source.readNonnullUTF8(nameCodeIndex);
        String desc = this.source.readNonnullUTF8(nameCodeIndex + 2);
        InvokeDynamicItem item = new InvokeDynamicItem(this.itemIndex);
        item.set(name, desc, bsmIndex);
        return item;
    }
}

