/*
 * Decompiled with CFR 0.152.
 */
package mockit.asm;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.asm.AnnotationVisitor;
import mockit.asm.BaseWriter;
import mockit.asm.BootstrapMethods;
import mockit.asm.ByteVector;
import mockit.asm.ClassMetadataReader;
import mockit.asm.ClassReader;
import mockit.asm.ClassVisitor;
import mockit.asm.ConstantPoolCopying;
import mockit.asm.ConstantPoolGeneration;
import mockit.asm.FieldVisitor;
import mockit.asm.FieldWriter;
import mockit.asm.InnerClassesWriter;
import mockit.asm.Interfaces;
import mockit.asm.MethodWriter;
import mockit.asm.OuterClassWriter;
import mockit.asm.SignatureWriter;
import mockit.asm.SourceInfoWriter;
import mockit.internal.util.ClassLoad;

public final class ClassWriter
extends ClassVisitor {
    @Nonnull
    final byte[] code;
    private final boolean computeFrames;
    int version;
    private int name;
    String thisName;
    private int superName;
    @Nullable
    private Interfaces interfaces;
    @Nullable
    private SignatureWriter signatureWriter;
    @Nonnull
    private final SourceInfoWriter sourceInfo;
    @Nullable
    private OuterClassWriter outerClassWriter;
    @Nullable
    private InnerClassesWriter innerClassesWriter;
    @Nullable
    final BootstrapMethods bootstrapMethods;
    @Nonnull
    private final List<FieldWriter> fields;
    @Nonnull
    private final List<MethodWriter> methods;

    public ClassWriter(@Nonnull ClassReader classReader) {
        this.code = classReader.code;
        this.version = classReader.getVersion();
        this.computeFrames = this.version >= 51;
        this.cp = new ConstantPoolGeneration();
        this.sourceInfo = new SourceInfoWriter(this.cp);
        this.bootstrapMethods = classReader.positionAtBootstrapMethodsAttribute() ? new BootstrapMethods(this.cp, classReader) : null;
        new ConstantPoolCopying(classReader, this).copyPool(this.bootstrapMethods);
        this.fields = new ArrayList<FieldWriter>();
        this.methods = new ArrayList<MethodWriter>();
    }

    public ClassWriter(@Nonnull byte[] code) {
        this.code = code;
        this.version = ClassMetadataReader.readVersion(code);
        this.computeFrames = this.version >= 51;
        this.cp = new ConstantPoolGeneration();
        this.sourceInfo = new SourceInfoWriter(this.cp);
        this.bootstrapMethods = null;
        this.fields = new ArrayList<FieldWriter>();
        this.methods = new ArrayList<MethodWriter>();
    }

    @Override
    public void visit(int version, int access, @Nonnull String name, @Nullable String signature, @Nullable String superName, @Nullable String[] interfaces) {
        this.version = version;
        this.access = access;
        this.name = this.cp.newClass(name);
        this.thisName = name;
        this.createMarkerAttributes(version);
        if (signature != null) {
            this.signatureWriter = new SignatureWriter(this.cp, signature);
        }
        int n = this.superName = superName == null ? 0 : this.cp.newClass(superName);
        if (interfaces != null && interfaces.length > 0) {
            this.interfaces = new Interfaces(this.cp, interfaces);
        }
        if (superName != null) {
            ClassLoad.addSuperClass(name, superName);
        }
    }

    @Override
    public void visitSource(@Nullable String file) {
        this.sourceInfo.setSourceFileName(file);
    }

    @Override
    public void visitOuterClass(@Nonnull String owner, @Nullable String name, @Nullable String desc) {
        this.outerClassWriter = new OuterClassWriter(this.cp, owner, name, desc);
    }

    @Override
    @Nonnull
    public AnnotationVisitor visitAnnotation(@Nonnull String desc) {
        return this.addAnnotation(desc);
    }

    @Override
    public void visitInnerClass(@Nonnull String name, @Nullable String outerName, @Nullable String innerName, int access) {
        if (this.innerClassesWriter == null) {
            this.innerClassesWriter = new InnerClassesWriter(this.cp);
        }
        this.innerClassesWriter.add(name, outerName, innerName, access);
    }

    @Override
    @Nonnull
    public FieldVisitor visitField(int access, @Nonnull String name, @Nonnull String desc, @Nullable String signature, @Nullable Object value) {
        FieldWriter field = new FieldWriter(this, access, name, desc, signature, value);
        this.fields.add(field);
        return field;
    }

    @Override
    @Nonnull
    public MethodWriter visitMethod(int access, @Nonnull String name, @Nonnull String desc, @Nullable String signature, @Nullable String[] exceptions) {
        MethodWriter method = new MethodWriter(this, access, name, desc, signature, exceptions, this.computeFrames);
        this.methods.add(method);
        return method;
    }

    @Override
    @Nonnull
    public byte[] toByteArray() {
        this.cp.checkConstantPoolMaxSize();
        int size = this.getBytecodeSize();
        ByteVector out = new ByteVector(size);
        this.putClassAttributes(out);
        this.putAnnotations(out);
        return out.data;
    }

    @Nonnegative
    private int getBytecodeSize() {
        int size = 24 + this.getMarkerAttributesSize() + this.getInterfacesSize() + this.getFieldsSize() + this.getMethodsSize() + this.sourceInfo.getSize();
        if (this.bootstrapMethods != null) {
            size += this.bootstrapMethods.getSize();
        }
        if (this.signatureWriter != null) {
            size += this.signatureWriter.getSize();
        }
        if (this.outerClassWriter != null) {
            size += this.outerClassWriter.getSize();
        }
        if (this.innerClassesWriter != null) {
            size += this.innerClassesWriter.getSize();
        }
        return size + this.getAnnotationsSize() + this.cp.getSize();
    }

    @Nonnegative
    private int getInterfacesSize() {
        return this.interfaces == null ? 0 : 2 * this.interfaces.getCount();
    }

    @Nonnegative
    private int getFieldsSize() {
        int size = 0;
        for (FieldWriter fb : this.fields) {
            size += fb.getSize();
        }
        return size;
    }

    @Nonnegative
    private int getMethodsSize() {
        int size = 0;
        for (MethodWriter mb : this.methods) {
            size += mb.getSize();
        }
        return size;
    }

    private void putClassAttributes(@Nonnull ByteVector out) {
        out.putInt(-889275714).putInt(this.version);
        this.cp.put(out);
        this.putAccess(out, 0);
        out.putShort(this.name);
        out.putShort(this.superName);
        int interfaceCount = this.interfaces == null ? 0 : this.interfaces.getCount();
        out.putShort(interfaceCount);
        if (interfaceCount > 0) {
            this.interfaces.put(out);
        }
        BaseWriter.put(out, this.fields);
        BaseWriter.put(out, this.methods);
        int attributeCount = this.getAttributeCount();
        out.putShort(attributeCount);
        if (this.bootstrapMethods != null) {
            this.bootstrapMethods.put(out);
        }
        if (this.signatureWriter != null) {
            this.signatureWriter.put(out);
        }
        this.sourceInfo.put(out);
        if (this.outerClassWriter != null) {
            this.outerClassWriter.put(out);
        }
        this.putMarkerAttributes(out);
        if (this.innerClassesWriter != null) {
            this.innerClassesWriter.put(out);
        }
    }

    @Nonnegative
    private int getAttributeCount() {
        int attributeCount = this.getMarkerAttributeCount() + this.sourceInfo.getAttributeCount();
        if (this.bootstrapMethods != null) {
            ++attributeCount;
        }
        if (this.signatureWriter != null) {
            ++attributeCount;
        }
        if (this.outerClassWriter != null) {
            ++attributeCount;
        }
        if (this.innerClassesWriter != null) {
            ++attributeCount;
        }
        if (this.annotations != null) {
            ++attributeCount;
        }
        return attributeCount;
    }

    boolean isJava6OrNewer() {
        return this.version >= 50;
    }
}

