/*
 * Decompiled with CFR 0.152.
 */
package mockit.asm;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.asm.AnnotatedReader;
import mockit.asm.ClassVisitor;
import mockit.asm.EnclosingMethod;
import mockit.asm.FieldReader;
import mockit.asm.MethodReader;

public final class ClassReader
extends AnnotatedReader {
    private static final String[] NO_INTERFACES = new String[0];
    @Nonnegative
    final int header;
    ClassVisitor cv;
    @Nonnegative
    int flags;
    @Nonnull
    private String[] interfaces = NO_INTERFACES;
    @Nullable
    private String sourceFileName;
    @Nullable
    private EnclosingMethod enclosingMethod;
    @Nonnegative
    private int innerClassesCodeIndex;
    @Nonnegative
    private int attributesCodeIndex;
    @Nullable
    int[] bootstrapMethods;

    public ClassReader(@Nonnull byte[] code) {
        super(code);
        this.header = this.codeIndex;
    }

    public int getVersion() {
        this.codeIndex = 6;
        return this.readShort();
    }

    public int getAccess() {
        this.codeIndex = this.header;
        return this.readUnsignedShort();
    }

    @Nonnull
    public String getSuperName() {
        this.codeIndex = this.header + 4;
        return this.readNonnullClass();
    }

    @Nonnull
    public byte[] getBytecode() {
        return this.code;
    }

    public void accept(ClassVisitor cv) {
        this.accept(cv, 0);
    }

    public void accept(@Nonnull ClassVisitor cv, @Nonnegative int flags) {
        this.cv = cv;
        this.flags = flags;
        int version = this.getVersion();
        this.codeIndex = this.header;
        this.access = this.readUnsignedShort();
        String classDesc = this.readNonnullClass();
        String superClassDesc = this.readClass();
        this.readInterfaces();
        this.readClassAttributes();
        cv.visit(version, this.access, classDesc, this.signature, superClassDesc, this.interfaces);
        this.visitSourceFileName();
        this.visitOuterClass();
        this.readAnnotations(cv);
        this.readInnerClasses();
        this.readFieldsAndMethods();
        cv.visitEnd();
    }

    private void readInterfaces() {
        int interfaceCount = this.readUnsignedShort();
        if (interfaceCount > 0) {
            this.interfaces = new String[interfaceCount];
            for (int i = 0; i < interfaceCount; ++i) {
                this.interfaces[i] = this.readNonnullClass();
            }
        }
    }

    private void readClassAttributes() {
        this.sourceFileName = null;
        this.enclosingMethod = null;
        this.innerClassesCodeIndex = 0;
        this.codeIndex = this.getAttributesStartIndex();
        this.readAttributes();
    }

    @Override
    @Nullable
    Boolean readAttribute(@Nonnull String attributeName) {
        if ("SourceFile".equals(attributeName)) {
            this.sourceFileName = this.readNonnullUTF8();
            return true;
        }
        if ("EnclosingMethod".equals(attributeName)) {
            this.enclosingMethod = new EnclosingMethod(this);
            return true;
        }
        if ("BootstrapMethods".equals(attributeName)) {
            this.readBootstrapMethods();
            return true;
        }
        if ("InnerClasses".equals(attributeName)) {
            if ((this.flags & 4) == 0) {
                this.innerClassesCodeIndex = this.codeIndex;
            }
            return false;
        }
        return null;
    }

    private void readBootstrapMethods() {
        int bsmCount = this.readUnsignedShort();
        this.bootstrapMethods = new int[bsmCount];
        for (int i = 0; i < bsmCount; ++i) {
            this.bootstrapMethods[i] = this.codeIndex;
            this.codeIndex += 2;
            int codeOffset = this.readUnsignedShort();
            this.codeIndex += codeOffset << 1;
        }
    }

    private void visitSourceFileName() {
        if ((this.flags & 2) == 0) {
            this.cv.visitSource(this.sourceFileName);
        }
    }

    private void visitOuterClass() {
        if (this.enclosingMethod != null) {
            this.cv.visitOuterClass(this.enclosingMethod.owner, this.enclosingMethod.name, this.enclosingMethod.desc);
        }
    }

    private void readInnerClasses() {
        int startIndex = this.innerClassesCodeIndex;
        if (startIndex != 0) {
            this.codeIndex = startIndex;
            for (int innerClassCount = this.readUnsignedShort(); innerClassCount > 0; --innerClassCount) {
                String name = this.readNonnullClass();
                String outerName = this.readClass();
                String innerName = this.readUTF8();
                int access = this.readUnsignedShort();
                this.cv.visitInnerClass(name, outerName, innerName, access);
            }
        }
    }

    private void readFieldsAndMethods() {
        this.codeIndex = this.getCodeIndexAfterInterfaces(this.interfaces.length);
        FieldReader fieldReader = new FieldReader(this);
        this.codeIndex = fieldReader.readFields();
        MethodReader methodReader = new MethodReader(this);
        this.codeIndex = methodReader.readMethods();
    }

    @Nonnegative
    private int getCodeIndexAfterInterfaces(@Nonnegative int interfaceCount) {
        return this.header + 8 + 2 * interfaceCount;
    }

    @Nonnegative
    private int getAttributesStartIndex() {
        if (this.attributesCodeIndex == 0) {
            this.skipHeader();
            this.skipClassMembers();
            this.skipClassMembers();
            this.attributesCodeIndex = this.codeIndex;
        }
        return this.attributesCodeIndex;
    }

    private void skipHeader() {
        int interfaceCount = this.readUnsignedShort(this.header + 6);
        this.codeIndex = this.getCodeIndexAfterInterfaces(interfaceCount);
    }

    private void skipClassMembers() {
        for (int memberCount = this.readUnsignedShort(); memberCount > 0; --memberCount) {
            this.codeIndex += 6;
            this.skipMemberAttributes();
        }
    }

    private void skipMemberAttributes() {
        for (int attributeCount = this.readUnsignedShort(); attributeCount > 0; --attributeCount) {
            this.codeIndex += 2;
            int codeOffsetToNextAttribute = this.readInt();
            this.codeIndex += codeOffsetToNextAttribute;
        }
    }

    boolean positionAtBootstrapMethodsAttribute() {
        this.codeIndex = this.getAttributesStartIndex();
        for (int attributeCount = this.readUnsignedShort(); attributeCount > 0; --attributeCount) {
            String attrName = this.readNonnullUTF8();
            if ("BootstrapMethods".equals(attrName)) {
                return true;
            }
            int codeOffsetToNextAttribute = this.readInt();
            this.codeIndex += codeOffsetToNextAttribute;
        }
        return false;
    }

    public static interface Flags {
        public static final int SKIP_CODE = 1;
        public static final int SKIP_DEBUG = 2;
        public static final int SKIP_CODE_DEBUG = 3;
        public static final int SKIP_INNER_CLASSES = 4;
    }
}

