/*
 * Decompiled with CFR 0.152.
 */
package mockit.asm;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.asm.ObjectWithAttributes;

public final class ClassMetadataReader
extends ObjectWithAttributes {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static final ConstantPoolTag[] CONSTANT_POOL_TAGS = ConstantPoolTag.values();
    @Nonnull
    private final byte[] code;
    @Nonnull
    private final int[] cpItemCodeIndexes;
    @Nullable
    private final EnumSet<Attribute> attributesToRead;
    @Nonnegative
    private final int cpEndIndex;
    @Nonnegative
    private int fieldsEndIndex;
    @Nonnegative
    private int methodsEndIndex;

    @Nonnegative
    public static int readVersion(@Nonnull byte[] code) {
        int byte0 = (code[4] & 0xFF) << 24;
        int byte1 = (code[5] & 0xFF) << 16;
        int byte2 = (code[6] & 0xFF) << 8;
        int byte3 = code[7] & 0xFF;
        return byte0 | byte1 | byte2 | byte3;
    }

    public ClassMetadataReader(@Nonnull byte[] code) {
        this(code, null);
    }

    public ClassMetadataReader(@Nonnull byte[] code, @Nullable EnumSet<Attribute> attributesToRead) {
        this.code = code;
        int cpItemCount = this.readUnsignedShort(8);
        int[] cpTable = new int[cpItemCount];
        this.cpItemCodeIndexes = cpTable;
        this.attributesToRead = attributesToRead;
        this.cpEndIndex = this.findEndIndexOfConstantPoolTable(cpTable);
    }

    @Nonnegative
    private int readUnsignedShort(@Nonnegative int codeIndex) {
        byte[] b = this.code;
        int i = codeIndex;
        int byte0 = (b[i++] & 0xFF) << 8;
        int byte1 = b[i] & 0xFF;
        return byte0 | byte1;
    }

    private int readInt(@Nonnegative int codeIndex) {
        byte[] b = this.code;
        int i = codeIndex;
        int byte0 = (b[i++] & 0xFF) << 24;
        int byte1 = (b[i++] & 0xFF) << 16;
        int byte2 = (b[i++] & 0xFF) << 8;
        int byte3 = b[i++] & 0xFF;
        return byte0 | byte1 | byte2 | byte3;
    }

    @Nonnegative
    private int findEndIndexOfConstantPoolTable(@Nonnull int[] cpTable) {
        byte[] b = this.code;
        int codeIndex = 10;
        int n = cpTable.length;
        for (int cpItemIndex = 1; cpItemIndex < n; ++cpItemIndex) {
            byte tagValue = b[codeIndex++];
            ConstantPoolTag tag = CONSTANT_POOL_TAGS[tagValue];
            cpTable[cpItemIndex] = codeIndex;
            int cpItemSize = tag.itemSize;
            if (tag == ConstantPoolTag.Long || tag == ConstantPoolTag.Double) {
                ++cpItemIndex;
            } else if (tag == ConstantPoolTag.Utf8) {
                int stringLength = this.readUnsignedShort(codeIndex);
                cpItemSize += stringLength;
            }
            codeIndex += cpItemSize;
        }
        return codeIndex;
    }

    @Nonnegative
    public int getVersion() {
        return ClassMetadataReader.readVersion(this.code);
    }

    @Nonnegative
    public int getAccessFlags() {
        return this.readUnsignedShort(this.cpEndIndex);
    }

    @Nonnull
    public String getThisClass() {
        int cpClassIndex = this.readUnsignedShort(this.cpEndIndex + 2);
        return this.getTypeDescription(cpClassIndex);
    }

    @Nonnull
    private String getTypeDescription(@Nonnegative int cpClassIndex) {
        int cpClassCodeIndex = this.cpItemCodeIndexes[cpClassIndex];
        int cpDescriptionIndex = this.readUnsignedShort(cpClassCodeIndex);
        return this.getString(cpDescriptionIndex);
    }

    @Nonnull
    private String getString(@Nonnegative int cpStringIndex) {
        int codeIndex = this.cpItemCodeIndexes[cpStringIndex];
        int stringLength = this.readUnsignedShort(codeIndex);
        return new String(this.code, codeIndex + 2, stringLength, UTF8);
    }

    @Nullable
    public String getSuperClass() {
        int cpClassIndex = this.readUnsignedShort(this.cpEndIndex + 4);
        if (cpClassIndex == 0) {
            return null;
        }
        return this.getTypeDescription(cpClassIndex);
    }

    @Nullable
    public String[] getInterfaces() {
        int codeIndex = this.cpEndIndex + 6;
        int interfaceCount = this.readUnsignedShort(codeIndex);
        if (interfaceCount == 0) {
            return null;
        }
        codeIndex += 2;
        String[] interfaces = new String[interfaceCount];
        for (int i = 0; i < interfaceCount; ++i) {
            int cpInterfaceIndex = this.readUnsignedShort(codeIndex);
            codeIndex += 2;
            interfaces[i] = this.getTypeDescription(cpInterfaceIndex);
        }
        return interfaces;
    }

    @Nonnull
    public List<FieldInfo> getFields() {
        List<FieldInfo> fields;
        int codeIndex = this.cpEndIndex + 6;
        int interfaceCount = this.readUnsignedShort(codeIndex);
        int fieldCount = this.readUnsignedShort(codeIndex += 2 + 2 * interfaceCount);
        codeIndex += 2;
        if (fieldCount == 0) {
            fields = Collections.emptyList();
        } else {
            fields = new ArrayList(fieldCount);
            for (int i = 0; i < fieldCount; ++i) {
                int accessFlags = this.readUnsignedShort(codeIndex);
                int cpNameIndex = this.readUnsignedShort(codeIndex += 2);
                String fieldName = this.getString(cpNameIndex);
                int cpDescIndex = this.readUnsignedShort(codeIndex += 2);
                String fieldDesc = this.getString(cpDescIndex);
                int attributeCount = this.readUnsignedShort(codeIndex += 2);
                codeIndex += 2;
                FieldInfo fieldInfo = new FieldInfo(accessFlags, fieldName, fieldDesc, attributeCount);
                codeIndex = this.readAttributes(attributeCount, fieldInfo, codeIndex);
                fields.add(fieldInfo);
            }
        }
        this.fieldsEndIndex = codeIndex;
        return fields;
    }

    @Nonnegative
    private int readAttributes(@Nonnegative int attributeCount, @Nullable ObjectWithAttributes attributeOwner, @Nonnegative int codeIndex) {
        EnumSet<Attribute> attributes = this.attributesToRead;
        boolean readAnnotations = false;
        if (attributes == null) {
            attributeOwner = null;
        } else {
            readAnnotations = attributes.contains((Object)Attribute.Annotations);
        }
        MethodInfo method = attributeOwner instanceof MethodInfo ? (MethodInfo)attributeOwner : null;
        for (int i = 0; i < attributeCount; ++i) {
            int cpNameIndex = this.readUnsignedShort(codeIndex);
            String attributeName = this.getString(cpNameIndex);
            int attributeLength = this.readInt(codeIndex += 2);
            codeIndex += 4;
            if (attributeOwner != null) {
                if (method != null) {
                    method.readAttributes(attributeName, codeIndex);
                }
                if (readAnnotations && "RuntimeVisibleAnnotations".equals(attributeName)) {
                    attributeOwner.annotations = this.readAnnotations(codeIndex);
                }
            }
            codeIndex += attributeLength;
        }
        return codeIndex;
    }

    @Nonnull
    private List<AnnotationInfo> readAnnotations(@Nonnegative int codeIndex) {
        int numAnnotations = this.readUnsignedShort(codeIndex);
        codeIndex += 2;
        ArrayList<AnnotationInfo> annotations = new ArrayList<AnnotationInfo>(numAnnotations);
        for (int i = 0; i < numAnnotations; ++i) {
            codeIndex = this.readAnnotation(annotations, codeIndex);
        }
        return annotations;
    }

    @Nonnegative
    private int readAnnotation(@Nonnull List<AnnotationInfo> currentAnnotations, @Nonnegative int codeIndex) {
        int cpTypeIndex = this.readUnsignedShort(codeIndex);
        String annotationTypeDesc = this.getString(cpTypeIndex);
        int numElementValuePairs = this.readUnsignedShort(codeIndex += 2);
        AnnotationInfo annotation = new AnnotationInfo(annotationTypeDesc);
        currentAnnotations.add(annotation);
        return codeIndex += 2;
    }

    @Nonnegative
    private int getFieldsEndIndex() {
        int codeIndex = this.fieldsEndIndex;
        if (codeIndex == 0) {
            codeIndex = this.cpEndIndex + 6;
            int interfaceCount = this.readUnsignedShort(codeIndex);
            int fieldCount = this.readUnsignedShort(codeIndex += 2 + 2 * interfaceCount);
            codeIndex += 2;
            for (int i = 0; i < fieldCount; ++i) {
                int attributeCount = this.readUnsignedShort(codeIndex += 6);
                codeIndex += 2;
                codeIndex = this.readAttributes(attributeCount, null, codeIndex);
            }
            this.fieldsEndIndex = codeIndex;
        }
        return codeIndex;
    }

    @Nonnull
    public List<MethodInfo> getMethods() {
        int codeIndex = this.getFieldsEndIndex();
        int methodCount = this.readUnsignedShort(codeIndex);
        codeIndex += 2;
        ArrayList<MethodInfo> methods = new ArrayList<MethodInfo>(methodCount);
        for (int i = 0; i < methodCount; ++i) {
            int accessFlags = this.readUnsignedShort(codeIndex);
            int cpNameIndex = this.readUnsignedShort(codeIndex += 2);
            String methodName = this.getString(cpNameIndex);
            int cpDescIndex = this.readUnsignedShort(codeIndex += 2);
            String methodDesc = this.getString(cpDescIndex);
            int attributeCount = this.readUnsignedShort(codeIndex += 2);
            codeIndex += 2;
            MethodInfo methodInfo = new MethodInfo(accessFlags, methodName, methodDesc, attributeCount);
            codeIndex = this.readAttributes(attributeCount, methodInfo, codeIndex);
            methods.add(methodInfo);
        }
        this.methodsEndIndex = codeIndex;
        return methods;
    }

    @Nonnegative
    private int getMethodsEndIndex() {
        int codeIndex = this.methodsEndIndex;
        if (codeIndex == 0) {
            codeIndex = this.getFieldsEndIndex();
            int methodCount = this.readUnsignedShort(codeIndex);
            codeIndex += 2;
            for (int i = 0; i < methodCount; ++i) {
                int attributeCount = this.readUnsignedShort(codeIndex += 6);
                codeIndex += 2;
                codeIndex = this.readAttributes(attributeCount, null, codeIndex);
            }
            this.methodsEndIndex = codeIndex;
        }
        return codeIndex;
    }

    @Nonnull
    public List<AnnotationInfo> getAnnotations() {
        if (this.annotations == null) {
            int codeIndex = this.getMethodsEndIndex();
            int attributeCount = this.readUnsignedShort(codeIndex);
            this.readAttributes(attributeCount, this, codeIndex += 2);
            if (this.annotations == null) {
                this.annotations = Collections.emptyList();
            }
        }
        return this.annotations;
    }

    public final class MethodInfo
    extends MemberInfo {
        @Nullable
        public String[] parameters;

        MethodInfo(@Nonnull int accessFlags, @Nonnull String name, @Nonnegative String desc, int attributeCount) {
            super(accessFlags, name, desc, attributeCount);
        }

        public boolean isConstructor() {
            return "<init>".equals(this.name);
        }

        void readAttributes(@Nonnull String attributeName, @Nonnegative int codeIndex) {
            if ("Code".equals(attributeName)) {
                if (ClassMetadataReader.this.attributesToRead.contains((Object)Attribute.Parameters)) {
                    this.readParameters(codeIndex);
                }
            } else if ("Signature".equals(attributeName) && ClassMetadataReader.this.attributesToRead.contains((Object)Attribute.Signature)) {
                this.readSignature(codeIndex);
            }
        }

        private void readParameters(@Nonnegative int codeIndex) {
            int codeLength = ClassMetadataReader.this.readInt(codeIndex += 4);
            int exceptionTableLength = ClassMetadataReader.this.readUnsignedShort(codeIndex += 4 + codeLength);
            int attributeCount = ClassMetadataReader.this.readUnsignedShort(codeIndex += 2 + 8 * exceptionTableLength);
            this.readParameters(attributeCount, codeIndex += 2);
        }

        private void readParameters(@Nonnegative int attributeCount, @Nonnegative int codeIndex) {
            for (int i = 0; i < attributeCount; ++i) {
                int cpNameIndex = ClassMetadataReader.this.readUnsignedShort(codeIndex);
                String attributeName = ClassMetadataReader.this.getString(cpNameIndex);
                int attributeLength = ClassMetadataReader.this.readInt(codeIndex += 2);
                codeIndex += 4;
                if ("LocalVariableTable".equals(attributeName)) {
                    this.parameters = this.readParametersFromLocalVariableTable(codeIndex);
                    break;
                }
                codeIndex += attributeLength;
            }
        }

        @Nullable
        private String[] readParametersFromLocalVariableTable(@Nonnegative int codeIndex) {
            int localVariableTableLength = ClassMetadataReader.this.readUnsignedShort(codeIndex);
            codeIndex += 2;
            int arraySize = this.getSumOfArgumentSizes(this.desc);
            if (arraySize == 0) {
                return null;
            }
            if (!this.isStatic()) {
                ++arraySize;
            }
            String[] parameters = new String[arraySize];
            for (int i = 0; i < localVariableTableLength; ++i) {
                int cpLocalVarNameIndex = ClassMetadataReader.this.readUnsignedShort(codeIndex += 4);
                codeIndex += 2;
                String localVarName = ClassMetadataReader.this.getString(cpLocalVarNameIndex);
                if ("this".equals(localVarName)) {
                    codeIndex += 4;
                    continue;
                }
                int localVarIndex = ClassMetadataReader.this.readUnsignedShort(codeIndex += 2);
                codeIndex += 2;
                if (localVarIndex >= arraySize) continue;
                parameters[localVarIndex] = localVarName;
            }
            return this.compactArray(parameters);
        }

        @Nonnegative
        private int getSumOfArgumentSizes(@Nonnull String memberDesc) {
            int sum = 0;
            int i = 1;
            while (true) {
                char c = memberDesc.charAt(i);
                ++i;
                if (c == ')') {
                    return sum;
                }
                if (c == 'L') {
                    while (memberDesc.charAt(i) != ';') {
                        ++i;
                    }
                    ++i;
                    ++sum;
                    continue;
                }
                if (c == '[') {
                    while ((c = memberDesc.charAt(i)) == '[') {
                        ++i;
                    }
                    if (!this.isDoubleSizeType(c)) continue;
                    ++i;
                    ++sum;
                    continue;
                }
                if (this.isDoubleSizeType(c)) {
                    sum += 2;
                    continue;
                }
                ++sum;
            }
        }

        private boolean isDoubleSizeType(char typeCode) {
            return typeCode == 'D' || typeCode == 'J';
        }

        @Nullable
        private String[] compactArray(@Nonnull String[] arrayPossiblyWithNulls) {
            int n = arrayPossiblyWithNulls.length;
            int i = 0;
            int j = n - 1;
            while (i < j) {
                if (arrayPossiblyWithNulls[i] == null) {
                    System.arraycopy(arrayPossiblyWithNulls, i + 1, arrayPossiblyWithNulls, i, j - i);
                    arrayPossiblyWithNulls[j] = null;
                    --j;
                    continue;
                }
                ++i;
            }
            return n == 1 && arrayPossiblyWithNulls[0] == null ? null : arrayPossiblyWithNulls;
        }

        private void readSignature(@Nonnegative int codeIndex) {
            int cpSignatureIndex = ClassMetadataReader.this.readUnsignedShort(codeIndex);
            this.signature = ClassMetadataReader.this.getString(cpSignatureIndex);
        }
    }

    public static final class ParameterInfo {
        @Nonnull
        public final String name;
        @Nonnull
        public final String desc;
        @Nonnegative
        public final int index;

        ParameterInfo(@Nonnull String name, @Nonnull String desc, int index) {
            this.name = name;
            this.desc = desc;
            this.index = index;
        }
    }

    public static final class AnnotationInfo {
        @Nonnull
        public final String name;

        AnnotationInfo(@Nonnull String name) {
            this.name = name;
        }
    }

    public static final class FieldInfo
    extends MemberInfo {
        FieldInfo(int accessFlags, @Nonnull String name, @Nonnull String desc, @Nonnegative int attributeCount) {
            super(accessFlags, name, desc, attributeCount);
        }
    }

    private static class MemberInfo
    extends ObjectWithAttributes {
        @Nonnegative
        public final int accessFlags;
        @Nonnull
        public final String name;
        @Nonnull
        public final String desc;
        @Nullable
        public String signature;

        MemberInfo(@Nonnegative int accessFlags, @Nonnull String name, @Nonnull String desc, @Nonnegative int attributeCount) {
            this.accessFlags = accessFlags;
            this.name = name;
            this.desc = desc;
        }

        public final boolean isStatic() {
            return (this.accessFlags & 8) != 0;
        }

        public final boolean isSynthetic() {
            return (this.accessFlags & 0x1000) != 0;
        }
    }

    public static enum Attribute {
        Annotations,
        Parameters,
        Signature;

    }

    static enum ConstantPoolTag {
        No0,
        Utf8(2),
        No2,
        Integer(4),
        Float(4),
        Long(8),
        Double(8),
        Class(2),
        String(2),
        FieldRef(4),
        MethodRef(4),
        InterfaceMethodRef(4),
        NameAndType(4),
        No13,
        No14,
        MethodHandle(3),
        MethodType(2),
        No17,
        InvokeDynamic(4),
        Module(2),
        Package(2);

        @Nonnegative
        final int itemSize;

        private ConstantPoolTag() {
            this.itemSize = 0;
        }

        private ConstantPoolTag(int itemSize) {
            this.itemSize = itemSize;
        }
    }
}

