/*
 * Decompiled with CFR 0.152.
 */
package mockit.asm;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.asm.MethodHandle;
import mockit.asm.MethodType;
import mockit.asm.ReferenceType;

class BytecodeReader {
    @Nonnull
    final byte[] code;
    @Nonnull
    final int[] items;
    @Nonnull
    private final String[] strings;
    @Nonnull
    private final char[] buf;
    @Nonnegative
    int codeIndex;

    BytecodeReader(@Nonnull byte[] code) {
        this.code = code;
        this.codeIndex = 8;
        int itemCount = this.readUnsignedShort();
        this.items = new int[itemCount];
        this.strings = new String[itemCount];
        int maxStringSize = this.readConstantPoolItems();
        this.buf = new char[maxStringSize];
    }

    @Nonnegative
    private int readConstantPoolItems() {
        int maxStringSize = 0;
        for (int itemIndex = 1; itemIndex < this.items.length; ++itemIndex) {
            int itemType = this.readSignedByte();
            this.items[itemIndex] = this.codeIndex;
            int itemSize = this.getItemSize(itemType);
            if (itemType == 5 || itemType == 6) {
                ++itemIndex;
            } else if (itemType == 1 && itemSize > maxStringSize) {
                maxStringSize = itemSize;
            }
            this.codeIndex += itemSize - 1;
        }
        return maxStringSize;
    }

    @Nonnegative
    private int getItemSize(int itemType) {
        switch (itemType) {
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 18: {
                return 5;
            }
            case 5: 
            case 6: {
                return 9;
            }
            case 1: {
                return 3 + this.readUnsignedShort(this.codeIndex);
            }
            case 15: {
                return 4;
            }
        }
        return 3;
    }

    BytecodeReader(@Nonnull BytecodeReader another) {
        this.code = another.code;
        this.items = another.items;
        this.strings = another.strings;
        this.buf = another.buf;
        this.codeIndex = another.codeIndex;
    }

    final int readUnsignedByte() {
        return this.code[this.codeIndex++] & 0xFF;
    }

    final int readUnsignedByte(@Nonnegative int u1CodeIndex) {
        return this.code[u1CodeIndex] & 0xFF;
    }

    final int readSignedByte() {
        return this.code[this.codeIndex++];
    }

    final char readChar(@Nonnegative int s4CodeIndex) {
        return (char)this.readInt(s4CodeIndex);
    }

    final boolean readBoolean(@Nonnegative int s4CodeIndex) {
        return this.readInt(s4CodeIndex) != 0;
    }

    @Nonnegative
    final int readUnsignedShort() {
        byte[] b = this.code;
        int i = this.codeIndex;
        int byte0 = (b[i++] & 0xFF) << 8;
        int byte1 = b[i++] & 0xFF;
        this.codeIndex = i;
        return byte0 | byte1;
    }

    @Nonnegative
    final int readUnsignedShort(@Nonnegative int u2CodeIndex) {
        byte[] b = this.code;
        return (b[u2CodeIndex] & 0xFF) << 8 | b[u2CodeIndex + 1] & 0xFF;
    }

    final short readShort() {
        return (short)this.readUnsignedShort();
    }

    final short readShort(@Nonnegative int u2CodeIndex) {
        return (short)this.readUnsignedShort(u2CodeIndex);
    }

    final int readInt() {
        byte[] b = this.code;
        int i = this.codeIndex;
        int byte0 = (b[i++] & 0xFF) << 24;
        int byte1 = (b[i++] & 0xFF) << 16;
        int byte2 = (b[i++] & 0xFF) << 8;
        int byte3 = b[i++] & 0xFF;
        this.codeIndex = i;
        return byte0 | byte1 | byte2 | byte3;
    }

    final int readInt(@Nonnegative int s4CodeIndex) {
        byte[] b = this.code;
        return (b[s4CodeIndex] & 0xFF) << 24 | (b[s4CodeIndex + 1] & 0xFF) << 16 | (b[s4CodeIndex + 2] & 0xFF) << 8 | b[s4CodeIndex + 3] & 0xFF;
    }

    final long readLong() {
        long l1 = this.readInt();
        long l0 = (long)this.readInt() & 0xFFFFFFFFL;
        return l1 << 32 | l0;
    }

    final long readLong(@Nonnegative int s8CodeIndex) {
        long l1 = this.readInt(s8CodeIndex);
        long l0 = (long)this.readInt(s8CodeIndex + 4) & 0xFFFFFFFFL;
        return l1 << 32 | l0;
    }

    final double readDouble() {
        long bits = this.readLong();
        return Double.longBitsToDouble(bits);
    }

    final double readDouble(@Nonnegative int s8CodeIndex) {
        long bits = this.readLong(s8CodeIndex);
        return Double.longBitsToDouble(bits);
    }

    final float readFloat() {
        int bits = this.readInt();
        return Float.intBitsToFloat(bits);
    }

    final float readFloat(@Nonnegative int s4CodeIndex) {
        int bits = this.readInt(s4CodeIndex);
        return Float.intBitsToFloat(bits);
    }

    @Nonnull
    private String readUTF(@Nonnegative int itemIndex) {
        int startIndex = this.items[itemIndex];
        int utfLen = this.readUnsignedShort(startIndex);
        int endIndex = (startIndex += 2) + utfLen;
        int strLen = 0;
        int st = 0;
        int cc = 0;
        while (startIndex < endIndex) {
            int c = this.code[startIndex++];
            if (st == 0) {
                if ((c &= 0xFF) < 128) {
                    this.buf[strLen++] = (char)c;
                    continue;
                }
                if (c < 224 && c > 191) {
                    cc = (char)(c & 0x1F);
                    st = 1;
                    continue;
                }
                cc = (char)(c & 0xF);
                st = 2;
                continue;
            }
            if (st == 1) {
                this.buf[strLen++] = (char)(cc << 6 | c & 0x3F);
                st = 0;
                continue;
            }
            cc = (char)(cc << 6 | c & 0x3F);
            st = 1;
        }
        return new String(this.buf, 0, strLen);
    }

    @Nullable
    final String readUTF8() {
        int itemIndex = this.readUnsignedShort();
        if (itemIndex == 0) {
            return null;
        }
        return this.readString(itemIndex);
    }

    @Nullable
    final String readUTF8(@Nonnegative int u2CodeIndex) {
        if (u2CodeIndex == 0) {
            return null;
        }
        int itemIndex = this.readUnsignedShort(u2CodeIndex);
        if (itemIndex == 0) {
            return null;
        }
        return this.readString(itemIndex);
    }

    @Nonnull
    final String readNonnullUTF8() {
        int itemIndex = this.readUnsignedShort();
        return this.readString(itemIndex);
    }

    @Nonnull
    final String readNonnullUTF8(@Nonnegative int u2CodeIndex) {
        int itemIndex = this.readUnsignedShort(u2CodeIndex);
        return this.readString(itemIndex);
    }

    @Nonnull
    final String readString(@Nonnegative int itemIndex) {
        String string = this.strings[itemIndex];
        if (string != null) {
            return string;
        }
        this.strings[itemIndex] = string = this.readUTF(itemIndex);
        return string;
    }

    @Nonnull
    final Object readConstItem() {
        int constIndex = this.readUnsignedShort();
        Object cst = this.readConst(constIndex);
        return cst;
    }

    @Nonnull
    final Object readConstItem(@Nonnegative int u2CodeIndex) {
        int itemIndex = this.readUnsignedShort(u2CodeIndex);
        return this.readConst(itemIndex);
    }

    @Nonnull
    final Object readConst(@Nonnegative int itemIndex) {
        int codeIndex = this.items[itemIndex];
        byte itemType = this.code[codeIndex - 1];
        switch (itemType) {
            case 3: {
                return this.readInt(codeIndex);
            }
            case 4: {
                return Float.valueOf(this.readFloat(codeIndex));
            }
            case 5: {
                return this.readLong(codeIndex);
            }
            case 6: {
                return this.readDouble(codeIndex);
            }
            case 8: {
                return this.readNonnullUTF8(codeIndex);
            }
            case 7: {
                String typeDesc = this.readNonnullUTF8(codeIndex);
                return ReferenceType.createFromInternalName(typeDesc);
            }
            case 16: {
                String methodDesc = this.readNonnullUTF8(codeIndex);
                return MethodType.create(methodDesc);
            }
        }
        return this.readMethodHandle(codeIndex);
    }

    @Nonnull
    final MethodHandle readMethodHandle() {
        int itemIndex = this.readUnsignedShort();
        int codeIndex = this.items[itemIndex];
        return this.readMethodHandle(codeIndex);
    }

    @Nonnull
    final MethodHandle readMethodHandleItem(@Nonnegative int bsmCodeIndex) {
        int itemIndex = this.readUnsignedShort(bsmCodeIndex);
        bsmCodeIndex = this.items[itemIndex];
        return this.readMethodHandle(bsmCodeIndex);
    }

    @Nonnull
    private MethodHandle readMethodHandle(@Nonnegative int bsmCodeIndex) {
        int tag = this.readUnsignedByte(bsmCodeIndex);
        int classIndex = this.readItem(bsmCodeIndex + 1);
        String owner = this.readNonnullClass(classIndex);
        int nameIndex = this.readItem(classIndex + 2);
        String name = this.readNonnullUTF8(nameIndex);
        String desc = this.readNonnullUTF8(nameIndex + 2);
        return new MethodHandle(tag, owner, name, desc);
    }

    @Nullable
    final String readClass() {
        int itemCodeIndex = this.readItem();
        String classDesc = this.readUTF8(itemCodeIndex);
        return classDesc;
    }

    @Nullable
    final String readClass(@Nonnegative int u2CodeIndex) {
        int itemCodeIndex = this.readItem(u2CodeIndex);
        String classDesc = this.readUTF8(itemCodeIndex);
        return classDesc;
    }

    @Nonnull
    final String readNonnullClass() {
        int itemCodeIndex = this.readItem();
        String classDesc = this.readNonnullUTF8(itemCodeIndex);
        return classDesc;
    }

    @Nonnull
    final String readNonnullClass(@Nonnegative int u2CodeIndex) {
        int itemCodeIndex = this.readItem(u2CodeIndex);
        String classDesc = this.readNonnullUTF8(itemCodeIndex);
        return classDesc;
    }

    @Nonnegative
    final int readItem() {
        int itemIndex = this.readUnsignedShort();
        return this.items[itemIndex];
    }

    @Nonnegative
    final int readItem(@Nonnegative int u2CodeIndex) {
        int itemIndex = this.readUnsignedShort(u2CodeIndex);
        return this.items[itemIndex];
    }
}

