/*
 * Decompiled with CFR 0.152.
 */
package mockit.asm;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

final class ByteVector {
    @Nonnull
    byte[] data;
    @Nonnegative
    int length;

    ByteVector() {
        this.data = new byte[64];
    }

    ByteVector(@Nonnegative int initialSize) {
        this.data = new byte[initialSize];
    }

    @Nonnull
    ByteVector putByte(int b) {
        int length = this.getLengthEnlargingIfNeeded(1);
        this.data[length++] = (byte)b;
        this.length = length;
        return this;
    }

    @Nonnegative
    private int getLengthEnlargingIfNeeded(@Nonnegative int bytesToAdd) {
        int length = this.length;
        if (length + bytesToAdd > this.data.length) {
            this.enlarge(bytesToAdd);
        }
        return length;
    }

    private void enlarge(@Nonnegative int size) {
        int length1 = 2 * this.data.length;
        int length2 = this.length + size;
        byte[] newData = new byte[length1 > length2 ? length1 : length2];
        System.arraycopy(this.data, 0, newData, 0, this.length);
        this.data = newData;
    }

    @Nonnull
    ByteVector put11(int b1, int b2) {
        int length = this.getLengthEnlargingIfNeeded(2);
        byte[] data = this.data;
        data[length++] = (byte)b1;
        data[length++] = (byte)b2;
        this.length = length;
        return this;
    }

    @Nonnull
    ByteVector putShort(int s) {
        return this.put11(s >>> 8, s);
    }

    @Nonnull
    ByteVector put12(int b, int s) {
        int length = this.getLengthEnlargingIfNeeded(3);
        byte[] data = this.data;
        data[length++] = (byte)b;
        data[length++] = (byte)(s >>> 8);
        data[length++] = (byte)s;
        this.length = length;
        return this;
    }

    @Nonnull
    ByteVector putInt(int i) {
        int length = this.getLengthEnlargingIfNeeded(4);
        byte[] data = this.data;
        data[length++] = (byte)(i >>> 24);
        data[length++] = (byte)(i >>> 16);
        data[length++] = (byte)(i >>> 8);
        data[length++] = (byte)i;
        this.length = length;
        return this;
    }

    void putLong(long l) {
        int i1 = (int)(l >>> 32);
        int i2 = (int)l;
        this.putInt(i1);
        this.putInt(i2);
    }

    void putUTF8(@Nonnull String string) {
        int charLength = string.length();
        if (charLength > 65535) {
            throw new IllegalArgumentException("String too long: " + charLength);
        }
        int len = this.getLengthEnlargingIfNeeded(2 + charLength);
        byte[] data = this.data;
        data[len++] = (byte)(charLength >>> 8);
        data[len++] = (byte)charLength;
        for (int i = 0; i < charLength; ++i) {
            char c = string.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                data[len++] = (byte)c;
                continue;
            }
            this.length = len;
            this.encodeUTF8(string, i);
        }
        this.length = len;
    }

    private void encodeUTF8(@Nonnull String string, @Nonnegative int startIndex) {
        int byteLength = ByteVector.computeByteLength(string, startIndex);
        if (byteLength > 65535) {
            throw new IllegalArgumentException("String too long for UTF8 encoding: " + byteLength);
        }
        int start = this.length - startIndex - 2;
        if (start >= 0) {
            this.data[start] = (byte)(byteLength >>> 8);
            this.data[start + 1] = (byte)byteLength;
        }
        if (this.length + byteLength - startIndex > this.data.length) {
            this.enlarge(byteLength - startIndex);
        }
        this.putEncodedCharacters(string, startIndex);
    }

    @Nonnegative
    private static int computeByteLength(@Nonnull String string, @Nonnegative int startIndex) {
        int byteLength = startIndex;
        int n = string.length();
        for (int i = startIndex; i < n; ++i) {
            char c = string.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                ++byteLength;
                continue;
            }
            if (c > '\u07ff') {
                byteLength += 3;
                continue;
            }
            byteLength += 2;
        }
        return byteLength;
    }

    private void putEncodedCharacters(@Nonnull String string, @Nonnegative int startIndex) {
        byte[] data = this.data;
        int len = this.length;
        int n = string.length();
        for (int i = startIndex; i < n; ++i) {
            char c = string.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                data[len++] = (byte)c;
                continue;
            }
            if (c > '\u07ff') {
                data[len++] = (byte)(0xE0 | c >> 12 & 0xF);
                data[len++] = (byte)(0x80 | c >> 6 & 0x3F);
                data[len++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            data[len++] = (byte)(0xC0 | c >> 6 & 0x1F);
            data[len++] = (byte)(0x80 | c & 0x3F);
        }
        this.length = len;
    }

    void putByteArray(@Nonnull byte[] bytes, @Nonnegative int off, @Nonnegative int len) {
        int length = this.getLengthEnlargingIfNeeded(len);
        System.arraycopy(bytes, off, this.data, length, len);
        this.length += len;
    }

    void putByteVector(@Nonnull ByteVector another) {
        this.putByteArray(another.data, 0, another.length);
    }

    void increaseLengthBy(@Nonnegative int len) {
        this.getLengthEnlargingIfNeeded(len);
        this.length += len;
    }
}

