/*
 * Decompiled with CFR 0.152.
 */
package mockit.asm;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import mockit.asm.BootstrapMethodItem;
import mockit.asm.ByteVector;
import mockit.asm.ClassReader;
import mockit.asm.ConstantPoolGeneration;
import mockit.asm.InvokeDynamicItem;
import mockit.asm.Item;
import mockit.asm.MethodHandle;
import mockit.asm.MethodHandleItem;

final class BootstrapMethods {
    @Nonnull
    private final ConstantPoolGeneration cp;
    @Nonnegative
    private final int bootstrapMethodsCount;
    @Nonnull
    private final ByteVector bootstrapMethods;
    @Nonnegative
    private final int bsmStartCodeIndex;

    BootstrapMethods(@Nonnull ConstantPoolGeneration cp, @Nonnull ClassReader cr) {
        this.cp = cp;
        int attrSize = cr.readInt();
        this.bootstrapMethods = new ByteVector(attrSize + 62);
        this.bootstrapMethodsCount = cr.readUnsignedShort();
        this.bsmStartCodeIndex = cr.codeIndex;
        this.bootstrapMethods.putByteArray(cr.code, this.bsmStartCodeIndex, attrSize - 2);
    }

    void copyBootstrapMethods(@Nonnull ClassReader cr, @Nonnull Item[] items) {
        int previousCodeIndex = cr.codeIndex;
        cr.codeIndex = this.bsmStartCodeIndex;
        for (int bsmIndex = 0; bsmIndex < this.bootstrapMethodsCount; ++bsmIndex) {
            this.copyBootstrapMethod(cr, items, bsmIndex);
        }
        cr.codeIndex = previousCodeIndex;
    }

    private void copyBootstrapMethod(@Nonnull ClassReader cr, @Nonnull Item[] items, @Nonnegative int bsmIndex) {
        int position = cr.codeIndex - this.bsmStartCodeIndex;
        MethodHandle bsm = cr.readMethodHandle();
        int hashCode = bsm.hashCode();
        for (int bsmArgCount = cr.readUnsignedShort(); bsmArgCount > 0; --bsmArgCount) {
            Object bsmArg = cr.readConstItem();
            hashCode ^= bsmArg.hashCode();
        }
        BootstrapMethodItem item = new BootstrapMethodItem(bsmIndex, position, hashCode);
        item.setNext(items);
    }

    @Nonnull
    InvokeDynamicItem addInvokeDynamicReference(@Nonnull String name, @Nonnull String desc, @Nonnull MethodHandle bsm, Object ... bsmArgs) {
        ByteVector methods = this.bootstrapMethods;
        int position = methods.length;
        MethodHandleItem methodHandleItem = this.cp.newMethodHandleItem(bsm);
        methods.putShort(methodHandleItem.index);
        int argsLength = bsmArgs.length;
        methods.putShort(argsLength);
        int hashCode = bsm.hashCode();
        hashCode = this.putBSMArgs(hashCode, bsmArgs);
        methods.length = position;
        BootstrapMethodItem bsmItem = this.getBSMItem(hashCode &= Integer.MAX_VALUE);
        InvokeDynamicItem result = this.cp.createInvokeDynamicItem(name, desc, bsmItem.index);
        return result;
    }

    private int putBSMArgs(int hashCode, @Nonnull Object[] bsmArgs) {
        for (Object bsmArg : bsmArgs) {
            hashCode ^= bsmArg.hashCode();
            Item constItem = this.cp.newConstItem(bsmArg);
            this.bootstrapMethods.putShort(constItem.index);
        }
        return hashCode;
    }

    @Nonnull
    private BootstrapMethodItem getBSMItem(int hashCode) {
        Item item = this.cp.getItem(hashCode);
        while (item != null) {
            if (item instanceof BootstrapMethodItem && item.hashCode == hashCode) {
                return (BootstrapMethodItem)item;
            }
            item = item.next;
        }
        throw new IllegalStateException("BootstrapMethodItem not found for hash code " + hashCode);
    }

    @Nonnegative
    int getSize() {
        this.cp.newUTF8("BootstrapMethods");
        return 8 + this.bootstrapMethods.length;
    }

    void put(@Nonnull ByteVector out) {
        out.putShort(this.cp.newUTF8("BootstrapMethods"));
        out.putInt(this.bootstrapMethods.length + 2).putShort(this.bootstrapMethodsCount);
        out.putByteVector(this.bootstrapMethods);
    }
}

