/*
 * Decompiled with CFR 0.152.
 */
package mockit.asm;

import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.asm.Access;
import mockit.asm.AnnotationVisitor;
import mockit.asm.AnnotationWriter;
import mockit.asm.ByteVector;
import mockit.asm.ConstantPoolGeneration;

class BaseWriter {
    @Nonnull
    ConstantPoolGeneration cp;
    int access;
    @Nonnegative
    private int deprecatedAttributeIndex;
    @Nonnegative
    private int syntheticAttributeIndex;
    @Nullable
    AnnotationWriter annotations;

    BaseWriter() {
    }

    @Nullable
    public AnnotationVisitor visitAnnotation(@Nonnull String desc) {
        return null;
    }

    public void visitEnd() {
    }

    final void createMarkerAttributes(int classVersion) {
        if (Access.isDeprecated(this.access)) {
            this.deprecatedAttributeIndex = this.cp.newUTF8("Deprecated");
        }
        if (Access.isSynthetic(this.access, classVersion)) {
            this.syntheticAttributeIndex = this.cp.newUTF8("Synthetic");
        }
    }

    @Nonnull
    final AnnotationVisitor addAnnotation(@Nonnull String desc) {
        AnnotationWriter aw = new AnnotationWriter(this.cp, desc);
        aw.next = this.annotations;
        this.annotations = aw;
        return aw;
    }

    @Nonnegative
    final int getAnnotationsSize() {
        if (this.annotations != null) {
            this.getConstantPoolItemForRuntimeVisibleAnnotationsAttribute();
            return 8 + this.annotations.getSize();
        }
        return 0;
    }

    @Nonnegative
    private int getConstantPoolItemForRuntimeVisibleAnnotationsAttribute() {
        return this.cp.newUTF8("RuntimeVisibleAnnotations");
    }

    @Nonnegative
    final int getMarkerAttributeCount() {
        return (this.deprecatedAttributeIndex == 0 ? 0 : 1) + (this.syntheticAttributeIndex == 0 ? 0 : 1);
    }

    @Nonnegative
    final int getMarkerAttributesSize() {
        int attributeCount = this.getMarkerAttributeCount();
        return 6 * attributeCount;
    }

    final void putAccess(@Nonnull ByteVector out, int baseMask) {
        int accessFlag = Access.computeFlag(this.access, baseMask);
        out.putShort(accessFlag);
    }

    final void putMarkerAttributes(@Nonnull ByteVector out) {
        if (this.deprecatedAttributeIndex > 0) {
            out.putShort(this.deprecatedAttributeIndex).putInt(0);
        }
        if (this.syntheticAttributeIndex > 0) {
            out.putShort(this.syntheticAttributeIndex).putInt(0);
        }
    }

    final void putAnnotations(@Nonnull ByteVector out) {
        if (this.annotations != null) {
            int item = this.getConstantPoolItemForRuntimeVisibleAnnotationsAttribute();
            out.putShort(item);
            this.annotations.put(out);
        }
    }

    void put(@Nonnull ByteVector out) {
    }

    static void put(@Nonnull ByteVector out, @Nonnull List<? extends BaseWriter> writers) {
        out.putShort(writers.size());
        for (BaseWriter baseWriter : writers) {
            baseWriter.put(out);
        }
    }
}

