/*
 * Decompiled with CFR 0.152.
 */
package mockit.asm;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import mockit.asm.ByteVector;
import mockit.asm.ConstantPoolGeneration;

abstract class AttributeWriter {
    @Nonnull
    final ConstantPoolGeneration cp;
    @Nonnegative
    private int attributeIndex;

    AttributeWriter(@Nonnull ConstantPoolGeneration cp) {
        this.cp = cp;
    }

    AttributeWriter(@Nonnull ConstantPoolGeneration cp, @Nonnull String attributeName) {
        this.cp = cp;
        this.setAttribute(attributeName);
    }

    final void setAttribute(@Nonnull String attributeName) {
        this.attributeIndex = this.cp.newUTF8(attributeName);
    }

    @Nonnegative
    int getAttributeCount() {
        return this.attributeIndex == 0 ? 0 : 1;
    }

    @Nonnegative
    abstract int getSize();

    void put(@Nonnull ByteVector out) {
        this.put(out, 2);
    }

    final void put(@Nonnull ByteVector out, @Nonnegative int size) {
        out.putShort(this.attributeIndex).putInt(size);
    }
}

