/*
 * Decompiled with CFR 0.152.
 */
package mockit.asm;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import mockit.asm.JavaType;
import mockit.asm.ReferenceType;

public final class ArrayType
extends ReferenceType {
    @Nonnull
    public static ArrayType create(@Nonnull String typeDesc) {
        return new ArrayType(typeDesc.toCharArray());
    }

    @Nonnull
    static ArrayType create(@Nonnull char[] buf, @Nonnegative int off) {
        int len = ArrayType.findNumberOfDimensions(buf, off);
        if (buf[off + len] == 'L') {
            len = ArrayType.findTypeNameLength(buf, off, len);
        }
        return new ArrayType(buf, off, len + 1);
    }

    @Nonnegative
    private static int findNumberOfDimensions(@Nonnull char[] buf, @Nonnegative int off) {
        int dimensions = 1;
        while (buf[off + dimensions] == '[') {
            ++dimensions;
        }
        return dimensions;
    }

    private ArrayType(@Nonnull char[] buf, @Nonnegative int off, @Nonnegative int len) {
        super(buf, off, len);
    }

    ArrayType(@Nonnull char[] buf) {
        super(buf);
    }

    @Nonnegative
    public int getDimensions() {
        return ArrayType.findNumberOfDimensions(this.buf, this.off);
    }

    @Nonnull
    public JavaType getElementType() {
        int dimensions = this.getDimensions();
        return ArrayType.getType(this.buf, this.off + dimensions);
    }

    @Override
    @Nonnull
    public String getClassName() {
        int dimensions;
        String className = this.getElementType().getClassName();
        StringBuilder sb = new StringBuilder(className);
        for (int i = dimensions = this.getDimensions(); i > 0; --i) {
            sb.append("[]");
        }
        return sb.toString();
    }
}

