/*
 * Decompiled with CFR 0.152.
 */
package mockit.asm;

import java.lang.reflect.Array;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.asm.AnnotationVisitor;
import mockit.asm.ByteVector;
import mockit.asm.ConstantPoolGeneration;
import mockit.asm.DoubleItem;
import mockit.asm.FloatItem;
import mockit.asm.IntItem;
import mockit.asm.Item;
import mockit.asm.JavaType;
import mockit.asm.LongItem;

final class AnnotationWriter
extends AnnotationVisitor {
    @Nonnull
    private final ConstantPoolGeneration cp;
    @Nonnegative
    private int size;
    private final boolean named;
    @Nonnull
    private final ByteVector bv;
    @Nonnegative
    private final int offset;

    AnnotationWriter(@Nonnull ConstantPoolGeneration cp, @Nonnull String typeDesc) {
        this.cp = cp;
        this.named = true;
        this.bv = new ByteVector();
        this.bv.putShort(cp.newUTF8(typeDesc));
        this.bv.putShort(0);
        this.offset = 2;
    }

    private AnnotationWriter(@Nonnull AnnotationWriter parent, boolean named) {
        this.cp = parent.cp;
        this.named = named;
        this.bv = parent.bv;
        this.offset = this.bv.length - 2;
    }

    @Override
    @Nonnegative
    protected int getByteLength() {
        return this.bv.length;
    }

    @Override
    public void visit(@Nullable String name, @Nonnull Object value) {
        this.putName(name);
        if (value instanceof String) {
            this.putString(115, (String)value);
        } else if (!this.putValueWhenPrimitive(value)) {
            if (value instanceof JavaType) {
                this.putType((JavaType)value);
            } else {
                this.putElementValuesWhenArray(value);
            }
        }
    }

    private void putName(@Nullable String name) {
        ++this.size;
        if (this.named) {
            this.putString(name);
        }
    }

    private boolean putValueWhenPrimitive(@Nonnull Object value) {
        if (value instanceof Boolean) {
            this.putBoolean((Boolean)value);
        } else if (value instanceof Integer) {
            this.putInteger(73, (Integer)value);
        } else if (value instanceof Double) {
            this.putDouble((Double)value);
        } else if (value instanceof Float) {
            this.putFloat(((Float)value).floatValue());
        } else if (value instanceof Long) {
            this.putLong((Long)value);
        } else if (value instanceof Byte) {
            this.putInteger(66, ((Byte)value).byteValue());
        } else if (value instanceof Character) {
            this.putInteger(67, ((Character)value).charValue());
        } else if (value instanceof Short) {
            this.putInteger(83, ((Short)value).shortValue());
        } else {
            return false;
        }
        return true;
    }

    private void putItem(int typeCode, @Nonnull Item item) {
        this.bv.put12(typeCode, item.index);
    }

    private void putBoolean(boolean value) {
        this.putInteger(90, value ? 1 : 0);
    }

    private void putInteger(int typeCode, int value) {
        IntItem item = this.cp.newInteger(value);
        this.putItem(typeCode, item);
    }

    private void putDouble(double value) {
        DoubleItem item = this.cp.newDouble(value);
        this.putItem(68, item);
    }

    private void putFloat(float value) {
        FloatItem item = this.cp.newFloat(value);
        this.putItem(70, item);
    }

    private void putLong(long value) {
        LongItem item = this.cp.newLong(value);
        this.putItem(74, item);
    }

    private void putType(@Nonnull JavaType type) {
        String typeDescriptor = type.getDescriptor();
        this.putString(99, typeDescriptor);
    }

    private void putString(int b, @Nonnull String value) {
        int itemIndex = this.cp.newUTF8(value);
        this.bv.put12(b, itemIndex);
    }

    private void putString(@Nonnull String value) {
        int itemIndex = this.cp.newUTF8(value);
        this.bv.putShort(itemIndex);
    }

    private void putArrayLength(@Nonnegative int length) {
        this.bv.put12(91, length);
    }

    private void putElementValuesWhenArray(@Nonnull Object value) {
        if (value instanceof byte[]) {
            this.putArrayElementValues('B', value);
        } else if (value instanceof boolean[]) {
            this.putArrayElementValues('Z', value);
        } else if (value instanceof short[]) {
            this.putArrayElementValues('S', value);
        } else if (value instanceof char[]) {
            this.putArrayElementValues('C', value);
        } else if (value instanceof int[]) {
            this.putArrayElementValues('I', value);
        } else if (value instanceof long[]) {
            this.putArrayElementValues('J', value);
        } else if (value instanceof float[]) {
            this.putArrayElementValues('F', value);
        } else if (value instanceof double[]) {
            this.putArrayElementValues('D', value);
        }
    }

    private void putArrayElementValues(char elementType, @Nonnull Object array) {
        int length = Array.getLength(array);
        this.putArrayLength(length);
        for (int i = 0; i < length; ++i) {
            if (elementType == 'J') {
                long value = Array.getLong(array, i);
                this.putLong(value);
                continue;
            }
            if (elementType == 'F') {
                float value = Array.getFloat(array, i);
                this.putFloat(value);
                continue;
            }
            if (elementType == 'D') {
                double value = Array.getDouble(array, i);
                this.putDouble(value);
                continue;
            }
            if (elementType == 'Z') {
                boolean value = Array.getBoolean(array, i);
                this.putBoolean(value);
                continue;
            }
            int value = Array.getInt(array, i);
            this.putInteger(elementType, value);
        }
    }

    @Override
    public void visitEnum(@Nullable String name, @Nonnull String desc, @Nonnull String value) {
        this.putName(name);
        this.putString(101, desc);
        this.putString(value);
    }

    @Override
    @Nonnull
    public AnnotationVisitor visitAnnotation(@Nullable String name, @Nonnull String desc) {
        this.putName(name);
        this.putString(64, desc);
        this.bv.putShort(0);
        return new AnnotationWriter(this, true);
    }

    @Override
    @Nonnull
    public AnnotationVisitor visitArray(@Nullable String name) {
        this.putName(name);
        this.putArrayLength(0);
        return new AnnotationWriter(this, false);
    }

    @Override
    public void visitEnd() {
        byte[] data = this.bv.data;
        data[this.offset] = (byte)(this.size >>> 8);
        data[this.offset + 1] = (byte)this.size;
    }

    void put(@Nonnull ByteVector out) {
        AnnotationWriter aw = this;
        AnnotationWriter last = null;
        int n = 0;
        int size = 2;
        while (aw != null) {
            ++n;
            size += aw.getByteLength();
            aw.prev = last;
            last = aw;
            aw = aw.next;
        }
        out.putInt(size);
        out.putShort(n);
        AnnotationWriter.putFromLastToFirst(out, last);
    }

    private static void putFromLastToFirst(@Nonnull ByteVector out, @Nullable AnnotationWriter aw) {
        while (aw != null) {
            out.putByteVector(aw.bv);
            aw = aw.prev;
        }
    }

    static void put(@Nonnull ByteVector out, @Nonnull AnnotationWriter[] anns) {
        AnnotationWriter.putNumberAndSizeOfAnnotations(out, anns);
        for (AnnotationWriter ann : anns) {
            AnnotationWriter last = AnnotationWriter.putNumberOfAnnotations(out, ann);
            AnnotationWriter.putFromLastToFirst(out, last);
        }
    }

    private static void putNumberAndSizeOfAnnotations(@Nonnull ByteVector out, @Nonnull AnnotationWriter[] anns) {
        int numAnns = anns.length;
        int size = 1 + 2 * numAnns;
        for (AnnotationWriter aw : anns) {
            if (aw == null) continue;
            size += aw.getSize();
        }
        out.putInt(size).putByte(numAnns);
    }

    @Nullable
    private static AnnotationWriter putNumberOfAnnotations(@Nonnull ByteVector out, @Nullable AnnotationWriter aw) {
        AnnotationWriter last = null;
        int n = 0;
        while (aw != null) {
            ++n;
            aw.prev = last;
            last = aw;
            aw = aw.next;
        }
        out.putShort(n);
        return last;
    }
}

