/*
 * Decompiled with CFR 0.152.
 */
package mockit.asm;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.asm.AnnotationWriter;

public abstract class AnnotationVisitor {
    @Nullable
    AnnotationWriter next;
    @Nullable
    AnnotationWriter prev;

    protected AnnotationVisitor() {
    }

    @Nonnegative
    protected abstract int getByteLength();

    public void visit(@Nullable String name, @Nonnull Object value) {
    }

    public void visitEnum(@Nullable String name, @Nonnull String desc, @Nonnull String value) {
    }

    @Nullable
    public AnnotationVisitor visitAnnotation(@Nullable String name, @Nonnull String desc) {
        return null;
    }

    @Nullable
    public AnnotationVisitor visitArray(@Nullable String name) {
        return null;
    }

    public void visitEnd() {
    }

    @Nonnegative
    final int getSize() {
        int size = 0;
        AnnotationVisitor annotation = this;
        while (annotation != null) {
            size += annotation.getByteLength();
            annotation = annotation.next;
        }
        return size;
    }
}

