/*
 * Decompiled with CFR 0.152.
 */
package mockit.asm;

import java.lang.reflect.Array;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.asm.AnnotationVisitor;
import mockit.asm.BytecodeReader;
import mockit.asm.PrimitiveType;
import mockit.asm.ReferenceType;

final class AnnotationReader
extends BytecodeReader {
    AnnotationReader(@Nonnull BytecodeReader br) {
        super(br);
    }

    @Nonnegative
    int readNamedAnnotationValues(@Nonnegative int codeIndex, @Nullable AnnotationVisitor av) {
        this.codeIndex = codeIndex;
        this.readAnnotationValues(true, av);
        return this.codeIndex;
    }

    private void readAnnotationValues(boolean named, @Nullable AnnotationVisitor av) {
        int valueCount = this.readUnsignedShort();
        this.readAnnotationValues(valueCount, named, av);
    }

    private void readAnnotationValues(@Nonnegative int valueCount, boolean named, @Nullable AnnotationVisitor av) {
        while (valueCount > 0) {
            String name = named ? this.readNonnullUTF8() : null;
            this.readAnnotationValue(name, av);
            --valueCount;
        }
        if (av != null) {
            av.visitEnd();
        }
    }

    private void readAnnotationValue(@Nullable String name, @Nullable AnnotationVisitor av) {
        int typeCode = this.readUnsignedByte();
        if (av == null) {
            this.readAnnotationValue(typeCode);
        } else {
            Object value = this.readAnnotationValueIfPrimitiveOrString(typeCode);
            if (value != null) {
                av.visit(name, value);
            } else {
                switch (typeCode) {
                    case 101: {
                        this.readEnumConstValue(name, av);
                        break;
                    }
                    case 99: {
                        this.readClassInfo(name, av);
                        break;
                    }
                    case 64: {
                        this.readNestedAnnotation(name, av);
                        break;
                    }
                    case 91: {
                        this.readArrayValue(name, av);
                    }
                }
            }
        }
    }

    private void readAnnotationValue(int typeCode) {
        switch (typeCode) {
            case 101: {
                this.codeIndex += 4;
                break;
            }
            case 64: {
                this.codeIndex += 2;
                this.readAnnotationValues(true, null);
                break;
            }
            case 91: {
                this.readAnnotationValues(false, null);
                break;
            }
            default: {
                this.codeIndex += 2;
            }
        }
    }

    @Nullable
    private Object readAnnotationValueIfPrimitiveOrString(int typeCode) {
        switch (typeCode) {
            case 68: 
            case 70: 
            case 73: 
            case 74: {
                return this.readConstItem();
            }
            case 66: {
                return (byte)this.readValueOfOneOrTwoBytes();
            }
            case 90: {
                return this.readValueOfOneOrTwoBytes() != 0;
            }
            case 83: {
                return (short)this.readValueOfOneOrTwoBytes();
            }
            case 67: {
                return Character.valueOf((char)this.readValueOfOneOrTwoBytes());
            }
            case 115: {
                return this.readNonnullUTF8();
            }
        }
        return null;
    }

    private int readValueOfOneOrTwoBytes() {
        int itemIndex = this.readUnsignedShort();
        int valueCodeIndex = this.items[itemIndex];
        return this.readInt(valueCodeIndex);
    }

    private void readEnumConstValue(@Nullable String name, @Nonnull AnnotationVisitor av) {
        String enumDesc = this.readNonnullUTF8();
        String enumValue = this.readNonnullUTF8();
        av.visitEnum(name, enumDesc, enumValue);
    }

    private void readClassInfo(@Nullable String name, @Nonnull AnnotationVisitor av) {
        String typeDesc = this.readNonnullUTF8();
        ReferenceType value = ReferenceType.createFromTypeDescriptor(typeDesc);
        av.visit(name, value);
    }

    private void readNestedAnnotation(@Nullable String name, @Nonnull AnnotationVisitor av) {
        String desc = this.readNonnullUTF8();
        AnnotationVisitor nestedVisitor = av.visitAnnotation(name, desc);
        this.readAnnotationValues(true, nestedVisitor);
    }

    private void readArrayValue(@Nullable String name, @Nonnull AnnotationVisitor av) {
        int valueCount = this.readUnsignedShort();
        if (valueCount == 0) {
            AnnotationVisitor arrayVisitor = av.visitArray(name);
            if (arrayVisitor != null) {
                arrayVisitor.visitEnd();
            }
            return;
        }
        int typeCode = this.readUnsignedByte();
        PrimitiveType primitiveElementType = PrimitiveType.getPrimitiveType(typeCode);
        if (primitiveElementType == null) {
            AnnotationVisitor arrayVisitor = av.visitArray(name);
            --this.codeIndex;
            this.readAnnotationValues(valueCount, false, arrayVisitor);
            return;
        }
        Class<?> elementType = primitiveElementType.getType();
        Object array = Array.newInstance(elementType, valueCount);
        this.fillArrayElements(valueCount, typeCode, array);
        av.visit(name, array);
        --this.codeIndex;
    }

    private void fillArrayElements(@Nonnegative int length, int typeCode, @Nonnull Object array) {
        for (int i = 0; i < length; ++i) {
            int itemIndex = this.readUnsignedShort();
            int index = this.items[itemIndex];
            Object value = this.getArrayElementValue(typeCode, index);
            Array.set(array, i, value);
            ++this.codeIndex;
        }
    }

    @Nonnull
    private Object getArrayElementValue(int typeCode, @Nonnegative int valueCodeIndex) {
        switch (typeCode) {
            case 90: {
                return this.readBoolean(valueCodeIndex);
            }
            case 67: {
                return Character.valueOf(this.readChar(valueCodeIndex));
            }
            case 66: {
                return this.readUnsignedByte(valueCodeIndex);
            }
            case 83: {
                return this.readShort(valueCodeIndex);
            }
            case 70: {
                return Float.valueOf(this.readFloat(valueCodeIndex));
            }
            case 68: {
                return this.readDouble(valueCodeIndex);
            }
            case 74: {
                return this.readLong(valueCodeIndex);
            }
        }
        return this.readInt(valueCodeIndex);
    }
}

