/*
 * Decompiled with CFR 0.152.
 */
package mockit.asm;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.asm.Access;
import mockit.asm.AnnotationReader;
import mockit.asm.AnnotationVisitor;
import mockit.asm.BaseWriter;
import mockit.asm.BytecodeReader;

abstract class AnnotatedReader
extends BytecodeReader {
    @Nonnull
    private final AnnotationReader annotationReader = new AnnotationReader(this);
    @Nonnegative
    private int annotationsCodeIndex;
    int access;
    @Nullable
    String signature;

    AnnotatedReader(@Nonnull byte[] code) {
        super(code);
    }

    AnnotatedReader(@Nonnull AnnotatedReader another) {
        super(another);
    }

    final void readAttributes() {
        this.signature = null;
        this.annotationsCodeIndex = 0;
        for (int attributeCount = this.readUnsignedShort(); attributeCount > 0; --attributeCount) {
            String attributeName = this.readNonnullUTF8();
            int codeOffsetToNextAttribute = this.readInt();
            if ("Signature".equals(attributeName)) {
                this.signature = this.readNonnullUTF8();
                continue;
            }
            Boolean outcome = this.readAttribute(attributeName);
            if (outcome == Boolean.TRUE) continue;
            if (outcome == null) {
                if ("RuntimeVisibleAnnotations".equals(attributeName)) {
                    this.annotationsCodeIndex = this.codeIndex;
                } else if ("Deprecated".equals(attributeName)) {
                    this.access = Access.asDeprecated(this.access);
                } else if ("Synthetic".equals(attributeName)) {
                    this.access = Access.asSynthetic(this.access);
                }
            }
            this.codeIndex += codeOffsetToNextAttribute;
        }
    }

    @Nullable
    abstract Boolean readAttribute(@Nonnull String var1);

    final void readAnnotations(@Nonnull BaseWriter visitor) {
        if (this.annotationsCodeIndex > 0) {
            int previousCodeIndex = this.codeIndex;
            this.codeIndex = this.annotationsCodeIndex;
            for (int annotationCount = this.readUnsignedShort(); annotationCount > 0; --annotationCount) {
                String annotationTypeDesc = this.readNonnullUTF8();
                AnnotationVisitor av = visitor.visitAnnotation(annotationTypeDesc);
                this.readAnnotationValues(av);
            }
            this.codeIndex = previousCodeIndex;
        }
    }

    final void readAnnotationValues(@Nullable AnnotationVisitor av) {
        this.codeIndex = this.annotationReader.readNamedAnnotationValues(this.codeIndex, av);
    }
}

