/*
 * Decompiled with CFR 0.152.
 */
package org.xnap.commons.ant.gettext;

import java.io.File;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.FileSet;
import org.xnap.commons.ant.gettext.AbstractGettextTask;
import org.xnap.commons.ant.gettext.GettextUtils;

public abstract class AbstractGettextGenerateTask
extends AbstractGettextTask {
    protected String msgcatCmd = "msgcat";
    protected String msgfmtCmd = "msgfmt";
    protected String targetBundle = "Messages";
    protected String outputFormat = "class";
    protected String javaVersion = "2";
    protected String outputDirectory;
    protected Vector poFiles = new Vector();

    public void setMsgcatCmd(String msgcatCmd) {
        this.msgcatCmd = msgcatCmd;
    }

    public void setMsgfmtCmd(String msgfmtCmd) {
        this.msgfmtCmd = msgfmtCmd;
    }

    public void setTargetBundle(String targetBundle) {
        this.targetBundle = targetBundle;
    }

    public void setOutputFormat(String outputFormat) {
        this.outputFormat = outputFormat;
    }

    public void setJavaVersion(String javaVersion) {
        this.javaVersion = javaVersion;
    }

    public void setOutputDirectory(String outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public void addFileSet(FileSet fileset) {
        this.poFiles.add(fileset);
    }

    protected String[] getPoFiles() {
        ArrayList<String> files = new ArrayList<String>();
        if (!this.poFiles.isEmpty()) {
            Iterator i = ((AbstractList)this.poFiles).iterator();
            while (i.hasNext()) {
                FileSet fileSet = (FileSet)i.next();
                DirectoryScanner scanner = fileSet.getDirectoryScanner(this.getProject());
                String[] names = scanner.getIncludedFiles();
                File parent = fileSet.getDir(this.getProject());
                String parentPath = GettextUtils.getRelativePath(parent, this.getLocation());
                for (int j = 0; j < names.length; ++j) {
                    files.add(GettextUtils.createAbsolutePath(parentPath, names[j]));
                }
            }
            return files.toArray(new String[0]);
        }
        DirectoryScanner ds = new DirectoryScanner();
        ds.setBasedir(this.poDirectory);
        ds.setIncludes(new String[]{"**/*.po"});
        ds.scan();
        return ds.getIncludedFiles();
    }

    protected void checkPreconditions() {
        if (this.outputDirectory == null) {
            throw new BuildException("outputDirectory must be specified: <... outputDirectory=\"po\"");
        }
    }

    protected CommandlineFactory getCommandlineFactory() {
        if ("class".equals(this.outputFormat)) {
            return new MsgFmtCommandlineFactory();
        }
        if ("properties".equals(this.outputFormat)) {
            return new MsgCatCommandlineFactory();
        }
        throw new BuildException("Unknown output format: " + this.outputFormat + ". Should be 'class' or 'properties'.");
    }

    protected class MsgCatCommandlineFactory
    extends CommandlineFactory {
        protected MsgCatCommandlineFactory() {
        }

        public Commandline createCommandline(File file, String locale) {
            String basepath = AbstractGettextGenerateTask.this.targetBundle.replace('.', File.separatorChar);
            if (locale != null) {
                basepath = basepath + "_" + GettextUtils.getJavaLocale(locale);
            }
            File target = new File(AbstractGettextGenerateTask.this.outputDirectory, basepath + ".properties");
            Commandline cl = new Commandline();
            cl.setExecutable(AbstractGettextGenerateTask.this.msgcatCmd);
            cl.createArgument().setValue("--no-location");
            cl.createArgument().setValue("-p");
            cl.createArgument().setFile(file);
            cl.createArgument().setValue("-o");
            cl.createArgument().setFile(target);
            return cl;
        }
    }

    protected class MsgFmtCommandlineFactory
    extends CommandlineFactory {
        protected MsgFmtCommandlineFactory() {
        }

        public Commandline createCommandline(File file, String locale) {
            Commandline cl = new Commandline();
            cl.setExecutable(AbstractGettextGenerateTask.this.msgfmtCmd);
            if ("2".equals(AbstractGettextGenerateTask.this.javaVersion)) {
                cl.createArgument().setValue("--java2");
            } else {
                cl.createArgument().setValue("--java");
            }
            cl.createArgument().setValue("-d");
            cl.createArgument().setValue(AbstractGettextGenerateTask.this.outputDirectory);
            cl.createArgument().setValue("-r");
            cl.createArgument().setValue(AbstractGettextGenerateTask.this.targetBundle);
            if (locale != null) {
                cl.createArgument().setValue("-l");
                cl.createArgument().setValue(GettextUtils.getJavaLocale(locale));
            }
            cl.createArgument().setFile(file);
            AbstractGettextGenerateTask.this.log(cl.toString(), 1);
            return cl;
        }
    }

    protected abstract class CommandlineFactory {
        protected CommandlineFactory() {
        }

        public abstract Commandline createCommandline(File var1, String var2);

        public Commandline createCommandline(File file) {
            String locale = file.getName().substring(0, file.getName().lastIndexOf(46));
            return this.createCommandline(file, locale);
        }
    }
}

