/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.osb.gui;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.layer.DataChangeListener;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.plugins.osb.OsbObserver;
import org.openstreetmap.josm.plugins.osb.OsbPlugin;
import org.openstreetmap.josm.plugins.osb.gui.OsbListCellRenderer;
import org.openstreetmap.josm.plugins.osb.gui.OsbListItem;
import org.openstreetmap.josm.plugins.osb.gui.action.AddCommentAction;
import org.openstreetmap.josm.plugins.osb.gui.action.CloseIssueAction;
import org.openstreetmap.josm.plugins.osb.gui.action.NewIssueAction;
import org.openstreetmap.josm.plugins.osb.gui.action.OsbAction;
import org.openstreetmap.josm.plugins.osb.gui.action.OsbActionObserver;
import org.openstreetmap.josm.plugins.osb.gui.action.PopupFactory;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class OsbDialog
extends ToggleDialog
implements OsbObserver,
ListSelectionListener,
Layer.LayerChangeListener,
DataChangeListener,
MouseListener,
OsbActionObserver {
    private static final long serialVersionUID = 1L;
    private DefaultListModel model;
    private JList list;
    private OsbPlugin osbPlugin;
    private boolean fireSelectionChanged = true;
    private JButton refresh;
    private JButton addComment = new JButton(new AddCommentAction());
    private JButton closeIssue = new JButton(new CloseIssueAction());
    private JToggleButton newIssue = new JToggleButton();
    private boolean buttonLabels = Main.pref.getBoolean("osb.button_labels");

    public OsbDialog(final OsbPlugin plugin) {
        super(I18n.tr((String)"Open OpenStreetBugs"), "icon_error22", I18n.tr((String)"Open the OpenStreetBugs window and activate the automatic download"), Shortcut.registerShortcut((String)"view:openstreetbugs", (String)I18n.tr((String)"Toggle: {0}", (Object[])new Object[]{I18n.tr((String)"Open OpenStreetBugs")}), (int)79, (int)2, (int)1), 150);
        this.osbPlugin = plugin;
        this.model = new DefaultListModel();
        this.list = new JList(this.model);
        this.list.setSelectionMode(0);
        this.list.addListSelectionListener(this);
        this.list.addMouseListener(this);
        this.list.setCellRenderer(new OsbListCellRenderer());
        this.add(new JScrollPane(this.list), "Center");
        GridLayout layout = this.buttonLabels ? new GridLayout(2, 2) : new GridLayout(1, 4);
        JPanel buttonPanel = new JPanel(layout);
        this.add(buttonPanel, "South");
        this.refresh = new JButton(I18n.tr((String)"Refresh"));
        this.refresh.setToolTipText(I18n.tr((String)"Refresh"));
        this.refresh.setIcon(OsbPlugin.loadIcon("view-refresh22.png"));
        this.refresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (Main.map.mapView.zoom() > 15 || Main.map.mapView.zoom() < 9) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"The visible area is either too small or too big to download data from OpenStreetBugs"), I18n.tr((String)"Warning"), 1);
                    return;
                }
                plugin.updateData();
            }
        });
        this.addComment.setEnabled(false);
        this.addComment.setToolTipText((String)this.addComment.getAction().getValue("Name"));
        this.addComment.setIcon(OsbPlugin.loadIcon("add_comment22.png"));
        this.closeIssue.setEnabled(false);
        this.closeIssue.setToolTipText((String)this.closeIssue.getAction().getValue("Name"));
        this.closeIssue.setIcon(OsbPlugin.loadIcon("icon_valid22.png"));
        NewIssueAction nia = new NewIssueAction(this.newIssue, this.osbPlugin);
        this.newIssue.setAction(nia);
        this.newIssue.setToolTipText((String)this.newIssue.getAction().getValue("Name"));
        this.newIssue.setIcon(OsbPlugin.loadIcon("icon_error_add22.png"));
        buttonPanel.add(this.refresh);
        buttonPanel.add(this.newIssue);
        buttonPanel.add(this.addComment);
        buttonPanel.add(this.closeIssue);
        if (this.buttonLabels) {
            this.refresh.setHorizontalAlignment(2);
            this.addComment.setHorizontalAlignment(2);
            this.closeIssue.setHorizontalAlignment(2);
            this.newIssue.setHorizontalAlignment(2);
        } else {
            this.refresh.setText(null);
            this.addComment.setText(null);
            this.closeIssue.setText(null);
            this.newIssue.setText(null);
        }
        DataSet.selListeners.add(new SelectionChangedListener(){

            public void selectionChanged(Collection<? extends OsmPrimitive> newSelection) {
                OsbDialog.this.fireSelectionChanged = false;
                OsbDialog.this.list.clearSelection();
                for (OsmPrimitive osmPrimitive : newSelection) {
                    for (int i = 0; i < OsbDialog.this.model.getSize(); ++i) {
                        OsbListItem item = (OsbListItem)OsbDialog.this.model.get(i);
                        if (item.getNode() != osmPrimitive) continue;
                        OsbDialog.this.list.addSelectionInterval(i, i);
                    }
                }
                OsbDialog.this.fireSelectionChanged = true;
            }
        });
        AddCommentAction.addActionObserver(this);
        CloseIssueAction.addActionObserver(this);
    }

    public synchronized void update(DataSet dataset) {
        Node lastNode = OsbAction.getSelectedNode();
        this.model = new DefaultListModel();
        ArrayList sortedList = new ArrayList(dataset.nodes);
        Collections.sort(sortedList, new BugComparator());
        for (Node node : sortedList) {
            if (node.deleted) continue;
            this.model.addElement(new OsbListItem(node));
        }
        this.list.setModel(this.model);
        this.list.setSelectedValue(new OsbListItem(lastNode), true);
    }

    public void valueChanged(ListSelectionEvent e) {
        if (this.list.getSelectedValues().length == 0) {
            this.addComment.setEnabled(false);
            this.closeIssue.setEnabled(false);
            OsbAction.setSelectedNode(null);
            return;
        }
        ArrayList<Node> selected = new ArrayList<Node>();
        for (Object listItem : this.list.getSelectedValues()) {
            Node node = ((OsbListItem)listItem).getNode();
            selected.add(node);
            if ("1".equals(node.get("state"))) {
                this.addComment.setEnabled(false);
                this.closeIssue.setEnabled(false);
            } else {
                this.addComment.setEnabled(true);
                this.closeIssue.setEnabled(true);
            }
            OsbAction.setSelectedNode(node);
            this.scrollToSelected(node);
            if (!this.fireSelectionChanged) continue;
            Main.ds.setSelected(selected);
        }
    }

    private void scrollToSelected(Node node) {
        for (int i = 0; i < this.model.getSize(); ++i) {
            Node current = ((OsbListItem)this.model.get(i)).getNode();
            if (current.id != node.id) continue;
            this.list.scrollRectToVisible(this.list.getCellBounds(i, i));
            this.list.setSelectedIndex(i);
            return;
        }
    }

    public void activeLayerChange(Layer oldLayer, Layer newLayer) {
    }

    public void layerAdded(Layer newLayer) {
        if (newLayer == this.osbPlugin.getLayer()) {
            this.update(this.osbPlugin.getDataSet());
            Main.map.mapView.moveLayer(newLayer, 0);
        }
    }

    public void layerRemoved(Layer oldLayer) {
        if (oldLayer == this.osbPlugin.getLayer()) {
            this.model.removeAllElements();
        }
    }

    public void dataChanged(OsmDataLayer l) {
        this.update(l.data);
    }

    public void zoomToNode(Node node) {
        double scale = Main.map.mapView.getScale();
        Main.map.mapView.zoomTo(node.eastNorth, scale);
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getButton() == 1 && e.getClickCount() == 2) {
            OsbListItem item = (OsbListItem)this.list.getSelectedValue();
            this.zoomToNode(item.getNode());
        }
    }

    public void mousePressed(MouseEvent e) {
        this.mayTriggerPopup(e);
    }

    public void mouseReleased(MouseEvent e) {
        this.mayTriggerPopup(e);
    }

    private void mayTriggerPopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            int selectedRow = this.list.locationToIndex(e.getPoint());
            this.list.setSelectedIndex(selectedRow);
            Node n = ((OsbListItem)this.list.getSelectedValue()).getNode();
            OsbAction.setSelectedNode(n);
            PopupFactory.createPopup(n).show(e.getComponent(), e.getX(), e.getY());
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void actionPerformed(OsbAction action) {
        if (action instanceof AddCommentAction || action instanceof CloseIssueAction) {
            this.update(this.osbPlugin.getDataSet());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BugComparator
    implements Comparator<Node> {
        private BugComparator() {
        }

        @Override
        public int compare(Node o1, Node o2) {
            String state2;
            String state1 = o1.get("state");
            if (state1.equals(state2 = o2.get("state"))) {
                return o1.get("note").compareTo(o2.get("note"));
            }
            return state1.compareTo(state2);
        }
    }
}

