/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.agpifoj;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileFilter;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.gui.IconToggleButton;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.agpifoj.AgpifojDialog;
import org.openstreetmap.josm.plugins.agpifoj.AgpifojLayer;
import org.openstreetmap.josm.tools.I18n;

public class AgpifojPlugin
extends Plugin {
    static final JpegFileFilter JPEG_FILE_FILTER = new JpegFileFilter();

    public AgpifojPlugin() {
        MainMenu.add((JMenu)Main.main.menu.fileMenu, (JosmAction)new Action());
    }

    public void mapFrameInitialized(MapFrame oldFrame, MapFrame newFrame) {
        if (newFrame != null) {
            AgpifojDialog dialog = AgpifojDialog.getInstance();
            IconToggleButton b = newFrame.addToggleDialog((ToggleDialog)dialog);
            boolean found = false;
            for (Layer layer : newFrame.mapView.getAllLayers()) {
                if (!(layer instanceof AgpifojLayer)) continue;
                found = true;
                break;
            }
            b.setSelected(found);
        } else {
            AgpifojDialog.getInstance().displayImage(null, null);
        }
    }

    private class Action
    extends JosmAction {
        public Action() {
            super(I18n.tr((String)"Open images with AgPifoJ..."), "agpifoj-open", I18n.tr((String)"Load set of images as a new layer."), null, false);
        }

        public void actionPerformed(ActionEvent e) {
            JFileChooser fc = new JFileChooser(Main.pref.get("tagimages.lastdirectory"));
            fc.setFileSelectionMode(2);
            fc.setMultiSelectionEnabled(true);
            fc.setAcceptAllFileFilterUsed(false);
            fc.setFileFilter(JPEG_FILE_FILTER);
            int result = fc.showOpenDialog(Main.parent);
            File[] sel = fc.getSelectedFiles();
            if (sel == null || sel.length == 0 || result != 0) {
                return;
            }
            Main.pref.put("tagimages.lastdirectory", fc.getCurrentDirectory().getPath());
            AgpifojLayer.create(sel);
        }
    }

    static class JpegFileFilter
    extends javax.swing.filechooser.FileFilter
    implements FileFilter {
        JpegFileFilter() {
        }

        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String name = f.getName().toLowerCase();
            return name.endsWith(".jpg") || name.endsWith(".jpeg");
        }

        public String getDescription() {
            return I18n.tr((String)"JPEG images (*.jpg)");
        }
    }
}

