/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.DiskAccessAction;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerLayer;
import org.openstreetmap.josm.io.TcxReader;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class TcxPlugin
extends Plugin {
    public TcxPlugin() {
        MainMenu.add((JMenu)Main.main.menu.fileMenu, (JosmAction)new OpenAction());
    }

    public class OpenAction
    extends DiskAccessAction {
        public OpenAction() {
            super(I18n.tr((String)"Import TCX File..."), "tcxicon", I18n.tr((String)"Import TCX file as GPS track"), Shortcut.registerShortcut((String)"menu:importtcx", (String)I18n.tr((String)"Menu: {0}", (Object[])new Object[]{I18n.tr((String)"Import TCX File...")}), (int)84, (int)2));
        }

        private void addTcxFileFilter() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.addTcxFileFilter();
            JFileChooser jFileChooser = OpenAction.createAndOpenFileChooser((boolean)true, (boolean)true, null);
            if (jFileChooser == null) {
                return;
            }
            File[] fileArray = jFileChooser.getSelectedFiles();
            try {
                for (int i = fileArray.length; i > 0; --i) {
                    this.openFileAsTcx(fileArray[i - 1]);
                }
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }

        private void openFileAsTcx(File file) throws IOException {
            String string = file.getName();
            if (string.toLowerCase().endsWith(".tcx")) {
                TcxReader tcxReader = new TcxReader(file);
                GpxData gpxData = tcxReader.getGpxData();
                gpxData.storageFile = file;
                GpxLayer gpxLayer = new GpxLayer(gpxData, string);
                Main.main.addLayer((Layer)gpxLayer);
                if (Main.pref.getBoolean("marker.makeautomarkers", true)) {
                    MarkerLayer markerLayer = new MarkerLayer(gpxData, I18n.tr((String)"Markers from {0}", (Object[])new Object[]{string}), file, gpxLayer);
                    if (markerLayer.data.size() > 0) {
                        Main.main.addLayer((Layer)markerLayer);
                    }
                }
            } else {
                throw new IllegalStateException();
            }
        }
    }
}

