/*
 * Decompiled with CFR 0.152.
 */
package cadastre_fr;

import cadastre_fr.CacheControl;
import cadastre_fr.CadastreGrabber;
import cadastre_fr.CadastrePlugin;
import cadastre_fr.EastNorthBound;
import cadastre_fr.GeorefImage;
import cadastre_fr.Scale;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.filechooser.FileFilter;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.data.projection.Lambert;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WMSLayer
extends Layer {
    Component[] component = null;
    public int lambertZone = -1;
    protected static final Icon icon = new ImageIcon(Toolkit.getDefaultToolkit().createImage(CadastrePlugin.class.getResource("/images/cadastre_small.png")));
    protected ArrayList<GeorefImage> images = new ArrayList();
    protected final int serializeFormatVersion = 2;
    private ArrayList<EastNorthBound> dividedBbox = new ArrayList();
    private CacheControl cacheControl = null;
    private String location = "";
    private String codeCommune = "";
    private EastNorthBound communeBBox = new EastNorthBound(new EastNorth(0.0, 0.0), new EastNorth(0.0, 0.0));
    private boolean isRaster = false;
    private EastNorth rasterMin;
    private EastNorth rasterCenter;
    private double rasterRatio;
    double cRasterMaxSizeX = 12286.0;
    double cRasterMaxSizeY = 8730.0;

    public WMSLayer() {
        this(I18n.tr((String)"Blank Layer"), "", -1);
    }

    public WMSLayer(String string, String string2, int n) {
        super(WMSLayer.buildName(string, string2));
        this.location = string;
        this.codeCommune = string2;
        this.lambertZone = Lambert.layoutZone;
        CadastrePlugin.pluginUsed = true;
    }

    private static String buildName(String string, String string2) {
        String string3 = new String(string.toUpperCase());
        if (string2 != null && !string2.equals("")) {
            string3 = string3 + "(" + string2 + ")";
        }
        return string3;
    }

    private String rebuildName() {
        return WMSLayer.buildName(this.location.toUpperCase(), this.codeCommune);
    }

    public void grab(CadastreGrabber cadastreGrabber, Bounds bounds) throws IOException {
        this.divideBbox(bounds, Integer.parseInt(Main.pref.get("cadastrewms.scale", Scale.X1.toString())));
        for (EastNorthBound eastNorthBound : this.dividedBbox) {
            GeorefImage georefImage;
            try {
                georefImage = cadastreGrabber.grab(this, eastNorthBound.min, eastNorthBound.max);
            }
            catch (IOException iOException) {
                System.out.println("Download action cancelled by user or server did not respond");
                break;
            }
            if (cadastreGrabber.getWmsInterface().downloadCancelled) {
                System.out.println("Download action cancelled by user");
                break;
            }
            if (CadastrePlugin.backgroundTransparent) {
                for (GeorefImage georefImage2 : this.images) {
                    if (georefImage2.overlap(georefImage)) {
                        georefImage2.withdraw(georefImage);
                        continue;
                    }
                    georefImage.withdraw(georefImage2);
                }
            }
            this.images.add(georefImage);
            this.saveToCache(georefImage);
            Main.map.mapView.repaint();
        }
    }

    private void divideBbox(Bounds bounds, int n) {
        EastNorth eastNorth = Main.proj.latlon2eastNorth(bounds.min);
        EastNorth eastNorth2 = Main.proj.latlon2eastNorth(bounds.max);
        double d = eastNorth.east();
        double d2 = eastNorth.north();
        double d3 = (eastNorth2.east() - d) / (double)n;
        double d4 = (eastNorth2.north() - d2) / (double)n;
        this.dividedBbox.clear();
        if (n < 4) {
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n; ++j) {
                    this.dividedBbox.add(new EastNorthBound(new EastNorth(d + (double)i * d3, d2 + (double)j * d4), new EastNorth(d + (double)(i + 1) * d3, d2 + (double)(j + 1) * d4)));
                }
            }
        } else {
            int n2 = Integer.parseInt(Main.pref.get("cadastrewms.squareSize", "100"));
            d -= d % (double)n2;
            d2 -= d2 % (double)n2;
            int n3 = (int)d;
            while ((double)n3 < eastNorth2.east()) {
                int n4 = (int)d2;
                while ((double)n4 < eastNorth2.north()) {
                    this.dividedBbox.add(new EastNorthBound(new EastNorth((double)n3, (double)n4), new EastNorth((double)(n3 + n2), (double)(n4 + n2))));
                    n4 += n2;
                }
                n3 += n2;
            }
        }
    }

    public Icon getIcon() {
        return icon;
    }

    public String getToolTipText() {
        String string = I18n.tr((String)"WMS layer ({0}), {1} tile(s) loaded", (Object[])new Object[]{this.name, this.images.size()});
        if (this.isRaster) {
            string = string + "\n" + I18n.tr((String)"Is not vectorized.");
            string = string + "\n" + I18n.tr((String)"Raster center: {0}", (Object[])new Object[]{this.rasterCenter});
        } else {
            string = string + "\n" + I18n.tr((String)"Is vectorized.");
        }
        string = string + "\n" + I18n.tr((String)"Commune bbox: {0}", (Object[])new Object[]{this.communeBBox});
        return string;
    }

    public boolean isMergable(Layer layer) {
        return false;
    }

    public void mergeFrom(Layer layer) {
    }

    public void paint(Graphics graphics, MapView mapView) {
        for (GeorefImage georefImage : this.images) {
            georefImage.paint((Graphics2D)graphics, (NavigatableComponent)mapView, CadastrePlugin.backgroundTransparent, CadastrePlugin.transparency, CadastrePlugin.drawBoundaries);
        }
    }

    public void visitBoundingBox(BoundingXYVisitor boundingXYVisitor) {
        for (GeorefImage georefImage : this.images) {
            boundingXYVisitor.visit(georefImage.min);
            boundingXYVisitor.visit(georefImage.max);
        }
    }

    public Object getInfoComponent() {
        return this.getToolTipText();
    }

    public Component[] getMenuEntries() {
        this.component = new Component[]{new JMenuItem((Action)new LayerListDialog.ShowHideLayerAction((Layer)this)), new JMenuItem((Action)new LayerListDialog.DeleteLayerAction((Layer)this)), new JMenuItem(new LoadWmsAction()), new JMenuItem(new SaveWmsAction()), new JSeparator(), new JMenuItem((Action)new LayerListPopup.InfoAction((Layer)this))};
        return this.component;
    }

    public GeorefImage findImage(EastNorth eastNorth) {
        for (int i = this.images.size() - 1; i >= 0; --i) {
            if (!this.images.get(i).contains(eastNorth)) continue;
            return this.images.get(i);
        }
        return null;
    }

    public boolean isOverlapping(Bounds bounds) {
        GeorefImage georefImage = new GeorefImage(new BufferedImage(1, 1, 1), Main.proj.latlon2eastNorth(bounds.min), Main.proj.latlon2eastNorth(bounds.max));
        for (GeorefImage georefImage2 : this.images) {
            if (!georefImage2.overlap(georefImage)) continue;
            return true;
        }
        return false;
    }

    public void saveToCache(GeorefImage georefImage) {
        if (CacheControl.cacheEnabled) {
            this.getCacheControl().saveCache(georefImage);
        }
    }

    public void saveNewCache() {
        if (CacheControl.cacheEnabled) {
            this.getCacheControl().deleteCacheFile();
            for (GeorefImage georefImage : this.images) {
                this.getCacheControl().saveCache(georefImage);
            }
        }
    }

    public CacheControl getCacheControl() {
        if (this.cacheControl == null) {
            this.cacheControl = new CacheControl(this);
        }
        return this.cacheControl;
    }

    protected static JFileChooser createAndOpenFileChooser(boolean bl, boolean bl2) {
        File file;
        int n;
        String string = Main.pref.get("lastDirectory");
        if (string.equals("")) {
            string = ".";
        }
        JFileChooser jFileChooser = new JFileChooser(new File(string));
        jFileChooser.setMultiSelectionEnabled(bl2);
        for (n = 0; n < ExtensionFileFilter.filters.length; ++n) {
            jFileChooser.addChoosableFileFilter((FileFilter)ExtensionFileFilter.filters[n]);
        }
        jFileChooser.setAcceptAllFileFilterUsed(true);
        int n2 = n = bl ? jFileChooser.showOpenDialog(Main.parent) : jFileChooser.showSaveDialog(Main.parent);
        if (n != 0) {
            return null;
        }
        if (!jFileChooser.getCurrentDirectory().getAbsolutePath().equals(string)) {
            Main.pref.put("lastDirectory", jFileChooser.getCurrentDirectory().getAbsolutePath());
        }
        if (!bl && ((file = jFileChooser.getSelectedFile()) == null || file.exists() && 0 != JOptionPane.showConfirmDialog(Main.parent, I18n.tr((String)"File exists. Overwrite?"), I18n.tr((String)"Overwrite"), 0))) {
            return null;
        }
        return jFileChooser;
    }

    public static File openFileDialog(boolean bl) {
        JFileChooser jFileChooser = WMSLayer.createAndOpenFileChooser(bl, false);
        if (jFileChooser == null) {
            return null;
        }
        File file = jFileChooser.getSelectedFile();
        String string = file.getPath();
        if (string.indexOf(46) == -1) {
            FileFilter fileFilter = jFileChooser.getFileFilter();
            string = fileFilter instanceof ExtensionFileFilter ? "." + ((ExtensionFileFilter)fileFilter).defaultExtension : string + ".osm";
            file = new File(string);
        }
        return file;
    }

    public String eastNorth2raster(EastNorth eastNorth, EastNorth eastNorth2) {
        double d = (eastNorth.east() - this.rasterMin.east()) / this.rasterRatio;
        double d2 = (eastNorth.north() - this.rasterMin.north()) / this.rasterRatio;
        double d3 = (eastNorth2.east() - this.rasterMin.east()) / this.rasterRatio;
        double d4 = (eastNorth2.north() - this.rasterMin.north()) / this.rasterRatio;
        return d + "," + d2 + "," + d3 + "," + d4;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String string) {
        this.location = string;
        this.name = this.rebuildName();
        this.repaintLayerListDialog();
    }

    public String getCodeCommune() {
        return this.codeCommune;
    }

    public void setCodeCommune(String string) {
        this.codeCommune = string;
        this.name = this.rebuildName();
        this.repaintLayerListDialog();
    }

    public boolean isRaster() {
        return this.isRaster;
    }

    public void setRaster(boolean bl) {
        this.isRaster = bl;
    }

    public void setRasterBounds(Bounds bounds) {
        this.rasterMin = new EastNorth(Main.proj.latlon2eastNorth(bounds.min).east(), Main.proj.latlon2eastNorth(bounds.min).north());
        EastNorth eastNorth = new EastNorth(Main.proj.latlon2eastNorth(bounds.max).east(), Main.proj.latlon2eastNorth(bounds.max).north());
        double d = (eastNorth.east() - this.rasterMin.east()) / this.cRasterMaxSizeX * this.cRasterMaxSizeY / 2.0;
        double d2 = this.rasterMin.north() + (eastNorth.north() - this.rasterMin.north()) / 2.0;
        this.rasterMin.setLocation(this.rasterMin.east(), d2 - d);
        eastNorth.setLocation(eastNorth.east(), d2 + d);
        this.rasterCenter = new EastNorth(this.rasterMin.east() + (eastNorth.east() - this.rasterMin.east()) / 2.0, this.rasterMin.north() + (eastNorth.north() - this.rasterMin.north()) / 2.0);
        this.rasterRatio = (eastNorth.east() - this.rasterMin.east()) / this.cRasterMaxSizeX;
    }

    public EastNorth getRasterMin() {
        return this.rasterMin;
    }

    public void setRasterMin(EastNorth eastNorth) {
        this.rasterMin = eastNorth;
    }

    public void displace(double d, double d2) {
        this.rasterMin = new EastNorth(this.rasterMin.east() + d, this.rasterMin.north() + d2);
        this.rasterCenter = new EastNorth(this.rasterCenter.east() + d, this.rasterCenter.north() + d2);
        for (GeorefImage georefImage : this.images) {
            georefImage.displace(d, d2);
        }
    }

    public void resize(double d) {
        this.rasterMin = this.rasterMin.interpolate(this.rasterCenter, d);
        for (GeorefImage georefImage : this.images) {
            georefImage.resize(this.rasterCenter, d);
        }
    }

    public void rotate(double d) {
        this.rasterMin = this.rasterMin.rotate(this.rasterCenter, d);
        for (GeorefImage georefImage : this.images) {
            georefImage.rotate(this.rasterCenter, d);
        }
    }

    private void repaintLayerListDialog() {
        if (Main.map != null) {
            for (Component component : Main.map.toggleDialogs.getComponents()) {
                if (!(component instanceof LayerListDialog)) continue;
                component.repaint();
            }
        }
    }

    public void write(ObjectOutputStream objectOutputStream, ArrayList<GeorefImage> arrayList) throws IOException {
        objectOutputStream.writeInt(this.serializeFormatVersion);
        objectOutputStream.writeObject(this.location);
        objectOutputStream.writeObject(this.codeCommune);
        objectOutputStream.writeInt(this.lambertZone);
        objectOutputStream.writeBoolean(this.isRaster);
        if (this.isRaster) {
            objectOutputStream.writeObject(this.rasterMin);
            objectOutputStream.writeObject(this.rasterCenter);
            objectOutputStream.writeDouble(this.rasterRatio);
        } else {
            objectOutputStream.writeObject(this.communeBBox);
        }
        for (GeorefImage georefImage : arrayList) {
            objectOutputStream.writeObject(georefImage);
        }
    }

    public boolean read(ObjectInputStream objectInputStream, int n) throws IOException, ClassNotFoundException {
        int n2 = objectInputStream.readInt();
        if (n2 != this.serializeFormatVersion) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Unsupported cache file version; found {0}, expected {1}\nCreate a new one.", (Object[])new Object[]{n2, this.serializeFormatVersion}), I18n.tr((String)"Cache Format Error"), 0);
            return false;
        }
        this.setLocation((String)objectInputStream.readObject());
        this.setCodeCommune((String)objectInputStream.readObject());
        this.lambertZone = objectInputStream.readInt();
        this.isRaster = objectInputStream.readBoolean();
        if (this.isRaster) {
            this.rasterMin = (EastNorth)objectInputStream.readObject();
            this.rasterCenter = (EastNorth)objectInputStream.readObject();
            this.rasterRatio = objectInputStream.readDouble();
        } else {
            this.communeBBox = (EastNorthBound)objectInputStream.readObject();
        }
        if (this.lambertZone != n) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Lambert zone {0} in cache  incompatible with current Lambert zone {1}", (Object[])new Object[]{this.lambertZone + 1, n}), I18n.tr((String)"Cache Lambert Zone Error"), 0);
            return false;
        }
        boolean bl = false;
        try {
            while (!bl) {
                GeorefImage georefImage = (GeorefImage)objectInputStream.readObject();
                for (GeorefImage georefImage2 : this.images) {
                    if (!CadastrePlugin.backgroundTransparent) continue;
                    if (georefImage2.overlap(georefImage)) {
                        georefImage2.withdraw(georefImage);
                        continue;
                    }
                    georefImage.withdraw(georefImage2);
                }
                this.images.add(georefImage);
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return true;
    }

    public double getRasterRatio() {
        return this.rasterRatio;
    }

    public void setRasterRatio(double d) {
        this.rasterRatio = d;
    }

    public EastNorth getRasterCenter() {
        return this.rasterCenter;
    }

    public void setRasterCenter(EastNorth eastNorth) {
        this.rasterCenter = eastNorth;
    }

    public EastNorthBound getCommuneBBox() {
        return this.communeBBox;
    }

    public void setCommuneBBox(EastNorthBound eastNorthBound) {
        this.communeBBox = eastNorthBound;
    }

    public class LoadWmsAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public LoadWmsAction() {
            super(I18n.tr((String)"Load WMS layer from file"), ImageProvider.get((String)"load"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            File file = WMSLayer.openFileDialog(true);
            if (file == null) {
                return;
            }
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
                int n = objectInputStream.readInt();
                if (n != 2) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Unsupported WMS file version; found {0}, expected {1}", (Object[])new Object[]{n, 2}), I18n.tr((String)"File Format Error"), 0);
                    return;
                }
                WMSLayer.this.lambertZone = objectInputStream.readInt();
                int n2 = objectInputStream.readInt();
                for (int i = 0; i < n2; ++i) {
                    GeorefImage georefImage = (GeorefImage)objectInputStream.readObject();
                    WMSLayer.this.images.add(georefImage);
                }
                objectInputStream.close();
                fileInputStream.close();
            }
            catch (Exception exception) {
                exception.printStackTrace(System.out);
                JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Error loading file"), I18n.tr((String)"Error"), 0);
                return;
            }
        }
    }

    public class SaveWmsAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public SaveWmsAction() {
            super(I18n.tr((String)"Save WMS layer to file"), ImageProvider.get((String)"save"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            File file = WMSLayer.openFileDialog(false);
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
                objectOutputStream.writeInt(2);
                objectOutputStream.writeInt(WMSLayer.this.lambertZone);
                objectOutputStream.writeInt(WMSLayer.this.images.size());
                for (GeorefImage georefImage : WMSLayer.this.images) {
                    objectOutputStream.writeObject(georefImage);
                }
                objectOutputStream.close();
                fileOutputStream.close();
            }
            catch (Exception exception) {
                exception.printStackTrace(System.out);
            }
        }
    }
}

