/*
 * Decompiled with CFR 0.152.
 */
package cadastre_fr;

import cadastre_fr.CacheControl;
import cadastre_fr.GeorefImage;
import cadastre_fr.WMSLayer;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class WMSAdjustAction
extends MapMode
implements MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = 1L;
    GeorefImage selectedImage;
    private ArrayList<WMSLayer> modifiedLayers = new ArrayList();
    WMSLayer selectedLayer;
    private boolean rasterMoved;
    private EastNorth prevEastNorth;
    private Mode mode = null;

    public WMSAdjustAction(MapFrame mapFrame) {
        super(I18n.tr((String)"Adjust WMS"), "adjustxywms", I18n.tr((String)"Adjust the position of the WMS layer"), mapFrame, ImageProvider.getCursor((String)"normal", (String)"move"));
    }

    public void enterMode() {
        super.enterMode();
        Main.map.mapView.addMouseListener((MouseListener)this);
        Main.map.mapView.addMouseMotionListener((MouseMotionListener)this);
        this.rasterMoved = false;
    }

    public void exitMode() {
        int n;
        super.exitMode();
        Main.map.mapView.removeMouseListener((MouseListener)this);
        Main.map.mapView.removeMouseMotionListener((MouseMotionListener)this);
        if (this.rasterMoved && CacheControl.cacheEnabled && (n = JOptionPane.showConfirmDialog(null, "Save the changes in cache ?", "Update cache", 0)) == 0) {
            this.saveModifiedLayers();
        }
        this.modifiedLayers.clear();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        boolean bl;
        if (mouseEvent.getButton() != 1) {
            return;
        }
        boolean bl2 = (mouseEvent.getModifiers() & 2) != 0;
        boolean bl3 = bl = (mouseEvent.getModifiers() & 1) != 0;
        this.mode = bl ? Mode.moveZ : (bl2 ? Mode.rotate : Mode.moveXY);
        for (Layer layer : Main.map.mapView.getAllLayers()) {
            if (!layer.visible || !(layer instanceof WMSLayer)) continue;
            this.prevEastNorth = Main.map.mapView.getEastNorth(mouseEvent.getX(), mouseEvent.getY());
            this.selectedLayer = (WMSLayer)layer;
            this.selectedImage = this.selectedLayer.findImage(this.prevEastNorth);
            if (this.selectedImage == null) continue;
            Main.map.mapView.setCursor(Cursor.getPredefinedCursor(13));
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.selectedImage != null && (this.mode == Mode.moveXY || this.mode == Mode.moveZ || this.mode == Mode.rotate)) {
            EastNorth eastNorth = Main.map.mapView.getEastNorth(mouseEvent.getX(), mouseEvent.getY());
            if (this.mode == Mode.moveXY) {
                this.displace(this.prevEastNorth, eastNorth);
            } else if (this.mode == Mode.moveZ) {
                this.resize(eastNorth);
            } else if (this.mode == Mode.rotate) {
                this.rotate(this.prevEastNorth, eastNorth);
            }
            this.rasterMoved = true;
            if (!this.modifiedLayers.contains((Object)this.selectedLayer)) {
                this.modifiedLayers.add(this.selectedLayer);
            }
            Main.map.mapView.repaint();
            this.prevEastNorth = eastNorth;
        }
    }

    private void displace(EastNorth eastNorth, EastNorth eastNorth2) {
        this.selectedLayer.displace(eastNorth2.east() - eastNorth.east(), eastNorth2.north() - eastNorth.north());
    }

    private void resize(EastNorth eastNorth) {
        double d = this.prevEastNorth.distance(this.selectedLayer.getRasterCenter().east(), this.selectedLayer.getRasterCenter().north());
        double d2 = eastNorth.distance(this.selectedLayer.getRasterCenter().east(), this.selectedLayer.getRasterCenter().north());
        this.selectedLayer.resize(1.0 - d2 / d);
    }

    private void rotate(EastNorth eastNorth, EastNorth eastNorth2) {
        EastNorth eastNorth3 = this.selectedLayer.getRasterCenter();
        double d = Math.atan2(eastNorth.east() - eastNorth3.east(), eastNorth.north() - eastNorth3.north());
        double d2 = Math.atan2(eastNorth2.east() - eastNorth3.east(), eastNorth2.north() - eastNorth3.north());
        double d3 = d2 - d;
        this.selectedLayer.rotate(d3);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        Main.map.mapView.setCursor(Cursor.getDefaultCursor());
        this.selectedImage = null;
        this.prevEastNorth = null;
        this.selectedLayer = null;
        this.mode = null;
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    private void saveModifiedLayers() {
        for (WMSLayer wMSLayer : this.modifiedLayers) {
            wMSLayer.saveNewCache();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Mode {
        moveXY,
        moveZ,
        rotate;

    }
}

