/*
 * Decompiled with CFR 0.152.
 */
package cadastre_fr;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.CollectBackReferencesVisitor;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimplifyWay {
    public static double EARTH_RAD = 6378137.0;

    public void simplifyWay(Way way, DataSet dataSet, double d) {
        Object object;
        Way way2 = new Way(way);
        int n = way2.nodes.size() - 1;
        for (int i = way2.nodes.size() - 1; i >= 0; --i) {
            object = new CollectBackReferencesVisitor(dataSet, false);
            object.visit((Node)way2.nodes.get(i));
            boolean bl = false;
            if (((CollectBackReferencesVisitor)object).data.size() == 1) {
                bl = Collections.frequency(way.nodes, way2.nodes.get(i)) > 1;
            } else {
                ((CollectBackReferencesVisitor)object).data.remove(way);
                boolean bl2 = bl = !((CollectBackReferencesVisitor)object).data.isEmpty();
            }
            if (!bl) {
                bl = ((Node)way2.nodes.get((int)i)).tagged;
            }
            if (!bl) continue;
            this.simplifyWayRange(way2, i, n, d);
            n = i;
        }
        this.simplifyWayRange(way2, 0, n, d);
        HashSet hashSet = new HashSet();
        hashSet.addAll(way.nodes);
        hashSet.removeAll(way2.nodes);
        if (way2.nodes.size() != way.nodes.size()) {
            object = new LinkedList();
            object.add(new ChangeCommand((OsmPrimitive)way, (OsmPrimitive)way2));
            object.add(new DeleteCommand(hashSet));
            Main.main.undoRedo.add((Command)new SequenceCommand(I18n.trn((String)"Simplify Way (remove {0} node)", (String)"Simplify Way (remove {0} nodes)", (long)hashSet.size(), (Object[])new Object[]{hashSet.size()}), (Collection)object));
            Main.map.repaint();
        }
    }

    public void simplifyWayRange(Way way, int n, int n2, double d) {
        if (n2 - n >= 2) {
            ArrayList<Node> arrayList = new ArrayList<Node>();
            this.simplifyWayRange(way, n, n2, arrayList, d);
            for (int i = n2 - 1; i > n; --i) {
                way.nodes.remove(i);
            }
            way.nodes.addAll(n + 1, arrayList);
        }
    }

    public void simplifyWayRange(Way way, int n, int n2, ArrayList<Node> arrayList, double d) {
        Node node = (Node)way.nodes.get(n);
        Node node2 = (Node)way.nodes.get(n2);
        int n3 = -1;
        double d2 = 0.0;
        for (int i = n + 1; i < n2; ++i) {
            Node node3 = (Node)way.nodes.get(i);
            double d3 = Math.abs(EARTH_RAD * SimplifyWay.xtd(node.coor.lat() * Math.PI / 180.0, node.coor.lon() * Math.PI / 180.0, node2.coor.lat() * Math.PI / 180.0, node2.coor.lon() * Math.PI / 180.0, node3.coor.lat() * Math.PI / 180.0, node3.coor.lon() * Math.PI / 180.0));
            if (!(d3 > d2)) continue;
            d2 = d3;
            n3 = i;
        }
        if (n3 != -1 && d2 >= d) {
            this.simplifyWayRange(way, n, n3, arrayList, d);
            arrayList.add((Node)way.nodes.get(n3));
            this.simplifyWayRange(way, n3, n2, arrayList, d);
        }
    }

    public static double dist(double d, double d2, double d3, double d4) {
        return 2.0 * Math.asin(Math.sqrt(Math.pow(Math.sin((d - d3) / 2.0), 2.0) + Math.cos(d) * Math.cos(d3) * Math.pow(Math.sin((d2 - d4) / 2.0), 2.0)));
    }

    public static double course(double d, double d2, double d3, double d4) {
        return Math.atan2(Math.sin(d2 - d4) * Math.cos(d3), Math.cos(d) * Math.sin(d3) - Math.sin(d) * Math.cos(d3) * Math.cos(d2 - d4)) % (Math.PI * 2);
    }

    public static double xtd(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = SimplifyWay.dist(d, d2, d5, d6);
        double d8 = SimplifyWay.course(d, d2, d5, d6);
        double d9 = SimplifyWay.course(d, d2, d3, d4);
        return Math.asin(Math.sin(d7) * Math.sin(d8 - d9));
    }
}

