/*
 * Decompiled with CFR 0.152.
 */
package cadastre_fr;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.tools.ColorHelper;

public class ImageModifier {
    private static final long serialVersionUID = 1L;
    public static final int cadastreBackground = -1;
    public static final int cadastreBackgroundTransp = 1;
    public BufferedImage bufferedImage;
    private boolean withBackground = false;
    private int backgroundPixel = 0;
    private int backgroundSampleX;
    private int backgroundSampleY;

    public ImageModifier(BufferedImage bufferedImage) {
        this.bufferedImage = bufferedImage;
        if (Main.pref.getBoolean("cadastrewms.backgroundTransparent")) {
            this.makeTransparent();
        } else if (Main.pref.getBoolean("cadastrewms.alterColors")) {
            this.replaceBackground();
        }
        if (Main.pref.getBoolean("cadastrewms.invertGrey")) {
            this.invertGrey();
        }
    }

    private void replaceBackground() {
        int n = this.bufferedImage.getWidth();
        int n2 = this.bufferedImage.getHeight();
        int n3 = ColorHelper.html2color((String)Main.pref.get("color.background", "#000000")).getRGB();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                int n4 = this.bufferedImage.getRGB(i, j);
                if (n4 != -1) continue;
                this.bufferedImage.setRGB(i, j, n3);
                if (!this.withBackground) {
                    this.withBackground = true;
                }
                this.backgroundSampleX = i;
                this.backgroundSampleY = j;
            }
        }
    }

    private void invertGrey() {
        int n = this.bufferedImage.getWidth();
        int n2 = this.bufferedImage.getHeight();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                int n3 = this.bufferedImage.getRGB(i, j);
                if (n3 == -1) continue;
                this.bufferedImage.setRGB(i, j, this.reverseIfGrey(n3));
            }
        }
    }

    private int reverseIfGrey(int n) {
        Color color = new Color(n);
        int n2 = color.getRed();
        int n3 = color.getGreen();
        int n4 = color.getBlue();
        if (n4 == n2 && n4 == n3) {
            n = 0 + ((byte)(255 - n2) << 16) + ((byte)(255 - n2) << 8) + (byte)(255 - n2);
        }
        return n;
    }

    private void makeTransparent() {
        ColorModel colorModel = this.bufferedImage.getColorModel();
        if (this.bufferedImage.getColorModel() instanceof IndexColorModel) {
            IndexColorModel indexColorModel = (IndexColorModel)colorModel;
            WritableRaster writableRaster = this.bufferedImage.getRaster();
            this.backgroundPixel = this.withBackground ? writableRaster.getSample(this.backgroundSampleX, this.backgroundSampleY, 0) : 1;
            int n = indexColorModel.getMapSize();
            byte[] byArray = new byte[n];
            byte[] byArray2 = new byte[n];
            byte[] byArray3 = new byte[n];
            indexColorModel.getReds(byArray);
            indexColorModel.getGreens(byArray2);
            indexColorModel.getBlues(byArray3);
            IndexColorModel indexColorModel2 = new IndexColorModel(colorModel.getPixelSize(), n, byArray, byArray2, byArray3, this.backgroundPixel);
            this.bufferedImage = new BufferedImage(indexColorModel2, writableRaster, this.bufferedImage.isAlphaPremultiplied(), null);
        } else {
            int n = this.bufferedImage.getWidth();
            int n2 = this.bufferedImage.getHeight();
            BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n; ++j) {
                    Color color = new Color(this.bufferedImage.getRGB(j, i));
                    int n3 = color.getRed();
                    int n4 = color.getGreen();
                    int n5 = color.getBlue();
                    Color color2 = n3 == 0 && n4 == 0 && n5 == 0 ? new Color(n3, n4, n5, 0) : new Color(n3, n4, n5, 255);
                    bufferedImage.setRGB(j, i, color2.getRGB());
                }
            }
            this.bufferedImage = bufferedImage;
        }
    }
}

