/*
 * Decompiled with CFR 0.152.
 */
package cadastre_fr;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.imageio.ImageIO;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.gui.NavigatableComponent;

public class GeorefImage
implements Serializable {
    private static final long serialVersionUID = 1L;
    public EastNorth min;
    public EastNorth max;
    public EastNorth org_min;
    public EastNorth org_max;
    public BufferedImage image;
    private double angle = 0.0;
    private BufferedImage rotated_image;
    double pixelPerEast;
    double pixelPerNorth;

    public GeorefImage(BufferedImage bufferedImage, EastNorth eastNorth, EastNorth eastNorth2) {
        this.image = bufferedImage;
        this.min = eastNorth;
        this.max = eastNorth2;
        this.updatePixelPer();
    }

    public void displace(double d, double d2) {
        this.min = new EastNorth(this.min.east() + d, this.min.north() + d2);
        this.max = new EastNorth(this.max.east() + d, this.max.north() + d2);
    }

    public void resize(EastNorth eastNorth, double d) {
        this.min = this.min.interpolate(eastNorth, d);
        this.max = this.max.interpolate(eastNorth, d);
        this.updatePixelPer();
    }

    public void rotate(EastNorth eastNorth, double d) {
        if (this.angle == 0.0) {
            this.org_min = this.min;
            this.org_max = this.max;
        }
        this.angle += d;
        EastNorth eastNorth2 = this.org_min.interpolate(this.org_max, 0.5);
        EastNorth eastNorth3 = eastNorth2.rotate(eastNorth, this.angle);
        this.min.setLocation(this.org_min.east() + eastNorth3.east() - eastNorth2.east(), this.org_min.north() + eastNorth3.north() - eastNorth2.north());
        this.max.setLocation(this.org_max.east() + eastNorth3.east() - eastNorth2.east(), this.org_max.north() + eastNorth3.north() - eastNorth2.north());
        EastNorth eastNorth4 = new EastNorth(this.min.east(), this.max.north());
        EastNorth eastNorth5 = new EastNorth(this.max.east(), this.min.north());
        this.min = this.org_min.rotate(eastNorth3, this.angle);
        this.max = this.org_max.rotate(eastNorth3, this.angle);
        eastNorth4 = eastNorth4.rotate(eastNorth3, this.angle);
        eastNorth5 = eastNorth5.rotate(eastNorth3, this.angle);
        this.getNewBounding(this.min, this.max, eastNorth4, eastNorth5);
        this.rotated_image = GeorefImage.tilt(this.image, this.angle);
    }

    public static BufferedImage tilt(BufferedImage bufferedImage, double d) {
        double d2 = Math.abs(Math.sin(d));
        double d3 = Math.abs(Math.cos(d));
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        int n3 = (int)Math.floor((double)n * d3 + (double)n2 * d2);
        int n4 = (int)Math.floor((double)n2 * d3 + (double)n * d2);
        GraphicsConfiguration graphicsConfiguration = GeorefImage.getDefaultConfiguration();
        BufferedImage bufferedImage2 = graphicsConfiguration.createCompatibleImage(n3, n4, 3);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.translate((n3 - n) / 2, (n4 - n2) / 2);
        graphics2D.rotate(d, n / 2, n2 / 2);
        graphics2D.drawRenderedImage(bufferedImage, null);
        graphics2D.dispose();
        return bufferedImage2;
    }

    public static GraphicsConfiguration getDefaultConfiguration() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
        return graphicsDevice.getDefaultConfiguration();
    }

    private void getNewBounding(EastNorth eastNorth, EastNorth eastNorth2, EastNorth eastNorth3, EastNorth eastNorth4) {
        EastNorth[] eastNorthArray = new EastNorth[]{eastNorth, eastNorth2, eastNorth3, eastNorth4};
        double d = Double.MAX_VALUE;
        double d2 = Double.MAX_VALUE;
        double d3 = Double.MIN_VALUE;
        double d4 = Double.MIN_VALUE;
        for (int i = 0; i <= 3; ++i) {
            d = Math.min(eastNorthArray[i].east(), d);
            d2 = Math.min(eastNorthArray[i].north(), d2);
            d3 = Math.max(eastNorthArray[i].east(), d3);
            d4 = Math.max(eastNorthArray[i].north(), d4);
        }
        eastNorth.setLocation(d, d2);
        eastNorth2.setLocation(d3, d4);
    }

    public boolean contains(EastNorth eastNorth) {
        return this.min.east() <= eastNorth.east() && eastNorth.east() <= this.max.east() && this.min.north() <= eastNorth.north() && eastNorth.north() <= this.max.north();
    }

    public void paint(Graphics2D graphics2D, NavigatableComponent navigatableComponent, boolean bl, float f, boolean bl2) {
        if (this.image == null || this.min == null || this.max == null) {
            return;
        }
        BufferedImage bufferedImage = this.angle != 0.0 ? this.rotated_image : this.image;
        Point point = navigatableComponent.getPoint(this.min);
        Point point2 = navigatableComponent.getPoint(this.max);
        if (!graphics2D.hitClip(point.x, point2.y, point2.x - point.x, point.y - point2.y)) {
            return;
        }
        if (bl && f < 1.0f) {
            graphics2D.setComposite(AlphaComposite.getInstance(3, f));
        }
        if (bl2) {
            graphics2D.setColor(Color.green);
            graphics2D.drawRect(point.x, point2.y, point2.x - point.x, point.y - point2.y);
        }
        graphics2D.drawImage(bufferedImage, point.x, point2.y, point2.x, point.y, 0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), null);
        if (bl && f < 1.0f) {
            graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
        }
    }

    public boolean overlap(GeorefImage georefImage) {
        if (this.contains(georefImage.min) || this.contains(georefImage.max)) {
            return true;
        }
        return this.contains(new EastNorth(georefImage.min.east(), georefImage.max.north())) || this.contains(new EastNorth(georefImage.max.east(), georefImage.min.north()));
    }

    public void withdraw(GeorefImage georefImage) {
        double d;
        double d2 = georefImage.min.east() > this.min.east() ? georefImage.min.east() : this.min.east();
        double d3 = georefImage.max.east() < this.max.east() ? georefImage.max.east() : this.max.east();
        double d4 = georefImage.min.north() > this.min.north() ? georefImage.min.north() : this.min.north();
        double d5 = d = georefImage.max.north() < this.max.north() ? georefImage.max.north() : this.max.north();
        if (d - d4 > 0.0 && d3 - d2 > 0.0) {
            double d6 = (this.max.east() - this.min.east()) / (double)this.image.getWidth();
            double d7 = (this.max.north() - this.min.north()) / (double)this.image.getHeight();
            int n = (int)((d2 - this.min.east()) / d6);
            int n2 = (int)((this.max.north() - d) / d7);
            int n3 = Math.abs((int)((d3 - d2) / d6));
            int n4 = Math.abs((int)((d - d4) / d7));
            Graphics graphics = this.image.getGraphics();
            for (int i = n; i < n + n3; ++i) {
                for (int j = n2; j < n2 + n4; ++j) {
                    this.image.setRGB(i, j, 1);
                }
            }
            graphics.dispose();
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.max = (EastNorth)objectInputStream.readObject();
        this.min = (EastNorth)objectInputStream.readObject();
        this.image = ImageIO.read(ImageIO.createImageInputStream(objectInputStream));
        this.updatePixelPer();
    }

    private void updatePixelPer() {
        this.pixelPerEast = (double)this.image.getWidth() / (this.max.east() - this.min.east());
        this.pixelPerNorth = (double)this.image.getHeight() / (this.max.north() - this.min.north());
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.max);
        objectOutputStream.writeObject(this.min);
        ImageIO.write((RenderedImage)this.image, "png", ImageIO.createImageOutputStream(objectOutputStream));
    }

    public String toString() {
        return "GeorefImage[min=" + this.min + ", max=" + this.max + ", image" + this.image + "]";
    }
}

