/*
 * Decompiled with CFR 0.152.
 */
package cadastre_fr;

import cadastre_fr.CadastreGrabber;
import cadastre_fr.CadastreInterface;
import cadastre_fr.CadastrePlugin;
import cadastre_fr.DuplicateLayerException;
import cadastre_fr.EastNorthBound;
import cadastre_fr.SVGParser;
import cadastre_fr.SimplifyWay;
import cadastre_fr.WMSLayer;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.io.ProgressInputStream;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownloadSVGTask
extends PleaseWaitRunnable {
    private WMSLayer wmsLayer;
    private CadastreGrabber grabber = CadastrePlugin.cadastreGrabber;
    private CadastreInterface wmsInterface;
    private String svg = null;
    private EastNorthBound viewBox = null;

    public DownloadSVGTask(WMSLayer wMSLayer) {
        super(I18n.tr((String)"Downloading {0}", (Object[])new Object[]{wMSLayer.name}));
        this.wmsLayer = wMSLayer;
        this.wmsInterface = this.grabber.getWmsInterface();
    }

    public void realRun() throws IOException {
        Main.pleaseWaitDlg.currentAction.setText(I18n.tr((String)"Contacting WMS Server..."));
        try {
            if (this.wmsInterface.retrieveInterface(this.wmsLayer)) {
                this.svg = this.grabBoundary(this.wmsLayer.getCommuneBBox());
                if (this.svg == null) {
                    return;
                }
                Main.pleaseWaitDlg.currentAction.setText(I18n.tr((String)"Extract SVG ViewBox..."));
                this.getViewBox(this.svg);
                if (this.viewBox == null) {
                    return;
                }
                Main.pleaseWaitDlg.currentAction.setText(I18n.tr((String)"Extract best fitting boundary..."));
                this.createWay(this.svg);
            }
        }
        catch (DuplicateLayerException duplicateLayerException) {
            System.err.println("removed a duplicated layer");
        }
    }

    protected void cancel() {
        this.grabber.getWmsInterface().cancel();
    }

    protected void finish() {
    }

    private boolean getViewBox(String string) {
        double[] dArray = new SVGParser().getViewBox(string);
        if (dArray != null) {
            this.viewBox = new EastNorthBound(new EastNorth(dArray[0], dArray[1]), new EastNorth(dArray[0] + dArray[2], dArray[1] + dArray[3]));
            return true;
        }
        System.out.println("Unable to parse SVG data (viewBox)");
        return false;
    }

    private void createWay(String string) {
        Object object2;
        String[] stringArray = new SVGParser().getClosedPaths(string);
        ArrayList<Double> arrayList = new ArrayList<Double>();
        ArrayList<ArrayList<EastNorth>> arrayList2 = new ArrayList<ArrayList<EastNorth>>();
        for (int i = 0; i < stringArray.length; ++i) {
            ArrayList<EastNorth> arrayList3 = new ArrayList<EastNorth>();
            arrayList.add(this.createNodes(stringArray[i], arrayList3));
            arrayList2.add(arrayList3);
        }
        Double d = (Double)Collections.min(arrayList);
        int n = arrayList.indexOf(d);
        ArrayList<Node> arrayList4 = new ArrayList<Node>();
        for (Object object2 : (ArrayList)arrayList2.get(n)) {
            arrayList4.add(new Node(Main.proj.eastNorth2latlon((EastNorth)object2)));
        }
        Way way = new Way();
        object2 = new LinkedList();
        for (Node node : arrayList4) {
            object2.add(new AddCommand((OsmPrimitive)node));
            way.nodes.add(node);
        }
        way.nodes.add(way.nodes.get(0));
        double d2 = Double.parseDouble(Main.pref.get("cadastrewms.simplify-way-boundary", "1.0"));
        new SimplifyWay().simplifyWay(way, Main.ds, d2);
        object2.add(new AddCommand((OsmPrimitive)way));
        Main.main.undoRedo.add((Command)new SequenceCommand(I18n.tr((String)"Create boundary"), (Collection)object2));
        Main.map.repaint();
    }

    private double createNodes(String string, ArrayList<EastNorth> arrayList) {
        String[] stringArray = string.split("[MlZ ]");
        double d = Double.parseDouble(stringArray[1]);
        double d2 = Double.parseDouble(stringArray[2]);
        double d3 = Double.MAX_VALUE;
        double d4 = Double.MAX_VALUE;
        double d5 = Double.MIN_VALUE;
        double d6 = Double.MIN_VALUE;
        for (int i = 3; i < stringArray.length; i += 2) {
            double d7 = d += Double.parseDouble(stringArray[i]);
            double d8 = d2 += Double.parseDouble(stringArray[i + 1]);
            arrayList.add(new EastNorth(d7, d8));
            d4 = d4 > d7 ? d7 : d4;
            d3 = d3 > d8 ? d8 : d3;
            d6 = d6 < d7 ? d7 : d6;
            d5 = d5 < d8 ? d8 : d5;
        }
        double d9 = this.viewBox.min.getY() + (this.viewBox.max.getY() - this.viewBox.min.getY()) / 2.0;
        for (EastNorth eastNorth : arrayList) {
            eastNorth.setLocation(eastNorth.east(), 2.0 * d9 - eastNorth.north());
        }
        return Math.abs(d4 - this.viewBox.min.getX()) + Math.abs(d6 - this.viewBox.max.getX()) + Math.abs(d3 - this.viewBox.min.getY()) + Math.abs(d5 - this.viewBox.max.getY());
    }

    private String grabBoundary(EastNorthBound eastNorthBound) throws IOException {
        try {
            URL uRL = null;
            uRL = this.getURLsvg(eastNorthBound);
            System.out.println("grab:" + uRL);
            return this.grabSVG(uRL);
        }
        catch (MalformedURLException malformedURLException) {
            throw (IOException)new IOException(I18n.tr((String)"CadastreGrabber: Illegal url.")).initCause(malformedURLException);
        }
    }

    private URL getURLsvg(EastNorthBound eastNorthBound) throws MalformedURLException {
        String string = new String(this.wmsInterface.baseURL + "/scpc/wms?version=1.1&request=GetMap");
        string = string + "&layers=";
        string = string + "CDIF:COMMUNE";
        string = string + "&format=image/svg";
        string = string + "&bbox=" + eastNorthBound.min.east() + ",";
        string = string + eastNorthBound.min.north() + ",";
        string = string + eastNorthBound.max.east() + ",";
        string = string + eastNorthBound.max.north();
        string = string + "&width=800&height=600";
        string = string + "&styles=";
        string = string + "COMMUNE_90";
        System.out.println("URL=" + string);
        return new URL(string.replace(" ", "%20"));
    }

    private String grabSVG(URL uRL) throws IOException {
        this.wmsInterface.urlConn = (HttpURLConnection)uRL.openConnection();
        this.wmsInterface.urlConn.setRequestMethod("GET");
        this.wmsInterface.setCookie();
        ProgressInputStream progressInputStream = new ProgressInputStream((URLConnection)this.wmsInterface.urlConn, Main.pleaseWaitDlg);
        File file = new File(CadastrePlugin.cacheDir + "boundary.svg");
        String string = new String();
        try {
            if (file.exists()) {
                file.delete();
            }
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file, true));
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)progressInputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String string2 = "";
            while (null != (string2 = bufferedReader.readLine())) {
                string2 = string2 + "\n";
                bufferedOutputStream.write(string2.getBytes());
                string = string + string2;
            }
            bufferedOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.out);
        }
        progressInputStream.close();
        return string;
    }

    public static void download(WMSLayer wMSLayer) {
        if (!CadastrePlugin.autoSourcing) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Please, enable auto-sourcing and check cadastre millesime."));
            return;
        }
        Main.worker.execute((Runnable)((Object)new DownloadSVGTask(wMSLayer)));
    }
}

