/*
 * Decompiled with CFR 0.152.
 */
package cadastre_fr;

import cadastre_fr.CadastreGrabber;
import cadastre_fr.CadastreInterface;
import cadastre_fr.CadastrePlugin;
import cadastre_fr.DuplicateLayerException;
import cadastre_fr.EastNorthBound;
import cadastre_fr.SVGParser;
import cadastre_fr.SimplifyWay;
import cadastre_fr.WMSLayer;
import java.awt.geom.Point2D;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.io.ProgressInputStream;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownloadSVGBuilding
extends PleaseWaitRunnable {
    private WMSLayer wmsLayer;
    private CadastreGrabber grabber = CadastrePlugin.cadastreGrabber;
    private CadastreInterface wmsInterface;
    private String svg = null;
    private static EastNorthBound currentView = null;
    private EastNorthBound viewBox = null;

    public DownloadSVGBuilding(WMSLayer wMSLayer) {
        super(I18n.tr((String)"Downloading {0}", (Object[])new Object[]{wMSLayer.name}));
        this.wmsLayer = wMSLayer;
        this.wmsInterface = this.grabber.getWmsInterface();
    }

    public void realRun() throws IOException {
        Main.pleaseWaitDlg.currentAction.setText(I18n.tr((String)"Contacting WMS Server..."));
        try {
            if (this.wmsInterface.retrieveInterface(this.wmsLayer)) {
                this.svg = this.grabBoundary(currentView);
                if (this.svg == null) {
                    return;
                }
                this.getViewBox(this.svg);
                if (this.viewBox == null) {
                    return;
                }
                this.createBuildings(this.svg);
            }
        }
        catch (DuplicateLayerException duplicateLayerException) {
            System.err.println("removed a duplicated layer");
        }
    }

    protected void cancel() {
        this.grabber.getWmsInterface().cancel();
    }

    protected void finish() {
    }

    private boolean getViewBox(String string) {
        double[] dArray = new SVGParser().getViewBox(string);
        if (dArray != null) {
            this.viewBox = new EastNorthBound(new EastNorth(dArray[0], dArray[1]), new EastNorth(dArray[0] + dArray[2], dArray[1] + dArray[3]));
            return true;
        }
        System.out.println("Unable to parse SVG data (viewBox)");
        return false;
    }

    private void createBuildings(String string) {
        Way way3;
        Object object;
        String[] stringArray = new SVGParser().getClosedPaths(string);
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < stringArray.length; ++i) {
            object = new ArrayList();
            this.createNodes(stringArray[i], (ArrayList<EastNorth>)object);
            if (((ArrayList)object).size() <= 2) continue;
            arrayList.add(object);
        }
        DataSet dataSet = new DataSet();
        for (ArrayList node : arrayList) {
            way3 = new Way();
            for (EastNorth eastNorth : node) {
                Node node2 = new Node(Main.proj.eastNorth2latlon(eastNorth));
                Node node3 = this.checkNearestNode(node2, dataSet.nodes);
                if (node3 == node2) {
                    dataSet.addPrimitive((OsmPrimitive)node3);
                }
                way3.nodes.add(node3);
            }
            way3.nodes.add(way3.nodes.get(0));
            dataSet.addPrimitive((OsmPrimitive)way3);
        }
        for (Way way2 : dataSet.ways) {
            new SimplifyWay().simplifyWay(way2, dataSet, 0.5);
        }
        for (Node node : dataSet.nodes) {
            way3 = this.checkNearestNode(node, Main.ds.nodes);
            if (way3 == node) continue;
            for (EastNorth eastNorth : dataSet.ways) {
                int n = 0;
                for (Node node4 : eastNorth.nodes) {
                    if (node4 != node) continue;
                    node4 = way3;
                    ++n;
                }
                if (eastNorth.nodes.size() != n) continue;
                eastNorth.delete(true);
            }
            node.delete(true);
        }
        object = new LinkedList();
        for (Way way3 : dataSet.nodes) {
            if (way3.deleted) continue;
            object.add(new AddCommand((OsmPrimitive)way3));
        }
        for (Way way3 : dataSet.ways) {
            if (way3.deleted) continue;
            object.add(new AddCommand((OsmPrimitive)way3));
        }
        Main.main.undoRedo.add((Command)new SequenceCommand(I18n.tr((String)"Create buildings"), (Collection)object));
        Main.map.repaint();
    }

    private void createNodes(String string, ArrayList<EastNorth> arrayList) {
        String[] stringArray = string.split("[MlZ ]");
        double d = Double.parseDouble(stringArray[1]);
        double d2 = Double.parseDouble(stringArray[2]);
        for (int i = 3; i < stringArray.length; i += 2) {
            if (stringArray[i].equals("")) {
                arrayList.clear();
                return;
            }
            double d3 = d += Double.parseDouble(stringArray[i]);
            double d4 = d2 += Double.parseDouble(stringArray[i + 1]);
            arrayList.add(new EastNorth(d3, d4));
        }
        double d5 = this.viewBox.min.getY() + (this.viewBox.max.getY() - this.viewBox.min.getY()) / 2.0;
        for (EastNorth eastNorth : arrayList) {
            eastNorth.setLocation(eastNorth.east(), 2.0 * d5 - eastNorth.north());
        }
    }

    private Node checkNearestNode(Node node, Collection<Node> collection) {
        double d = 0.05;
        for (Node node2 : collection) {
            double d2;
            if (node2.deleted || node2.incomplete || !((d2 = node2.eastNorth.distance((Point2D)node.eastNorth)) < d)) continue;
            return node2;
        }
        return node;
    }

    private String grabBoundary(EastNorthBound eastNorthBound) throws IOException {
        try {
            URL uRL = null;
            uRL = this.getURLsvg(eastNorthBound);
            System.out.println("grab:" + uRL);
            return this.grabSVG(uRL);
        }
        catch (MalformedURLException malformedURLException) {
            throw (IOException)new IOException(I18n.tr((String)"CadastreGrabber: Illegal url.")).initCause(malformedURLException);
        }
    }

    private URL getURLsvg(EastNorthBound eastNorthBound) throws MalformedURLException {
        String string = new String(this.wmsInterface.baseURL + "/scpc/wms?version=1.1&request=GetMap");
        string = string + "&layers=";
        string = string + "CDIF:LS2";
        string = string + "&format=image/svg";
        string = string + "&bbox=" + eastNorthBound.min.east() + ",";
        string = string + eastNorthBound.min.north() + ",";
        string = string + eastNorthBound.max.east() + ",";
        string = string + eastNorthBound.max.north();
        string = string + "&width=800&height=600";
        string = string + "&exception=application/vnd.ogc.se_inimage";
        string = string + "&styles=";
        string = string + "LS2_90";
        System.out.println("URL=" + string);
        return new URL(string.replace(" ", "%20"));
    }

    private String grabSVG(URL uRL) throws IOException {
        this.wmsInterface.urlConn = (HttpURLConnection)uRL.openConnection();
        this.wmsInterface.urlConn.setRequestMethod("GET");
        this.wmsInterface.setCookie();
        ProgressInputStream progressInputStream = new ProgressInputStream((URLConnection)this.wmsInterface.urlConn, Main.pleaseWaitDlg);
        File file = new File(CadastrePlugin.cacheDir + "building.svg");
        String string = new String();
        try {
            if (file.exists()) {
                file.delete();
            }
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file, true));
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)progressInputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String string2 = "";
            while (null != (string2 = bufferedReader.readLine())) {
                string2 = string2 + "\n";
                bufferedOutputStream.write(string2.getBytes());
                string = string + string2;
            }
            bufferedOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.out);
        }
        progressInputStream.close();
        return string;
    }

    public static void download(WMSLayer wMSLayer) {
        MapView mapView = Main.map.mapView;
        currentView = new EastNorthBound(mapView.getEastNorth(0, mapView.getHeight()), mapView.getEastNorth(mapView.getWidth(), 0));
        if (DownloadSVGBuilding.currentView.max.east() - DownloadSVGBuilding.currentView.min.east() > 1000.0 || DownloadSVGBuilding.currentView.max.north() - DownloadSVGBuilding.currentView.min.north() > 1000.0) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"To avoid cadastre WMS overload,\nbuilding import size is limited to 1 km2 max."));
            return;
        }
        if (!CadastrePlugin.autoSourcing) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Please, enable auto-sourcing and check cadastre millesime."));
            return;
        }
        Main.worker.execute((Runnable)((Object)new DownloadSVGBuilding(wMSLayer)));
    }
}

