/*
 * Decompiled with CFR 0.152.
 */
package cadastre_fr;

import cadastre_fr.CadastreGrabber;
import cadastre_fr.CadastrePreferenceSetting;
import cadastre_fr.CheckSourceUploadHook;
import cadastre_fr.MenuActionGrab;
import cadastre_fr.MenuActionLambertZone;
import cadastre_fr.MenuActionLoadFromCache;
import cadastre_fr.MenuActionNewLocation;
import cadastre_fr.MenuActionResetCookie;
import cadastre_fr.WMSAdjustAction;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.UploadAction;
import org.openstreetmap.josm.data.projection.Lambert;
import org.openstreetmap.josm.gui.IconToggleButton;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.tools.I18n;

public class CadastrePlugin
extends Plugin {
    static String VERSION = "1.0";
    static JMenu cadastreJMenu;
    public static CadastreGrabber cadastreGrabber;
    public static String source;
    public static boolean autoSourcing;
    public static boolean pluginUsed;
    public static String cacheDir;
    public static boolean alterColors;
    public static boolean backgroundTransparent;
    public static float transparency;
    public static boolean drawBoundaries;
    private static boolean menuEnabled;

    public CadastrePlugin() throws Exception {
        System.out.println("Pluging \"cadastre-fr\" started...");
        if (Main.pref.get("cadastrewms.cacheDir").equals("")) {
            cacheDir = Main.pref.getPreferencesDir() + "plugins/cadastrewms/";
        } else {
            cacheDir = Main.pref.get("cadastrewms.cacheDir");
            if (cacheDir.charAt(cacheDir.length() - 1) != '\\') {
                cacheDir = cacheDir + '\\';
            }
        }
        System.out.println("current cache directory: " + cacheDir);
        CadastrePlugin.refreshConfiguration();
        this.refreshMenu();
        LinkedList linkedList = ((UploadAction)Main.main.menu.upload).uploadHooks;
        linkedList.add(0, new CheckSourceUploadHook());
    }

    public void refreshMenu() throws Exception {
        boolean bl = Main.proj.toString().equals(new Lambert().toString());
        MainMenu mainMenu = Main.main.menu;
        if (cadastreJMenu == null) {
            cadastreJMenu = new JMenu(I18n.tr((String)"Cadastre"));
            cadastreJMenu.setMnemonic(67);
            mainMenu.add((Component)cadastreJMenu, mainMenu.getMenuCount() - 2);
            if (bl) {
                MenuActionGrab menuActionGrab = new MenuActionGrab();
                JMenuItem jMenuItem = new JMenuItem((Action)((Object)menuActionGrab));
                KeyStroke keyStroke = menuActionGrab.getShortcut().getKeyStroke();
                if (keyStroke != null) {
                    jMenuItem.setAccelerator(keyStroke);
                }
                JMenuItem jMenuItem2 = new JMenuItem((Action)((Object)new MenuActionNewLocation()));
                final JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(I18n.tr((String)"Auto sourcing"));
                jCheckBoxMenuItem.setSelected(autoSourcing);
                jCheckBoxMenuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        Main.pref.put("cadastrewms.autosourcing", jCheckBoxMenuItem.isSelected());
                        autoSourcing = jCheckBoxMenuItem.isSelected();
                    }
                });
                JMenuItem jMenuItem3 = new JMenuItem((Action)((Object)new MenuActionResetCookie()));
                JMenuItem jMenuItem4 = new JMenuItem((Action)((Object)new MenuActionLambertZone()));
                JMenuItem jMenuItem5 = new JMenuItem((Action)((Object)new MenuActionLoadFromCache()));
                cadastreJMenu.add(jMenuItem);
                cadastreJMenu.add(jMenuItem2);
                cadastreJMenu.add(jCheckBoxMenuItem);
                cadastreJMenu.add(jMenuItem3);
                cadastreJMenu.add(jMenuItem4);
                cadastreJMenu.add(jMenuItem5);
            } else {
                JMenuItem jMenuItem = new JMenuItem(I18n.tr((String)"Invalid projection"));
                jMenuItem.setToolTipText(I18n.tr((String)"Change the projection to {0} first.", (Object[])new Object[]{new Lambert().toString()}));
                jMenuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"To enable the cadastre WMS plugin, change\nthe JOSM projection to Lambert and restart"));
                    }
                });
                cadastreJMenu.add(jMenuItem);
            }
        }
        this.setEnabledAll(menuEnabled);
    }

    public static void refreshConfiguration() {
        source = Main.pref.get("cadastrewms.source", "cadastre-dgi-fr source : Direction G\u00e9n\u00e9rale des Imp\u00f4ts - Cadastre ; mise \u00e0 jour : AAAA");
        autoSourcing = Main.pref.getBoolean("cadastrewms.autosourcing", true);
        alterColors = Main.pref.getBoolean("cadastrewms.alterColors");
        drawBoundaries = Main.pref.getBoolean("cadastrewms.drawBoundaries", false);
        if (alterColors) {
            backgroundTransparent = Main.pref.getBoolean("cadastrewms.backgroundTransparent");
            transparency = Float.parseFloat(Main.pref.get("cadastrewms.brightness", "1.0f"));
        } else {
            backgroundTransparent = false;
            transparency = 1.0f;
        }
    }

    public PreferenceSetting getPreferenceSetting() {
        return new CadastrePreferenceSetting();
    }

    private void setEnabledAll(boolean bl) {
        for (int i = 0; i < cadastreJMenu.getItemCount(); ++i) {
            JMenuItem jMenuItem = cadastreJMenu.getItem(i);
            if (jMenuItem == null) continue;
            if (jMenuItem.getText().equals(MenuActionGrab.name)) {
                jMenuItem.setEnabled(bl);
                continue;
            }
            if (!jMenuItem.getText().equals(MenuActionLambertZone.name)) continue;
            jMenuItem.setEnabled(!bl);
        }
        menuEnabled = bl;
    }

    public void mapFrameInitialized(MapFrame mapFrame, MapFrame mapFrame2) {
        if (cadastreJMenu != null) {
            if (mapFrame == null && mapFrame2 != null) {
                this.setEnabledAll(true);
                Main.map.addMapMode(new IconToggleButton((Action)((Object)new WMSAdjustAction(Main.map))));
            } else if (mapFrame != null && mapFrame2 == null) {
                this.setEnabledAll(false);
                Lambert.layoutZone = -1;
            }
        }
    }

    static {
        cadastreGrabber = new CadastreGrabber();
        source = "";
        autoSourcing = false;
        pluginUsed = false;
        cacheDir = null;
        alterColors = false;
        backgroundTransparent = false;
        transparency = 1.0f;
        drawBoundaries = false;
        menuEnabled = false;
    }
}

