/*
 * Decompiled with CFR 0.152.
 */
package cadastre_fr;

import cadastre_fr.CadastreGrabber;
import cadastre_fr.DuplicateLayerException;
import cadastre_fr.EastNorthBound;
import cadastre_fr.WMSLayer;
import java.awt.GridBagLayout;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class CadastreInterface {
    public boolean downloadCancelled = false;
    public HttpURLConnection urlConn = null;
    private CadastreGrabber cadastreGrabber;
    private String cookie;
    private String interfaceRef = null;
    private URL searchFormURL;
    private Vector<String> listOfCommunes = new Vector();
    private Vector<String> listOfTA = new Vector();
    final String baseURL = "http://www.cadastre.gouv.fr";
    final String cImageFormat = "Cette commune est au format ";
    final String cCommuneListStart = "<select name=\"codeCommune\"";
    final String cCommuneListEnd = "</select>";
    final String c0ptionListStart = "<option value=\"";
    final String cOptionListEnd = "</option>";
    final String cBBoxCommunStart = "new GeoBox(";
    final String cBBoxCommunEnd = ")";
    final String cInterfaceVector = "afficherCarteCommune.do";
    final String cInterfaceRaster = "afficherCarteTa.do";

    CadastreInterface(CadastreGrabber cadastreGrabber) {
        this.cadastreGrabber = cadastreGrabber;
    }

    public boolean retrieveInterface(WMSLayer wMSLayer) throws DuplicateLayerException {
        if (wMSLayer.name.equals("")) {
            return false;
        }
        this.downloadCancelled = false;
        try {
            if (this.cookie == null || !wMSLayer.name.equals(this.cadastreGrabber.getLastWMSLayerName())) {
                this.getCookie();
                this.getInterface(wMSLayer);
                this.cadastreGrabber.setLastWMSLayerName(wMSLayer.name);
            }
            this.openInterface();
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Town/city {0} not found or not available in WMS.\nPlease check its availibility on www.cadastre.gouv.fr", (Object[])new Object[]{wMSLayer.getLocation()}));
            return false;
        }
        return true;
    }

    private void getCookie() throws IOException {
        try {
            this.searchFormURL = new URL("http://www.cadastre.gouv.fr/scpc/rechercherPlan.do");
            this.urlConn = (HttpURLConnection)this.searchFormURL.openConnection();
            this.urlConn.setRequestMethod("GET");
            this.urlConn.connect();
            if (this.urlConn.getResponseCode() != 200) {
                throw new IOException("Cannot get Cadastre cookie.");
            }
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.urlConn.getInputStream()));
            while (bufferedReader.readLine() != null) {
            }
            String string = null;
            int n = 1;
            while ((string = this.urlConn.getHeaderFieldKey(n)) != null) {
                if (string.equals("Set-Cookie")) {
                    this.cookie = this.urlConn.getHeaderField(n);
                    this.cookie = this.cookie.substring(0, this.cookie.indexOf(";"));
                    System.out.println("Cookie=" + this.cookie);
                }
                ++n;
            }
        }
        catch (MalformedURLException malformedURLException) {
            throw (IOException)new IOException("Illegal url.").initCause(malformedURLException);
        }
    }

    public void resetCookie() {
        this.cadastreGrabber.setLastWMSLayerName(null);
    }

    public void resetCookieIfNewLayer(String string) {
        if (!string.equals(this.cadastreGrabber.getLastWMSLayerName())) {
            this.resetCookie();
        }
    }

    public void setCookie() {
        this.urlConn.setRequestProperty("Cookie", this.cookie);
    }

    private void getInterface(WMSLayer wMSLayer) throws IOException, DuplicateLayerException {
        this.interfaceRef = this.postForm(wMSLayer, "");
        if (this.interfaceRef == null) {
            if (!wMSLayer.getCodeCommune().equals("")) {
                this.interfaceRef = this.postForm(wMSLayer, wMSLayer.getCodeCommune());
            } else {
                if (this.listOfCommunes.size() > 1) {
                    wMSLayer.setCodeCommune(this.selectCommuneDialog());
                    this.checkLayerDuplicates(wMSLayer);
                    this.interfaceRef = this.postForm(wMSLayer, wMSLayer.getCodeCommune());
                }
                if (wMSLayer.isRaster() && this.listOfTA.size() > 1) {
                    wMSLayer.setCodeCommune(this.selectTADialog());
                    this.checkLayerDuplicates(wMSLayer);
                    this.interfaceRef = this.buildRasterInterfaceRef(wMSLayer.getCodeCommune());
                }
            }
        }
        if (this.interfaceRef == null) {
            throw new IOException("Town/city " + wMSLayer.getLocation() + " not found.");
        }
    }

    private void openInterface() throws IOException {
        try {
            URL uRL = new URL("http://www.cadastre.gouv.fr/scpc/" + this.interfaceRef);
            this.urlConn = (HttpURLConnection)uRL.openConnection();
            this.urlConn.setRequestMethod("GET");
            this.setCookie();
            this.urlConn.connect();
            if (this.urlConn.getResponseCode() != 200) {
                throw new IOException("Cannot open Cadastre interface. GET response:" + this.urlConn.getResponseCode());
            }
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.urlConn.getInputStream()));
            while (bufferedReader.readLine() != null) {
            }
            System.out.println("GET to open interface sent");
        }
        catch (MalformedURLException malformedURLException) {
            throw (IOException)new IOException("CadastreGrabber: Illegal url.").initCause(malformedURLException);
        }
    }

    private String postForm(WMSLayer wMSLayer, String string) throws IOException {
        try {
            int n;
            int n2;
            String string2 = null;
            String string3 = null;
            this.listOfCommunes.clear();
            this.listOfTA.clear();
            String string4 = "numerovoie=";
            string4 = string4 + "&indiceRepetition=";
            string4 = string4 + "&nomvoie=";
            string4 = string4 + "&lieuDit=";
            if (string == "") {
                string4 = string4 + "&ville=" + new String(URLEncoder.encode(wMSLayer.getLocation(), "UTF-8"));
                string4 = string4 + "&codePostal=";
            } else {
                string4 = string4 + "&codeCommune=" + string;
            }
            string4 = string4 + "&codeDepartement=";
            string4 = string4 + "&nbResultatParPage=10";
            this.urlConn = (HttpURLConnection)this.searchFormURL.openConnection();
            this.urlConn.setRequestMethod("POST");
            this.urlConn.setDoOutput(true);
            this.urlConn.setDoInput(true);
            this.setCookie();
            OutputStream outputStream = this.urlConn.getOutputStream();
            outputStream.write(string4.getBytes());
            outputStream.flush();
            outputStream.close();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.urlConn.getInputStream()));
            while ((string2 = bufferedReader.readLine()) != null) {
                string3 = string3 + string2;
            }
            bufferedReader.close();
            this.urlConn.disconnect();
            System.out.println("POST=" + string3);
            if (string3.indexOf("Cette commune est au format ") != -1) {
                n2 = string3.indexOf("Cette commune est au format ");
                n = string3.indexOf(".", n2);
                wMSLayer.setRaster(string3.substring(n2 + "Cette commune est au format ".length(), n).equals("image"));
            }
            if (!wMSLayer.isRaster() && string3.indexOf("afficherCarteCommune.do") != -1) {
                string3 = string3.substring(string3.indexOf("afficherCarteCommune.do"), string3.length());
                string3 = string3.substring(0, string3.indexOf("'"));
                System.out.println("interface ref.:" + string3);
                return string3;
            }
            if (wMSLayer.isRaster() && string3.indexOf("afficherCarteTa.do") != -1) {
                this.parseTAList(string3.substring(string3.indexOf("afficherCarteTa.do")));
                if (this.listOfTA.size() == 1) {
                    wMSLayer.setCodeCommune(this.listOfTA.firstElement());
                    return this.buildRasterInterfaceRef(this.listOfTA.firstElement());
                }
                return null;
            }
            if (string3.indexOf("<select name=\"codeCommune\"") != -1 && string3.indexOf("</select>") != -1) {
                n2 = string3.indexOf("<select name=\"codeCommune\"");
                n = string3.indexOf("</select>", n2);
                this.parseCommuneList(string3.substring(n2, n));
            }
        }
        catch (MalformedURLException malformedURLException) {
            throw (IOException)new IOException("Illegal url.").initCause(malformedURLException);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    private void parseCommuneList(String string) {
        if (string.indexOf("<option value=\"") != -1) {
            while (string.indexOf("<option value=\"") != -1) {
                int n = string.indexOf("<option value=\"");
                int n2 = string.indexOf("</option>", n + "<option value=\"".length());
                int n3 = string.indexOf("\"", n + "<option value=\"".length());
                if (n2 != -1 && n3 > n + "<option value=\"".length()) {
                    String string2 = new String(string.substring(n + "<option value=\"".length() - 1, n2));
                    if (string2.indexOf(">") != -1) {
                        System.out.println("parse " + string2);
                        this.listOfCommunes.add(string2);
                    } else {
                        System.err.println("unable to parse commune string:" + string2);
                    }
                }
                string = string.substring(n2 + "</option>".length());
            }
        }
    }

    private void parseTAList(String string) {
        while (string.indexOf("afficherCarteTa.do") != -1) {
            string = string.substring(string.indexOf("afficherCarteTa.do"));
            String string2 = string.substring(0, string.indexOf("'"));
            if (!this.listOfTA.contains(string2 = string2.substring(string2.indexOf("=") + 1))) {
                System.out.println("parse " + string2);
                this.listOfTA.add(string2);
            }
            string = string.substring("afficherCarteTa.do".length());
        }
    }

    private String selectCommuneDialog() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        String[] stringArray = new String[this.listOfCommunes.size() + 1];
        stringArray[0] = I18n.tr((String)"Choose from...");
        for (int i = 0; i < this.listOfCommunes.size(); ++i) {
            stringArray[i + 1] = this.listOfCommunes.elementAt(i).substring(this.listOfCommunes.elementAt(i).indexOf(">") + 1);
        }
        JComboBox<String> jComboBox = new JComboBox<String>(stringArray);
        jPanel.add(jComboBox, GBC.eol().fill(2).insets(10, 0, 0, 0));
        JOptionPane jOptionPane = new JOptionPane(jPanel, 1, 2, null){
            private static final long serialVersionUID = 1L;
        };
        jOptionPane.createDialog(Main.parent, I18n.tr((String)"Select commune")).setVisible(true);
        if (!Integer.valueOf(0).equals(jOptionPane.getValue())) {
            return null;
        }
        String string = this.listOfCommunes.elementAt(jComboBox.getSelectedIndex() - 1);
        return string.substring(1, string.indexOf(">") - 2);
    }

    private String selectTADialog() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JComboBox<String> jComboBox = new JComboBox<String>(this.listOfTA);
        jPanel.add(jComboBox, GBC.eol().fill(2).insets(10, 0, 0, 0));
        JOptionPane jOptionPane = new JOptionPane(jPanel, 1, 2, null){
            private static final long serialVersionUID = 1L;
        };
        jOptionPane.createDialog(Main.parent, I18n.tr((String)"Select Tableau d'Assemblage")).setVisible(true);
        if (!Integer.valueOf(0).equals(jOptionPane.getValue())) {
            return null;
        }
        String string = this.listOfTA.elementAt(jComboBox.getSelectedIndex());
        return string;
    }

    private String buildRasterInterfaceRef(String string) {
        return "afficherCarteTa.do?f=" + string;
    }

    public EastNorthBound retrieveCommuneBBox() throws IOException {
        if (this.interfaceRef == null) {
            return null;
        }
        String string = null;
        String string2 = null;
        String string3 = "http://www.cadastre.gouv.fr/scpc/" + this.interfaceRef;
        string3 = string3 + "&dontSaveLastForward&keepVolatileSession=";
        this.searchFormURL = new URL(string3);
        System.out.println("HEAD:" + string3);
        this.urlConn = (HttpURLConnection)this.searchFormURL.openConnection();
        this.urlConn.setRequestMethod("GET");
        this.setCookie();
        this.urlConn.connect();
        if (this.urlConn.getResponseCode() != 200) {
            throw new IOException("Cannot get Cadastre response.");
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.urlConn.getInputStream()));
        while ((string = bufferedReader.readLine()) != null) {
            string2 = string2 + string;
        }
        bufferedReader.close();
        this.urlConn.disconnect();
        return this.parseBBoxCommune(string2);
    }

    private EastNorthBound parseBBoxCommune(String string) {
        if (string.indexOf("new GeoBox(") != -1) {
            string = string.substring(string.indexOf("new GeoBox("));
            int n = string.indexOf(",");
            double d = Double.parseDouble(string.substring("new GeoBox(".length(), n));
            int n2 = string.indexOf(",", n + 1);
            double d2 = Double.parseDouble(string.substring(n + 1, n2));
            int n3 = string.indexOf(",", n2 + 1);
            double d3 = Double.parseDouble(string.substring(n2 + 1, n3));
            int n4 = string.indexOf(")", n3 + 1);
            double d4 = Double.parseDouble(string.substring(n3 + 1, n4));
            return new EastNorthBound(new EastNorth(d, d2), new EastNorth(d3, d4));
        }
        return null;
    }

    private void checkLayerDuplicates(WMSLayer wMSLayer) throws DuplicateLayerException {
        if (Main.map != null) {
            for (Layer layer : Main.map.mapView.getAllLayers()) {
                if (!(layer instanceof WMSLayer) || !layer.name.equals(wMSLayer.name) || layer == wMSLayer) continue;
                System.out.println("Try to grab into a new layer when " + wMSLayer.name + " is already opened.");
                Main.map.mapView.removeLayer((Layer)wMSLayer);
                throw new DuplicateLayerException();
            }
        }
    }

    public void cancel() {
        Main.pleaseWaitDlg.currentAction.setText(I18n.tr((String)"Aborting..."));
        if (this.urlConn != null) {
            this.urlConn.setConnectTimeout(1);
            this.urlConn.setReadTimeout(1);
        }
        this.downloadCancelled = true;
        this.cadastreGrabber.setLastWMSLayerName(null);
    }
}

